# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import deep_union_pydantic_dicts, pydantic_v1
from ...commons.types.model_usage_unit import ModelUsageUnit
from ...commons.types.pricing_tier_input import PricingTierInput


class CreateModelRequest(pydantic_v1.BaseModel):
    model_name: str = pydantic_v1.Field(alias="modelName")
    """
    Name of the model definition. If multiple with the same name exist, they are applied in the following order: (1) custom over built-in, (2) newest according to startTime where model.startTime<observation.startTime
    """

    match_pattern: str = pydantic_v1.Field(alias="matchPattern")
    """
    Regex pattern which matches this model definition to generation.model. Useful in case of fine-tuned models. If you want to exact match, use `(?i)^modelname$`
    """

    start_date: typing.Optional[dt.datetime] = pydantic_v1.Field(
        alias="startDate", default=None
    )
    """
    Apply only to generations which are newer than this ISO date.
    """

    unit: typing.Optional[ModelUsageUnit] = pydantic_v1.Field(default=None)
    """
    Unit used by this model.
    """

    input_price: typing.Optional[float] = pydantic_v1.Field(
        alias="inputPrice", default=None
    )
    """
    Deprecated. Use 'pricingTiers' instead. Price (USD) per input unit. Creates a default tier if pricingTiers not provided.
    """

    output_price: typing.Optional[float] = pydantic_v1.Field(
        alias="outputPrice", default=None
    )
    """
    Deprecated. Use 'pricingTiers' instead. Price (USD) per output unit. Creates a default tier if pricingTiers not provided.
    """

    total_price: typing.Optional[float] = pydantic_v1.Field(
        alias="totalPrice", default=None
    )
    """
    Deprecated. Use 'pricingTiers' instead. Price (USD) per total units. Cannot be set if input or output price is set. Creates a default tier if pricingTiers not provided.
    """

    pricing_tiers: typing.Optional[typing.List[PricingTierInput]] = pydantic_v1.Field(
        alias="pricingTiers", default=None
    )
    """
    Optional. Array of pricing tiers for this model.
    
    Use pricing tiers for all models - both those with threshold-based pricing variations and those with simple flat pricing:
    
    - For models with standard flat pricing: Create a single default tier with your prices
      (e.g., one tier with isDefault=true, priority=0, conditions=[], and your standard prices)
    
    - For models with threshold-based pricing: Create a default tier plus additional conditional tiers
      (e.g., default tier for standard usage + high-volume tier for usage above certain thresholds)
    
    Requirements:
    - Cannot be provided with flat prices (inputPrice/outputPrice/totalPrice) - use one approach or the other
    - Must include exactly one default tier with isDefault=true, priority=0, and conditions=[]
    - All tier names and priorities must be unique within the model
    - Each tier must define at least one price
    
    If omitted, you must provide flat prices instead (inputPrice/outputPrice/totalPrice),
    which will automatically create a single default tier named "Standard".
    """

    tokenizer_id: typing.Optional[str] = pydantic_v1.Field(
        alias="tokenizerId", default=None
    )
    """
    Optional. Tokenizer to be applied to observations which match to this model. See docs for more details.
    """

    tokenizer_config: typing.Optional[typing.Any] = pydantic_v1.Field(
        alias="tokenizerConfig", default=None
    )
    """
    Optional. Configuration for the selected tokenizer. Needs to be JSON. See docs for more details.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults_exclude_unset: typing.Any = {
            "by_alias": True,
            "exclude_unset": True,
            **kwargs,
        }
        kwargs_with_defaults_exclude_none: typing.Any = {
            "by_alias": True,
            "exclude_none": True,
            **kwargs,
        }

        return deep_union_pydantic_dicts(
            super().dict(**kwargs_with_defaults_exclude_unset),
            super().dict(**kwargs_with_defaults_exclude_none),
        )

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        populate_by_name = True
        extra = pydantic_v1.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
