"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from plaid.model.account_balance import AccountBalance
    from plaid.model.account_base import AccountBase
    from plaid.model.account_identity_match_score_all_of import AccountIdentityMatchScoreAllOf
    from plaid.model.account_subtype import AccountSubtype
    from plaid.model.account_type import AccountType
    from plaid.model.address_match_score import AddressMatchScore
    from plaid.model.email_address_match_score import EmailAddressMatchScore
    from plaid.model.name_match_score import NameMatchScore
    from plaid.model.phone_number_match_score import PhoneNumberMatchScore
    globals()['AccountBalance'] = AccountBalance
    globals()['AccountBase'] = AccountBase
    globals()['AccountIdentityMatchScoreAllOf'] = AccountIdentityMatchScoreAllOf
    globals()['AccountSubtype'] = AccountSubtype
    globals()['AccountType'] = AccountType
    globals()['AddressMatchScore'] = AddressMatchScore
    globals()['EmailAddressMatchScore'] = EmailAddressMatchScore
    globals()['NameMatchScore'] = NameMatchScore
    globals()['PhoneNumberMatchScore'] = PhoneNumberMatchScore


class AccountIdentityMatchScore(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('verification_status',): {
            'AUTOMATICALLY_VERIFIED': "automatically_verified",
            'PENDING_AUTOMATIC_VERIFICATION': "pending_automatic_verification",
            'PENDING_MANUAL_VERIFICATION': "pending_manual_verification",
            'MANUALLY_VERIFIED': "manually_verified",
            'VERIFICATION_EXPIRED': "verification_expired",
            'VERIFICATION_FAILED': "verification_failed",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'account_id': (str,),  # noqa: E501
            'balances': (AccountBalance,),  # noqa: E501
            'mask': (str, none_type,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'official_name': (str, none_type,),  # noqa: E501
            'type': (AccountType,),  # noqa: E501
            'subtype': (AccountSubtype,),  # noqa: E501
            'verification_status': (str,),  # noqa: E501
            'legal_name': (NameMatchScore,),  # noqa: E501
            'phone_number': (PhoneNumberMatchScore,),  # noqa: E501
            'email_address': (EmailAddressMatchScore,),  # noqa: E501
            'address': (AddressMatchScore,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'account_id': 'account_id',  # noqa: E501
        'balances': 'balances',  # noqa: E501
        'mask': 'mask',  # noqa: E501
        'name': 'name',  # noqa: E501
        'official_name': 'official_name',  # noqa: E501
        'type': 'type',  # noqa: E501
        'subtype': 'subtype',  # noqa: E501
        'verification_status': 'verification_status',  # noqa: E501
        'legal_name': 'legal_name',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'email_address': 'email_address',  # noqa: E501
        'address': 'address',  # noqa: E501
    }

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, account_id, balances, mask, name, official_name, type, subtype, *args, **kwargs):  # noqa: E501
        """AccountIdentityMatchScore - a model defined in OpenAPI

        Args:
            account_id (str): Plaid’s unique identifier for the account. This value will not change unless Plaid can't reconcile the account with the data returned by the financial institution. This may occur, for example, when the name of the account changes. If this happens a new `account_id` will be assigned to the account.  The `account_id` can also change if the `access_token` is deleted and the same credentials that were used to generate that `access_token` are used to generate a new `access_token` on a later date. In that case, the new `account_id` will be different from the old `account_id`.  If an account with a specific `account_id` disappears instead of changing, the account is likely closed. Closed accounts are not returned by the Plaid API.  Like all Plaid identifiers, the `account_id` is case sensitive.
            balances (AccountBalance):
            mask (str, none_type): The last 2-4 alphanumeric characters of an account's official account number. Note that the mask may be non-unique between an Item's accounts, and it may also not match the mask that the bank displays to the user.
            name (str): The name of the account, either assigned by the user or by the financial institution itself
            official_name (str, none_type): The official name of the account as given by the financial institution
            type (AccountType):
            subtype (AccountSubtype):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            verification_status (str): The current verification status of an Auth Item initiated through Automated or Manual micro-deposits.  Returned for Auth Items only.  `pending_automatic_verification`: The Item is pending automatic verification  `pending_manual_verification`: The Item is pending manual micro-deposit verification. Items remain in this state until the user successfully verifies the two amounts.  `automatically_verified`: The Item has successfully been automatically verified   `manually_verified`: The Item has successfully been manually verified  `verification_expired`: Plaid was unable to automatically verify the deposit within 7 calendar days and will no longer attempt to validate the Item. Users may retry by submitting their information again through Link.  `verification_failed`: The Item failed manual micro-deposit verification because the user exhausted all 3 verification attempts. Users may retry by submitting their information again through Link.   . [optional]  # noqa: E501
            legal_name (NameMatchScore): [optional]  # noqa: E501
            phone_number (PhoneNumberMatchScore): [optional]  # noqa: E501
            email_address (EmailAddressMatchScore): [optional]  # noqa: E501
            address (AddressMatchScore): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        required_args = {
            'account_id': account_id,
            'balances': balances,
            'mask': mask,
            'name': name,
            'official_name': official_name,
            'type': type,
            'subtype': subtype,
        }
        model_args = {}
        model_args.update(required_args)
        model_args.update(kwargs)
        composed_info = validate_get_composed_info(
            constant_args, model_args, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        unused_args = composed_info[3]

        for var_name, var_value in required_args.items():
            setattr(self, var_name, var_value)
        for var_name, var_value in kwargs.items():
            if var_name in unused_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        not self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error beause the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              AccountBase,
              AccountIdentityMatchScoreAllOf,
          ],
          'oneOf': [
          ],
        }
