"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.633.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from plaid.exceptions import ApiAttributeError


def lazy_import():
    from plaid.model.base_report_average_flow_insights import BaseReportAverageFlowInsights
    from plaid.model.base_report_longest_gap_insights import BaseReportLongestGapInsights
    from plaid.model.base_report_number_flow_insights import BaseReportNumberFlowInsights
    globals()['BaseReportAverageFlowInsights'] = BaseReportAverageFlowInsights
    globals()['BaseReportLongestGapInsights'] = BaseReportLongestGapInsights
    globals()['BaseReportNumberFlowInsights'] = BaseReportNumberFlowInsights


class BaseReportAccountInsights(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'oldest_transaction_date': (date, none_type,),  # noqa: E501
            'most_recent_transaction_date': (date, none_type,),  # noqa: E501
            'days_available': (int,),  # noqa: E501
            'average_days_between_transactions': (float,),  # noqa: E501
            'longest_gaps_between_transactions': ([BaseReportLongestGapInsights],),  # noqa: E501
            'number_of_inflows': ([BaseReportNumberFlowInsights],),  # noqa: E501
            'average_inflow_amounts': ([BaseReportAverageFlowInsights],),  # noqa: E501
            'number_of_outflows': ([BaseReportNumberFlowInsights],),  # noqa: E501
            'average_outflow_amounts': ([BaseReportAverageFlowInsights],),  # noqa: E501
            'number_of_days_no_transactions': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'oldest_transaction_date': 'oldest_transaction_date',  # noqa: E501
        'most_recent_transaction_date': 'most_recent_transaction_date',  # noqa: E501
        'days_available': 'days_available',  # noqa: E501
        'average_days_between_transactions': 'average_days_between_transactions',  # noqa: E501
        'longest_gaps_between_transactions': 'longest_gaps_between_transactions',  # noqa: E501
        'number_of_inflows': 'number_of_inflows',  # noqa: E501
        'average_inflow_amounts': 'average_inflow_amounts',  # noqa: E501
        'number_of_outflows': 'number_of_outflows',  # noqa: E501
        'average_outflow_amounts': 'average_outflow_amounts',  # noqa: E501
        'number_of_days_no_transactions': 'number_of_days_no_transactions',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """BaseReportAccountInsights - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            oldest_transaction_date (date, none_type): Date of the earliest transaction in the base report for the account.. [optional]  # noqa: E501
            most_recent_transaction_date (date, none_type): Date of the most recent transaction in the base report for the account.. [optional]  # noqa: E501
            days_available (int): Number of days days available in the base report for the account.. [optional]  # noqa: E501
            average_days_between_transactions (float): Average number of days between sequential transactions. [optional]  # noqa: E501
            longest_gaps_between_transactions ([BaseReportLongestGapInsights]): Longest gap between sequential transactions in a time period. This array can include multiple time periods.. [optional]  # noqa: E501
            number_of_inflows ([BaseReportNumberFlowInsights]): The number of debits into the account. This array will be empty for non-depository accounts.. [optional]  # noqa: E501
            average_inflow_amounts ([BaseReportAverageFlowInsights]): Average amount of debit transactions into the account in a time period. This array will be empty for non-depository accounts. This field only takes into account USD transactions from the account.. [optional]  # noqa: E501
            number_of_outflows ([BaseReportNumberFlowInsights]): The number of outflows from the account. This array will be empty for non-depository accounts.. [optional]  # noqa: E501
            average_outflow_amounts ([BaseReportAverageFlowInsights]): Average amount of transactions out of the account in a time period. This array will be empty for non-depository accounts. This field only takes into account USD transactions from the account.. [optional]  # noqa: E501
            number_of_days_no_transactions (int): Number of days with no transactions. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """BaseReportAccountInsights - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            oldest_transaction_date (date, none_type): Date of the earliest transaction in the base report for the account.. [optional]  # noqa: E501
            most_recent_transaction_date (date, none_type): Date of the most recent transaction in the base report for the account.. [optional]  # noqa: E501
            days_available (int): Number of days days available in the base report for the account.. [optional]  # noqa: E501
            average_days_between_transactions (float): Average number of days between sequential transactions. [optional]  # noqa: E501
            longest_gaps_between_transactions ([BaseReportLongestGapInsights]): Longest gap between sequential transactions in a time period. This array can include multiple time periods.. [optional]  # noqa: E501
            number_of_inflows ([BaseReportNumberFlowInsights]): The number of debits into the account. This array will be empty for non-depository accounts.. [optional]  # noqa: E501
            average_inflow_amounts ([BaseReportAverageFlowInsights]): Average amount of debit transactions into the account in a time period. This array will be empty for non-depository accounts. This field only takes into account USD transactions from the account.. [optional]  # noqa: E501
            number_of_outflows ([BaseReportNumberFlowInsights]): The number of outflows from the account. This array will be empty for non-depository accounts.. [optional]  # noqa: E501
            average_outflow_amounts ([BaseReportAverageFlowInsights]): Average amount of transactions out of the account in a time period. This array will be empty for non-depository accounts. This field only takes into account USD transactions from the account.. [optional]  # noqa: E501
            number_of_days_no_transactions (int): Number of days with no transactions. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
