"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.641.1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from plaid.exceptions import ApiAttributeError


def lazy_import():
    from plaid.model.consumer_report_permissible_purpose import ConsumerReportPermissiblePurpose
    from plaid.model.cra_check_report_cashflow_insights_get_options import CraCheckReportCashflowInsightsGetOptions
    from plaid.model.cra_check_report_create_base_report_options import CraCheckReportCreateBaseReportOptions
    from plaid.model.cra_check_report_partner_insights_get_options import CraCheckReportPartnerInsightsGetOptions
    from plaid.model.products import Products
    globals()['ConsumerReportPermissiblePurpose'] = ConsumerReportPermissiblePurpose
    globals()['CraCheckReportCashflowInsightsGetOptions'] = CraCheckReportCashflowInsightsGetOptions
    globals()['CraCheckReportCreateBaseReportOptions'] = CraCheckReportCreateBaseReportOptions
    globals()['CraCheckReportPartnerInsightsGetOptions'] = CraCheckReportPartnerInsightsGetOptions
    globals()['Products'] = Products


class CraCheckReportCreateRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('days_requested',): {
            'inclusive_maximum': 731,
        },
        ('products',): {
            'min_items': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'user_token': (str,),  # noqa: E501
            'webhook': (str,),  # noqa: E501
            'days_requested': (int,),  # noqa: E501
            'consumer_report_permissible_purpose': (ConsumerReportPermissiblePurpose,),  # noqa: E501
            'client_id': (str,),  # noqa: E501
            'secret': (str,),  # noqa: E501
            'days_required': (int,),  # noqa: E501
            'client_report_id': (str, none_type,),  # noqa: E501
            'products': ([Products], none_type,),  # noqa: E501
            'base_report': (CraCheckReportCreateBaseReportOptions,),  # noqa: E501
            'cashflow_insights': (CraCheckReportCashflowInsightsGetOptions,),  # noqa: E501
            'partner_insights': (CraCheckReportPartnerInsightsGetOptions,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'user_token': 'user_token',  # noqa: E501
        'webhook': 'webhook',  # noqa: E501
        'days_requested': 'days_requested',  # noqa: E501
        'consumer_report_permissible_purpose': 'consumer_report_permissible_purpose',  # noqa: E501
        'client_id': 'client_id',  # noqa: E501
        'secret': 'secret',  # noqa: E501
        'days_required': 'days_required',  # noqa: E501
        'client_report_id': 'client_report_id',  # noqa: E501
        'products': 'products',  # noqa: E501
        'base_report': 'base_report',  # noqa: E501
        'cashflow_insights': 'cashflow_insights',  # noqa: E501
        'partner_insights': 'partner_insights',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, user_token, webhook, days_requested, consumer_report_permissible_purpose, *args, **kwargs):  # noqa: E501
        """CraCheckReportCreateRequest - a model defined in OpenAPI

        Args:
            user_token (str): The user token associated with the User data is being requested for.
            webhook (str): The destination URL to which webhooks will be sent 
            days_requested (int): The number of days of data to request for the report. Default value is 365; maximum is 731; minimum is 180. If a value lower than 180 is provided, a minimum of 180 days of history will be requested.
            consumer_report_permissible_purpose (ConsumerReportPermissiblePurpose):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_id (str): Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.. [optional]  # noqa: E501
            secret (str): Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.. [optional]  # noqa: E501
            days_required (int): The minimum number of days of data required for the report to be successfully generated.. [optional]  # noqa: E501
            client_report_id (str, none_type): Client-generated identifier, which can be used by lenders to track loan applications.. [optional]  # noqa: E501
            products ([Products], none_type): Specifies a list of products that will be eagerly generated when creating the report (in addition to the Base Report, which is always eagerly generated). These products will be made available before a success webhook is sent. Use this option to minimize response latency for product `/get` endpoints. Note that specifying `cra_partner_insights` in this field will trigger a billable event. Other products are not billed until the respective reports are fetched via product-specific `/get` endpoints.. [optional]  # noqa: E501
            base_report (CraCheckReportCreateBaseReportOptions): [optional]  # noqa: E501
            cashflow_insights (CraCheckReportCashflowInsightsGetOptions): [optional]  # noqa: E501
            partner_insights (CraCheckReportPartnerInsightsGetOptions): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.user_token = user_token
        self.webhook = webhook
        self.days_requested = days_requested
        self.consumer_report_permissible_purpose = consumer_report_permissible_purpose
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, user_token, webhook, days_requested, consumer_report_permissible_purpose, *args, **kwargs):  # noqa: E501
        """CraCheckReportCreateRequest - a model defined in OpenAPI

        Args:
            user_token (str): The user token associated with the User data is being requested for.
            webhook (str): The destination URL to which webhooks will be sent 
            days_requested (int): The number of days of data to request for the report. Default value is 365; maximum is 731; minimum is 180. If a value lower than 180 is provided, a minimum of 180 days of history will be requested.
            consumer_report_permissible_purpose (ConsumerReportPermissiblePurpose):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            client_id (str): Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.. [optional]  # noqa: E501
            secret (str): Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.. [optional]  # noqa: E501
            days_required (int): The minimum number of days of data required for the report to be successfully generated.. [optional]  # noqa: E501
            client_report_id (str, none_type): Client-generated identifier, which can be used by lenders to track loan applications.. [optional]  # noqa: E501
            products ([Products], none_type): Specifies a list of products that will be eagerly generated when creating the report (in addition to the Base Report, which is always eagerly generated). These products will be made available before a success webhook is sent. Use this option to minimize response latency for product `/get` endpoints. Note that specifying `cra_partner_insights` in this field will trigger a billable event. Other products are not billed until the respective reports are fetched via product-specific `/get` endpoints.. [optional]  # noqa: E501
            base_report (CraCheckReportCreateBaseReportOptions): [optional]  # noqa: E501
            cashflow_insights (CraCheckReportCashflowInsightsGetOptions): [optional]  # noqa: E501
            partner_insights (CraCheckReportPartnerInsightsGetOptions): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.user_token = user_token
        self.webhook = webhook
        self.days_requested = days_requested
        self.consumer_report_permissible_purpose = consumer_report_permissible_purpose
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
