"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.667.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from plaid.exceptions import ApiAttributeError



class ProtectReportType(ModelSimple):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('value',): {
            'USER_ACCOUNT_TAKEOVER': "USER_ACCOUNT_TAKEOVER",
            'FALSE_IDENTITY': "FALSE_IDENTITY",
            'STOLEN_IDENTITY': "STOLEN_IDENTITY",
            'SYNTHETIC_IDENTITY': "SYNTHETIC_IDENTITY",
            'MULTIPLE_USER_ACCOUNTS': "MULTIPLE_USER_ACCOUNTS",
            'SCAM_VICTIM': "SCAM_VICTIM",
            'BANK_ACCOUNT_TAKEOVER': "BANK_ACCOUNT_TAKEOVER",
            'BANK_CONNECTION_REVOKED': "BANK_CONNECTION_REVOKED",
            'CARD_TESTING': "CARD_TESTING",
            'UNAUTHORIZED_TRANSACTION': "UNAUTHORIZED_TRANSACTION",
            'CARD_CHARGEBACK': "CARD_CHARGEBACK",
            'ACH_RETURN': "ACH_RETURN",
            'DISPUTE': "DISPUTE",
            'FIRST_PARTY_FRAUD': "FIRST_PARTY_FRAUD",
            'MISSED_PAYMENT': "MISSED_PAYMENT",
            'LOAN_STACKING': "LOAN_STACKING",
            'MONEY_LAUNDERING': "MONEY_LAUNDERING",
            'NO_FRAUD': "NO_FRAUD",
            'OTHER': "OTHER",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'value': (str,),
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {}

    read_only_vars = set()

    _composed_schemas = None

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):
        """ProtectReportType - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] (str): The type of incident being reported.  `USER_ACCOUNT_TAKEOVER` - Indicates that a legitimate user's account was accessed or controlled by an unauthorized party.  `FALSE_IDENTITY` - Indicates that a user created an account using stolen or fabricated identity information.  `STOLEN_IDENTITY` - Indicates that a user created an account using identity information belonging to a real individual without their consent.  `SYNTHETIC_IDENTITY` - Indicates that a user created an account using a fake or partially fabricated identity (e.g., combining real and fake information to form a new persona).  `MULTIPLE_USER_ACCOUNTS` - Indicates that the same individual is operating multiple accounts in violation of policy.  `SCAM_VICTIM` - Indicates that the user was tricked into authorizing or sending funds as part of a scam.  `BANK_ACCOUNT_TAKEOVER` - Indicates that a user's linked bank account was accessed or misused by an unauthorized party.  `BANK_CONNECTION_REVOKED` - Indicates that a linked bank account connection was revoked by the financial institution, often due to suspected misuse, fraud, or security concerns.  `CARD_TESTING` - Indicates that a card was used in small or repeated transactions to test its validity.  `UNAUTHORIZED_TRANSACTION` - Indicates that a transaction was made without the user's consent or authorization.  `CARD_CHARGEBACK` - Indicates that a card transaction was reversed via a chargeback claim.  `ACH_RETURN` - Indicates that an ACH transaction was returned or reversed by the bank.  `DISPUTE` - Indicates that a user filed a dispute regarding a transaction or account activity.  `FIRST_PARTY_FRAUD` - Indicates that a user intentionally misrepresented themselves or their actions for financial gain.  `MISSED_PAYMENT` - Indicates that a user failed to make a required payment on time.  `LOAN_STACKING` - Indicates that a user applied for or took out multiple loans simultaneously beyond their ability to repay.  `MONEY_LAUNDERING` - Indicates that funds are being moved through accounts to obscure their illicit origin.  `NO_FRAUD` - Indicates that an investigation determined no fraudulent activity occurred on user/event (positive label)  `OTHER` - Indicates that the case involves fraud or financial risk not covered by other report types. Requires notes describing the report.., must be one of ["USER_ACCOUNT_TAKEOVER", "FALSE_IDENTITY", "STOLEN_IDENTITY", "SYNTHETIC_IDENTITY", "MULTIPLE_USER_ACCOUNTS", "SCAM_VICTIM", "BANK_ACCOUNT_TAKEOVER", "BANK_CONNECTION_REVOKED", "CARD_TESTING", "UNAUTHORIZED_TRANSACTION", "CARD_CHARGEBACK", "ACH_RETURN", "DISPUTE", "FIRST_PARTY_FRAUD", "MISSED_PAYMENT", "LOAN_STACKING", "MONEY_LAUNDERING", "NO_FRAUD", "OTHER", ]  # noqa: E501

        Keyword Args:
            value (str): The type of incident being reported.  `USER_ACCOUNT_TAKEOVER` - Indicates that a legitimate user's account was accessed or controlled by an unauthorized party.  `FALSE_IDENTITY` - Indicates that a user created an account using stolen or fabricated identity information.  `STOLEN_IDENTITY` - Indicates that a user created an account using identity information belonging to a real individual without their consent.  `SYNTHETIC_IDENTITY` - Indicates that a user created an account using a fake or partially fabricated identity (e.g., combining real and fake information to form a new persona).  `MULTIPLE_USER_ACCOUNTS` - Indicates that the same individual is operating multiple accounts in violation of policy.  `SCAM_VICTIM` - Indicates that the user was tricked into authorizing or sending funds as part of a scam.  `BANK_ACCOUNT_TAKEOVER` - Indicates that a user's linked bank account was accessed or misused by an unauthorized party.  `BANK_CONNECTION_REVOKED` - Indicates that a linked bank account connection was revoked by the financial institution, often due to suspected misuse, fraud, or security concerns.  `CARD_TESTING` - Indicates that a card was used in small or repeated transactions to test its validity.  `UNAUTHORIZED_TRANSACTION` - Indicates that a transaction was made without the user's consent or authorization.  `CARD_CHARGEBACK` - Indicates that a card transaction was reversed via a chargeback claim.  `ACH_RETURN` - Indicates that an ACH transaction was returned or reversed by the bank.  `DISPUTE` - Indicates that a user filed a dispute regarding a transaction or account activity.  `FIRST_PARTY_FRAUD` - Indicates that a user intentionally misrepresented themselves or their actions for financial gain.  `MISSED_PAYMENT` - Indicates that a user failed to make a required payment on time.  `LOAN_STACKING` - Indicates that a user applied for or took out multiple loans simultaneously beyond their ability to repay.  `MONEY_LAUNDERING` - Indicates that funds are being moved through accounts to obscure their illicit origin.  `NO_FRAUD` - Indicates that an investigation determined no fraudulent activity occurred on user/event (positive label)  `OTHER` - Indicates that the case involves fraud or financial risk not covered by other report types. Requires notes describing the report.., must be one of ["USER_ACCOUNT_TAKEOVER", "FALSE_IDENTITY", "STOLEN_IDENTITY", "SYNTHETIC_IDENTITY", "MULTIPLE_USER_ACCOUNTS", "SCAM_VICTIM", "BANK_ACCOUNT_TAKEOVER", "BANK_CONNECTION_REVOKED", "CARD_TESTING", "UNAUTHORIZED_TRANSACTION", "CARD_CHARGEBACK", "ACH_RETURN", "DISPUTE", "FIRST_PARTY_FRAUD", "MISSED_PAYMENT", "LOAN_STACKING", "MONEY_LAUNDERING", "NO_FRAUD", "OTHER", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):
        """ProtectReportType - a model defined in OpenAPI

        Note that value can be passed either in args or in kwargs, but not in both.

        Args:
            args[0] (str): The type of incident being reported.  `USER_ACCOUNT_TAKEOVER` - Indicates that a legitimate user's account was accessed or controlled by an unauthorized party.  `FALSE_IDENTITY` - Indicates that a user created an account using stolen or fabricated identity information.  `STOLEN_IDENTITY` - Indicates that a user created an account using identity information belonging to a real individual without their consent.  `SYNTHETIC_IDENTITY` - Indicates that a user created an account using a fake or partially fabricated identity (e.g., combining real and fake information to form a new persona).  `MULTIPLE_USER_ACCOUNTS` - Indicates that the same individual is operating multiple accounts in violation of policy.  `SCAM_VICTIM` - Indicates that the user was tricked into authorizing or sending funds as part of a scam.  `BANK_ACCOUNT_TAKEOVER` - Indicates that a user's linked bank account was accessed or misused by an unauthorized party.  `BANK_CONNECTION_REVOKED` - Indicates that a linked bank account connection was revoked by the financial institution, often due to suspected misuse, fraud, or security concerns.  `CARD_TESTING` - Indicates that a card was used in small or repeated transactions to test its validity.  `UNAUTHORIZED_TRANSACTION` - Indicates that a transaction was made without the user's consent or authorization.  `CARD_CHARGEBACK` - Indicates that a card transaction was reversed via a chargeback claim.  `ACH_RETURN` - Indicates that an ACH transaction was returned or reversed by the bank.  `DISPUTE` - Indicates that a user filed a dispute regarding a transaction or account activity.  `FIRST_PARTY_FRAUD` - Indicates that a user intentionally misrepresented themselves or their actions for financial gain.  `MISSED_PAYMENT` - Indicates that a user failed to make a required payment on time.  `LOAN_STACKING` - Indicates that a user applied for or took out multiple loans simultaneously beyond their ability to repay.  `MONEY_LAUNDERING` - Indicates that funds are being moved through accounts to obscure their illicit origin.  `NO_FRAUD` - Indicates that an investigation determined no fraudulent activity occurred on user/event (positive label)  `OTHER` - Indicates that the case involves fraud or financial risk not covered by other report types. Requires notes describing the report.., must be one of ["USER_ACCOUNT_TAKEOVER", "FALSE_IDENTITY", "STOLEN_IDENTITY", "SYNTHETIC_IDENTITY", "MULTIPLE_USER_ACCOUNTS", "SCAM_VICTIM", "BANK_ACCOUNT_TAKEOVER", "BANK_CONNECTION_REVOKED", "CARD_TESTING", "UNAUTHORIZED_TRANSACTION", "CARD_CHARGEBACK", "ACH_RETURN", "DISPUTE", "FIRST_PARTY_FRAUD", "MISSED_PAYMENT", "LOAN_STACKING", "MONEY_LAUNDERING", "NO_FRAUD", "OTHER", ]  # noqa: E501

        Keyword Args:
            value (str): The type of incident being reported.  `USER_ACCOUNT_TAKEOVER` - Indicates that a legitimate user's account was accessed or controlled by an unauthorized party.  `FALSE_IDENTITY` - Indicates that a user created an account using stolen or fabricated identity information.  `STOLEN_IDENTITY` - Indicates that a user created an account using identity information belonging to a real individual without their consent.  `SYNTHETIC_IDENTITY` - Indicates that a user created an account using a fake or partially fabricated identity (e.g., combining real and fake information to form a new persona).  `MULTIPLE_USER_ACCOUNTS` - Indicates that the same individual is operating multiple accounts in violation of policy.  `SCAM_VICTIM` - Indicates that the user was tricked into authorizing or sending funds as part of a scam.  `BANK_ACCOUNT_TAKEOVER` - Indicates that a user's linked bank account was accessed or misused by an unauthorized party.  `BANK_CONNECTION_REVOKED` - Indicates that a linked bank account connection was revoked by the financial institution, often due to suspected misuse, fraud, or security concerns.  `CARD_TESTING` - Indicates that a card was used in small or repeated transactions to test its validity.  `UNAUTHORIZED_TRANSACTION` - Indicates that a transaction was made without the user's consent or authorization.  `CARD_CHARGEBACK` - Indicates that a card transaction was reversed via a chargeback claim.  `ACH_RETURN` - Indicates that an ACH transaction was returned or reversed by the bank.  `DISPUTE` - Indicates that a user filed a dispute regarding a transaction or account activity.  `FIRST_PARTY_FRAUD` - Indicates that a user intentionally misrepresented themselves or their actions for financial gain.  `MISSED_PAYMENT` - Indicates that a user failed to make a required payment on time.  `LOAN_STACKING` - Indicates that a user applied for or took out multiple loans simultaneously beyond their ability to repay.  `MONEY_LAUNDERING` - Indicates that funds are being moved through accounts to obscure their illicit origin.  `NO_FRAUD` - Indicates that an investigation determined no fraudulent activity occurred on user/event (positive label)  `OTHER` - Indicates that the case involves fraud or financial risk not covered by other report types. Requires notes describing the report.., must be one of ["USER_ACCOUNT_TAKEOVER", "FALSE_IDENTITY", "STOLEN_IDENTITY", "SYNTHETIC_IDENTITY", "MULTIPLE_USER_ACCOUNTS", "SCAM_VICTIM", "BANK_ACCOUNT_TAKEOVER", "BANK_CONNECTION_REVOKED", "CARD_TESTING", "UNAUTHORIZED_TRANSACTION", "CARD_CHARGEBACK", "ACH_RETURN", "DISPUTE", "FIRST_PARTY_FRAUD", "MISSED_PAYMENT", "LOAN_STACKING", "MONEY_LAUNDERING", "NO_FRAUD", "OTHER", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """
        # required up here when default value is not given
        _path_to_item = kwargs.pop('_path_to_item', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if 'value' in kwargs:
            value = kwargs.pop('value')
        elif args:
            args = list(args)
            value = args.pop(0)
        else:
            raise ApiTypeError(
                "value is required, but not passed in args or kwargs and doesn't have default",
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)
        self.value = value
        if kwargs:
            raise ApiTypeError(
                "Invalid named arguments=%s passed to %s. Remove those invalid named arguments." % (
                    kwargs,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        return self
