# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class AccountAssetsAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'days_available': 'float',
        'transactions': 'list[Transaction]',
        'owners': 'list[Owner]',
        'historical_balances': 'list[HistoricalBalance]'
    }

    attribute_map = {
        'days_available': 'days_available',
        'transactions': 'transactions',
        'owners': 'owners',
        'historical_balances': 'historical_balances'
    }

    def __init__(self, days_available=None, transactions=None, owners=None, historical_balances=None, local_vars_configuration=None):  # noqa: E501
        """AccountAssetsAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._days_available = None
        self._transactions = None
        self._owners = None
        self._historical_balances = None
        self.discriminator = None

        self.days_available = days_available
        self.transactions = transactions
        if owners is not None:
            self.owners = owners
        self.historical_balances = historical_balances

    @property
    def days_available(self):
        """Gets the days_available of this AccountAssetsAllOf.  # noqa: E501

        The duration of transaction history available for this Item, typically defined as the time since the date of the earliest transaction in that account. Only returned by Assets endpoints.  # noqa: E501

        :return: The days_available of this AccountAssetsAllOf.  # noqa: E501
        :rtype: float
        """
        return self._days_available

    @days_available.setter
    def days_available(self, days_available):
        """Sets the days_available of this AccountAssetsAllOf.

        The duration of transaction history available for this Item, typically defined as the time since the date of the earliest transaction in that account. Only returned by Assets endpoints.  # noqa: E501

        :param days_available: The days_available of this AccountAssetsAllOf.  # noqa: E501
        :type days_available: float
        """

        self._days_available = days_available

    @property
    def transactions(self):
        """Gets the transactions of this AccountAssetsAllOf.  # noqa: E501

        Transaction history associated with the account. Only returned by Assets endpoints. Transaction history returned by endpoints such as `/transactions/get` or `/investments/transactions/get` will be returned in the top-level `transactions` field instead.  # noqa: E501

        :return: The transactions of this AccountAssetsAllOf.  # noqa: E501
        :rtype: list[Transaction]
        """
        return self._transactions

    @transactions.setter
    def transactions(self, transactions):
        """Sets the transactions of this AccountAssetsAllOf.

        Transaction history associated with the account. Only returned by Assets endpoints. Transaction history returned by endpoints such as `/transactions/get` or `/investments/transactions/get` will be returned in the top-level `transactions` field instead.  # noqa: E501

        :param transactions: The transactions of this AccountAssetsAllOf.  # noqa: E501
        :type transactions: list[Transaction]
        """

        self._transactions = transactions

    @property
    def owners(self):
        """Gets the owners of this AccountAssetsAllOf.  # noqa: E501

        Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array.  # noqa: E501

        :return: The owners of this AccountAssetsAllOf.  # noqa: E501
        :rtype: list[Owner]
        """
        return self._owners

    @owners.setter
    def owners(self, owners):
        """Sets the owners of this AccountAssetsAllOf.

        Data returned by the financial institution about the account owner or owners. Only returned by Identity or Assets endpoints. Multiple owners on a single account will be represented in the same `owner` object, not in multiple owner objects within the array.  # noqa: E501

        :param owners: The owners of this AccountAssetsAllOf.  # noqa: E501
        :type owners: list[Owner]
        """

        self._owners = owners

    @property
    def historical_balances(self):
        """Gets the historical_balances of this AccountAssetsAllOf.  # noqa: E501

        Calculated data about the historical balances on the account. Only returned by Assets endpoints.  # noqa: E501

        :return: The historical_balances of this AccountAssetsAllOf.  # noqa: E501
        :rtype: list[HistoricalBalance]
        """
        return self._historical_balances

    @historical_balances.setter
    def historical_balances(self, historical_balances):
        """Sets the historical_balances of this AccountAssetsAllOf.

        Calculated data about the historical balances on the account. Only returned by Assets endpoints.  # noqa: E501

        :param historical_balances: The historical_balances of this AccountAssetsAllOf.  # noqa: E501
        :type historical_balances: list[HistoricalBalance]
        """

        self._historical_balances = historical_balances

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountAssetsAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountAssetsAllOf):
            return True

        return self.to_dict() != other.to_dict()
