# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class APR(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'apr_percentage': 'float',
        'apr_type': 'str',
        'balance_subject_to_apr': 'float',
        'interest_charge_amount': 'float'
    }

    attribute_map = {
        'apr_percentage': 'apr_percentage',
        'apr_type': 'apr_type',
        'balance_subject_to_apr': 'balance_subject_to_apr',
        'interest_charge_amount': 'interest_charge_amount'
    }

    def __init__(self, apr_percentage=None, apr_type=None, balance_subject_to_apr=None, interest_charge_amount=None, local_vars_configuration=None):  # noqa: E501
        """APR - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._apr_percentage = None
        self._apr_type = None
        self._balance_subject_to_apr = None
        self._interest_charge_amount = None
        self.discriminator = None

        if apr_percentage is not None:
            self.apr_percentage = apr_percentage
        if apr_type is not None:
            self.apr_type = apr_type
        self.balance_subject_to_apr = balance_subject_to_apr
        self.interest_charge_amount = interest_charge_amount

    @property
    def apr_percentage(self):
        """Gets the apr_percentage of this APR.  # noqa: E501

        Annual Percentage Rate applied.   # noqa: E501

        :return: The apr_percentage of this APR.  # noqa: E501
        :rtype: float
        """
        return self._apr_percentage

    @apr_percentage.setter
    def apr_percentage(self, apr_percentage):
        """Sets the apr_percentage of this APR.

        Annual Percentage Rate applied.   # noqa: E501

        :param apr_percentage: The apr_percentage of this APR.  # noqa: E501
        :type apr_percentage: float
        """

        self._apr_percentage = apr_percentage

    @property
    def apr_type(self):
        """Gets the apr_type of this APR.  # noqa: E501

        The type of balance to which the APR applies.  # noqa: E501

        :return: The apr_type of this APR.  # noqa: E501
        :rtype: str
        """
        return self._apr_type

    @apr_type.setter
    def apr_type(self, apr_type):
        """Sets the apr_type of this APR.

        The type of balance to which the APR applies.  # noqa: E501

        :param apr_type: The apr_type of this APR.  # noqa: E501
        :type apr_type: str
        """
        allowed_values = ["balance_transfer_apr", "cash_apr", "purchase_apr", "special"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and apr_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `apr_type` ({0}), must be one of {1}"  # noqa: E501
                .format(apr_type, allowed_values)
            )

        self._apr_type = apr_type

    @property
    def balance_subject_to_apr(self):
        """Gets the balance_subject_to_apr of this APR.  # noqa: E501

        Amount of money that is subjected to the APR if a balance was carried beyond payment due date. How it is calculated can vary by card issuer. It is often calculated as an average daily balance.  # noqa: E501

        :return: The balance_subject_to_apr of this APR.  # noqa: E501
        :rtype: float
        """
        return self._balance_subject_to_apr

    @balance_subject_to_apr.setter
    def balance_subject_to_apr(self, balance_subject_to_apr):
        """Sets the balance_subject_to_apr of this APR.

        Amount of money that is subjected to the APR if a balance was carried beyond payment due date. How it is calculated can vary by card issuer. It is often calculated as an average daily balance.  # noqa: E501

        :param balance_subject_to_apr: The balance_subject_to_apr of this APR.  # noqa: E501
        :type balance_subject_to_apr: float
        """

        self._balance_subject_to_apr = balance_subject_to_apr

    @property
    def interest_charge_amount(self):
        """Gets the interest_charge_amount of this APR.  # noqa: E501

        Amount of money charged due to interest from last statement.  # noqa: E501

        :return: The interest_charge_amount of this APR.  # noqa: E501
        :rtype: float
        """
        return self._interest_charge_amount

    @interest_charge_amount.setter
    def interest_charge_amount(self, interest_charge_amount):
        """Sets the interest_charge_amount of this APR.

        Amount of money charged due to interest from last statement.  # noqa: E501

        :param interest_charge_amount: The interest_charge_amount of this APR.  # noqa: E501
        :type interest_charge_amount: float
        """

        self._interest_charge_amount = interest_charge_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, APR):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, APR):
            return True

        return self.to_dict() != other.to_dict()
