# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class BankTransfer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'ach_class': 'ACHClass',
        'account_id': 'str',
        'type': 'BankTransferType',
        'user': 'BankTransferUser',
        'amount': 'str',
        'iso_currency_code': 'str',
        'description': 'str',
        'created': 'datetime',
        'status': 'BankTransferStatus',
        'network': 'BankTransferNetwork',
        'cancellable': 'bool',
        'failure_reason': 'BankTransferFailure',
        'custom_tag': 'str',
        'metadata': 'dict(str, str)',
        'origination_account_id': 'str',
        'direction': 'BankTransferDirection'
    }

    attribute_map = {
        'id': 'id',
        'ach_class': 'ach_class',
        'account_id': 'account_id',
        'type': 'type',
        'user': 'user',
        'amount': 'amount',
        'iso_currency_code': 'iso_currency_code',
        'description': 'description',
        'created': 'created',
        'status': 'status',
        'network': 'network',
        'cancellable': 'cancellable',
        'failure_reason': 'failure_reason',
        'custom_tag': 'custom_tag',
        'metadata': 'metadata',
        'origination_account_id': 'origination_account_id',
        'direction': 'direction'
    }

    def __init__(self, id=None, ach_class=None, account_id=None, type=None, user=None, amount=None, iso_currency_code=None, description=None, created=None, status=None, network=None, cancellable=None, failure_reason=None, custom_tag=None, metadata=None, origination_account_id=None, direction=None, local_vars_configuration=None):  # noqa: E501
        """BankTransfer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._ach_class = None
        self._account_id = None
        self._type = None
        self._user = None
        self._amount = None
        self._iso_currency_code = None
        self._description = None
        self._created = None
        self._status = None
        self._network = None
        self._cancellable = None
        self._failure_reason = None
        self._custom_tag = None
        self._metadata = None
        self._origination_account_id = None
        self._direction = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if ach_class is not None:
            self.ach_class = ach_class
        if account_id is not None:
            self.account_id = account_id
        if type is not None:
            self.type = type
        if user is not None:
            self.user = user
        if amount is not None:
            self.amount = amount
        if iso_currency_code is not None:
            self.iso_currency_code = iso_currency_code
        if description is not None:
            self.description = description
        if created is not None:
            self.created = created
        if status is not None:
            self.status = status
        if network is not None:
            self.network = network
        if cancellable is not None:
            self.cancellable = cancellable
        self.failure_reason = failure_reason
        self.custom_tag = custom_tag
        self.metadata = metadata
        if origination_account_id is not None:
            self.origination_account_id = origination_account_id
        if direction is not None:
            self.direction = direction

    @property
    def id(self):
        """Gets the id of this BankTransfer.  # noqa: E501

        Plaid’s unique identifier for a bank transfer.  # noqa: E501

        :return: The id of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BankTransfer.

        Plaid’s unique identifier for a bank transfer.  # noqa: E501

        :param id: The id of this BankTransfer.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def ach_class(self):
        """Gets the ach_class of this BankTransfer.  # noqa: E501


        :return: The ach_class of this BankTransfer.  # noqa: E501
        :rtype: ACHClass
        """
        return self._ach_class

    @ach_class.setter
    def ach_class(self, ach_class):
        """Sets the ach_class of this BankTransfer.


        :param ach_class: The ach_class of this BankTransfer.  # noqa: E501
        :type ach_class: ACHClass
        """

        self._ach_class = ach_class

    @property
    def account_id(self):
        """Gets the account_id of this BankTransfer.  # noqa: E501

        The account ID that should be credited/debited for this bank transfer.  # noqa: E501

        :return: The account_id of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this BankTransfer.

        The account ID that should be credited/debited for this bank transfer.  # noqa: E501

        :param account_id: The account_id of this BankTransfer.  # noqa: E501
        :type account_id: str
        """

        self._account_id = account_id

    @property
    def type(self):
        """Gets the type of this BankTransfer.  # noqa: E501


        :return: The type of this BankTransfer.  # noqa: E501
        :rtype: BankTransferType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BankTransfer.


        :param type: The type of this BankTransfer.  # noqa: E501
        :type type: BankTransferType
        """

        self._type = type

    @property
    def user(self):
        """Gets the user of this BankTransfer.  # noqa: E501


        :return: The user of this BankTransfer.  # noqa: E501
        :rtype: BankTransferUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this BankTransfer.


        :param user: The user of this BankTransfer.  # noqa: E501
        :type user: BankTransferUser
        """

        self._user = user

    @property
    def amount(self):
        """Gets the amount of this BankTransfer.  # noqa: E501

        The amount of the transfer (decimal string with two digits of precision e.g. “10.00”).  # noqa: E501

        :return: The amount of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BankTransfer.

        The amount of the transfer (decimal string with two digits of precision e.g. “10.00”).  # noqa: E501

        :param amount: The amount of this BankTransfer.  # noqa: E501
        :type amount: str
        """

        self._amount = amount

    @property
    def iso_currency_code(self):
        """Gets the iso_currency_code of this BankTransfer.  # noqa: E501

        The currency of the transfer amount, e.g. \"USD\"  # noqa: E501

        :return: The iso_currency_code of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._iso_currency_code

    @iso_currency_code.setter
    def iso_currency_code(self, iso_currency_code):
        """Sets the iso_currency_code of this BankTransfer.

        The currency of the transfer amount, e.g. \"USD\"  # noqa: E501

        :param iso_currency_code: The iso_currency_code of this BankTransfer.  # noqa: E501
        :type iso_currency_code: str
        """

        self._iso_currency_code = iso_currency_code

    @property
    def description(self):
        """Gets the description of this BankTransfer.  # noqa: E501

        The description of the transfer.  # noqa: E501

        :return: The description of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BankTransfer.

        The description of the transfer.  # noqa: E501

        :param description: The description of this BankTransfer.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def created(self):
        """Gets the created of this BankTransfer.  # noqa: E501

        The datetime when this bank transfer was created. This will be of the form `2006-01-02T15:04:05Z`  # noqa: E501

        :return: The created of this BankTransfer.  # noqa: E501
        :rtype: datetime
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this BankTransfer.

        The datetime when this bank transfer was created. This will be of the form `2006-01-02T15:04:05Z`  # noqa: E501

        :param created: The created of this BankTransfer.  # noqa: E501
        :type created: datetime
        """

        self._created = created

    @property
    def status(self):
        """Gets the status of this BankTransfer.  # noqa: E501


        :return: The status of this BankTransfer.  # noqa: E501
        :rtype: BankTransferStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BankTransfer.


        :param status: The status of this BankTransfer.  # noqa: E501
        :type status: BankTransferStatus
        """

        self._status = status

    @property
    def network(self):
        """Gets the network of this BankTransfer.  # noqa: E501


        :return: The network of this BankTransfer.  # noqa: E501
        :rtype: BankTransferNetwork
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this BankTransfer.


        :param network: The network of this BankTransfer.  # noqa: E501
        :type network: BankTransferNetwork
        """

        self._network = network

    @property
    def cancellable(self):
        """Gets the cancellable of this BankTransfer.  # noqa: E501

        When `true`, you can still cancel this bank transfer.  # noqa: E501

        :return: The cancellable of this BankTransfer.  # noqa: E501
        :rtype: bool
        """
        return self._cancellable

    @cancellable.setter
    def cancellable(self, cancellable):
        """Sets the cancellable of this BankTransfer.

        When `true`, you can still cancel this bank transfer.  # noqa: E501

        :param cancellable: The cancellable of this BankTransfer.  # noqa: E501
        :type cancellable: bool
        """

        self._cancellable = cancellable

    @property
    def failure_reason(self):
        """Gets the failure_reason of this BankTransfer.  # noqa: E501


        :return: The failure_reason of this BankTransfer.  # noqa: E501
        :rtype: BankTransferFailure
        """
        return self._failure_reason

    @failure_reason.setter
    def failure_reason(self, failure_reason):
        """Sets the failure_reason of this BankTransfer.


        :param failure_reason: The failure_reason of this BankTransfer.  # noqa: E501
        :type failure_reason: BankTransferFailure
        """

        self._failure_reason = failure_reason

    @property
    def custom_tag(self):
        """Gets the custom_tag of this BankTransfer.  # noqa: E501

        A string containing the custom tag provided by the client in the create request. Will be null if not provided.  # noqa: E501

        :return: The custom_tag of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._custom_tag

    @custom_tag.setter
    def custom_tag(self, custom_tag):
        """Sets the custom_tag of this BankTransfer.

        A string containing the custom tag provided by the client in the create request. Will be null if not provided.  # noqa: E501

        :param custom_tag: The custom_tag of this BankTransfer.  # noqa: E501
        :type custom_tag: str
        """

        self._custom_tag = custom_tag

    @property
    def metadata(self):
        """Gets the metadata of this BankTransfer.  # noqa: E501

        The Metadata object is a mapping of client-provided String fields to any String value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters   # noqa: E501

        :return: The metadata of this BankTransfer.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this BankTransfer.

        The Metadata object is a mapping of client-provided String fields to any String value. The following limitations apply: - The JSON values must be Strings (no nested JSON objects allowed) - Only ASCII characters may be used - Maximum of 50 key/value pairs - Maximum key length of 40 characters - Maximum value length of 500 characters   # noqa: E501

        :param metadata: The metadata of this BankTransfer.  # noqa: E501
        :type metadata: dict(str, str)
        """

        self._metadata = metadata

    @property
    def origination_account_id(self):
        """Gets the origination_account_id of this BankTransfer.  # noqa: E501

        Plaid’s unique identifier for the origination account that was used for this transfer.  # noqa: E501

        :return: The origination_account_id of this BankTransfer.  # noqa: E501
        :rtype: str
        """
        return self._origination_account_id

    @origination_account_id.setter
    def origination_account_id(self, origination_account_id):
        """Sets the origination_account_id of this BankTransfer.

        Plaid’s unique identifier for the origination account that was used for this transfer.  # noqa: E501

        :param origination_account_id: The origination_account_id of this BankTransfer.  # noqa: E501
        :type origination_account_id: str
        """

        self._origination_account_id = origination_account_id

    @property
    def direction(self):
        """Gets the direction of this BankTransfer.  # noqa: E501


        :return: The direction of this BankTransfer.  # noqa: E501
        :rtype: BankTransferDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this BankTransfer.


        :param direction: The direction of this BankTransfer.  # noqa: E501
        :type direction: BankTransferDirection
        """

        self._direction = direction

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BankTransfer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BankTransfer):
            return True

        return self.to_dict() != other.to_dict()
