# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class Item(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'item_id': 'str',
        'institution_id': 'str',
        'webhook': 'str',
        'error': 'Error',
        'available_products': 'list[Products]',
        'billed_products': 'list[Products]',
        'consent_expiration_time': 'str'
    }

    attribute_map = {
        'item_id': 'item_id',
        'institution_id': 'institution_id',
        'webhook': 'webhook',
        'error': 'error',
        'available_products': 'available_products',
        'billed_products': 'billed_products',
        'consent_expiration_time': 'consent_expiration_time'
    }

    def __init__(self, item_id=None, institution_id=None, webhook=None, error=None, available_products=None, billed_products=None, consent_expiration_time=None, local_vars_configuration=None):  # noqa: E501
        """Item - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._item_id = None
        self._institution_id = None
        self._webhook = None
        self._error = None
        self._available_products = None
        self._billed_products = None
        self._consent_expiration_time = None
        self.discriminator = None

        if item_id is not None:
            self.item_id = item_id
        self.institution_id = institution_id
        self.webhook = webhook
        self.error = error
        if available_products is not None:
            self.available_products = available_products
        if billed_products is not None:
            self.billed_products = billed_products
        self.consent_expiration_time = consent_expiration_time

    @property
    def item_id(self):
        """Gets the item_id of this Item.  # noqa: E501

        The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.  # noqa: E501

        :return: The item_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this Item.

        The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.  # noqa: E501

        :param item_id: The item_id of this Item.  # noqa: E501
        :type item_id: str
        """

        self._item_id = item_id

    @property
    def institution_id(self):
        """Gets the institution_id of this Item.  # noqa: E501

        The Plaid Institution ID associated with the Item. Field is `null` for Items created via Same Day Micro-deposits.  # noqa: E501

        :return: The institution_id of this Item.  # noqa: E501
        :rtype: str
        """
        return self._institution_id

    @institution_id.setter
    def institution_id(self, institution_id):
        """Sets the institution_id of this Item.

        The Plaid Institution ID associated with the Item. Field is `null` for Items created via Same Day Micro-deposits.  # noqa: E501

        :param institution_id: The institution_id of this Item.  # noqa: E501
        :type institution_id: str
        """

        self._institution_id = institution_id

    @property
    def webhook(self):
        """Gets the webhook of this Item.  # noqa: E501

        The URL registered to receive webhooks for the Item.  # noqa: E501

        :return: The webhook of this Item.  # noqa: E501
        :rtype: str
        """
        return self._webhook

    @webhook.setter
    def webhook(self, webhook):
        """Sets the webhook of this Item.

        The URL registered to receive webhooks for the Item.  # noqa: E501

        :param webhook: The webhook of this Item.  # noqa: E501
        :type webhook: str
        """

        self._webhook = webhook

    @property
    def error(self):
        """Gets the error of this Item.  # noqa: E501


        :return: The error of this Item.  # noqa: E501
        :rtype: Error
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this Item.


        :param error: The error of this Item.  # noqa: E501
        :type error: Error
        """

        self._error = error

    @property
    def available_products(self):
        """Gets the available_products of this Item.  # noqa: E501

        A list of products available for the Item that have not yet been accessed.  # noqa: E501

        :return: The available_products of this Item.  # noqa: E501
        :rtype: list[Products]
        """
        return self._available_products

    @available_products.setter
    def available_products(self, available_products):
        """Sets the available_products of this Item.

        A list of products available for the Item that have not yet been accessed.  # noqa: E501

        :param available_products: The available_products of this Item.  # noqa: E501
        :type available_products: list[Products]
        """

        self._available_products = available_products

    @property
    def billed_products(self):
        """Gets the billed_products of this Item.  # noqa: E501

        A list of products that have been billed for the Item. Note - `billed_products` is populated in all environments but only requests in Production are billed.   # noqa: E501

        :return: The billed_products of this Item.  # noqa: E501
        :rtype: list[Products]
        """
        return self._billed_products

    @billed_products.setter
    def billed_products(self, billed_products):
        """Sets the billed_products of this Item.

        A list of products that have been billed for the Item. Note - `billed_products` is populated in all environments but only requests in Production are billed.   # noqa: E501

        :param billed_products: The billed_products of this Item.  # noqa: E501
        :type billed_products: list[Products]
        """

        self._billed_products = billed_products

    @property
    def consent_expiration_time(self):
        """Gets the consent_expiration_time of this Item.  # noqa: E501

        The RFC 3339 timestamp after which the consent provided by the end user will expire. Upon consent expiration, the item will enter the `ITEM_LOGIN_REQUIRED` error state. To circumvent the `ITEM_LOGIN_REQUIRED` error and maintain continuous consent, the end user can reauthenticate via Link’s update mode in advance of the consent expiration time.  Note - This is only relevant for European institutions subject to PSD2 regulations mandating a 90-day consent window. For all other institutions, this field will be null.   # noqa: E501

        :return: The consent_expiration_time of this Item.  # noqa: E501
        :rtype: str
        """
        return self._consent_expiration_time

    @consent_expiration_time.setter
    def consent_expiration_time(self, consent_expiration_time):
        """Sets the consent_expiration_time of this Item.

        The RFC 3339 timestamp after which the consent provided by the end user will expire. Upon consent expiration, the item will enter the `ITEM_LOGIN_REQUIRED` error state. To circumvent the `ITEM_LOGIN_REQUIRED` error and maintain continuous consent, the end user can reauthenticate via Link’s update mode in advance of the consent expiration time.  Note - This is only relevant for European institutions subject to PSD2 regulations mandating a 90-day consent window. For all other institutions, this field will be null.   # noqa: E501

        :param consent_expiration_time: The consent_expiration_time of this Item.  # noqa: E501
        :type consent_expiration_time: str
        """

        self._consent_expiration_time = consent_expiration_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Item):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Item):
            return True

        return self.to_dict() != other.to_dict()
