# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class MFA(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'question_rounds': 'float',
        'questions_per_round': 'float',
        'selection_rounds': 'float',
        'selections_per_question': 'float'
    }

    attribute_map = {
        'type': 'type',
        'question_rounds': 'question_rounds',
        'questions_per_round': 'questions_per_round',
        'selection_rounds': 'selection_rounds',
        'selections_per_question': 'selections_per_question'
    }

    def __init__(self, type=None, question_rounds=None, questions_per_round=None, selection_rounds=None, selections_per_question=None, local_vars_configuration=None):  # noqa: E501
        """MFA - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._question_rounds = None
        self._questions_per_round = None
        self._selection_rounds = None
        self._selections_per_question = None
        self.discriminator = None

        self.type = type
        if question_rounds is not None:
            self.question_rounds = question_rounds
        if questions_per_round is not None:
            self.questions_per_round = questions_per_round
        if selection_rounds is not None:
            self.selection_rounds = selection_rounds
        if selections_per_question is not None:
            self.selections_per_question = selections_per_question

    @property
    def type(self):
        """Gets the type of this MFA.  # noqa: E501

        Possible values are `device`, `selections`, or `questions`.  If value is `device`, the MFA answer is `1234`.  If value is `selections`, the MFA answer is always the first option.  If value is `questions`, the MFA answer is  `answer_<i>_<j>` for the j-th question in the i-th round, starting from 0. For example, the answer to the first question in the second round is `answer_1_0`.  # noqa: E501

        :return: The type of this MFA.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MFA.

        Possible values are `device`, `selections`, or `questions`.  If value is `device`, the MFA answer is `1234`.  If value is `selections`, the MFA answer is always the first option.  If value is `questions`, the MFA answer is  `answer_<i>_<j>` for the j-th question in the i-th round, starting from 0. For example, the answer to the first question in the second round is `answer_1_0`.  # noqa: E501

        :param type: The type of this MFA.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def question_rounds(self):
        """Gets the question_rounds of this MFA.  # noqa: E501

        Number of rounds of questions. Required if value of `type` is `questions`.   # noqa: E501

        :return: The question_rounds of this MFA.  # noqa: E501
        :rtype: float
        """
        return self._question_rounds

    @question_rounds.setter
    def question_rounds(self, question_rounds):
        """Sets the question_rounds of this MFA.

        Number of rounds of questions. Required if value of `type` is `questions`.   # noqa: E501

        :param question_rounds: The question_rounds of this MFA.  # noqa: E501
        :type question_rounds: float
        """

        self._question_rounds = question_rounds

    @property
    def questions_per_round(self):
        """Gets the questions_per_round of this MFA.  # noqa: E501

        Number of questions per round. Required if value of `type` is `questions`. If value of type is `selections`, default value is 2.  # noqa: E501

        :return: The questions_per_round of this MFA.  # noqa: E501
        :rtype: float
        """
        return self._questions_per_round

    @questions_per_round.setter
    def questions_per_round(self, questions_per_round):
        """Sets the questions_per_round of this MFA.

        Number of questions per round. Required if value of `type` is `questions`. If value of type is `selections`, default value is 2.  # noqa: E501

        :param questions_per_round: The questions_per_round of this MFA.  # noqa: E501
        :type questions_per_round: float
        """

        self._questions_per_round = questions_per_round

    @property
    def selection_rounds(self):
        """Gets the selection_rounds of this MFA.  # noqa: E501

        Number of rounds of selections, used if `type` is `selections`. Defaults to 1.  # noqa: E501

        :return: The selection_rounds of this MFA.  # noqa: E501
        :rtype: float
        """
        return self._selection_rounds

    @selection_rounds.setter
    def selection_rounds(self, selection_rounds):
        """Sets the selection_rounds of this MFA.

        Number of rounds of selections, used if `type` is `selections`. Defaults to 1.  # noqa: E501

        :param selection_rounds: The selection_rounds of this MFA.  # noqa: E501
        :type selection_rounds: float
        """

        self._selection_rounds = selection_rounds

    @property
    def selections_per_question(self):
        """Gets the selections_per_question of this MFA.  # noqa: E501

        Number of available answers per question, used if `type` is `selection`. Defaults to 2.   # noqa: E501

        :return: The selections_per_question of this MFA.  # noqa: E501
        :rtype: float
        """
        return self._selections_per_question

    @selections_per_question.setter
    def selections_per_question(self, selections_per_question):
        """Sets the selections_per_question of this MFA.

        Number of available answers per question, used if `type` is `selection`. Defaults to 2.   # noqa: E501

        :param selections_per_question: The selections_per_question of this MFA.  # noqa: E501
        :type selections_per_question: float
        """

        self._selections_per_question = selections_per_question

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MFA):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MFA):
            return True

        return self.to_dict() != other.to_dict()
