# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class MortgageLiability(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'str',
        'account_number': 'str',
        'current_late_fee': 'float',
        'escrow_balance': 'float',
        'has_pmi': 'bool',
        'has_prepayment_penalty': 'bool',
        'interest_rate': 'MortgageInterestRate',
        'last_payment_amount': 'float',
        'last_payment_date': 'str',
        'loan_type_description': 'str',
        'loan_term': 'str',
        'maturity_date': 'str',
        'next_monthly_payment_amount': 'float',
        'next_payment_due_date': 'str',
        'origination_date': 'str',
        'origination_principal_amount': 'float',
        'past_due_amount': 'float',
        'property_address': 'MortgagePropertyAddress',
        'ytd_interest_paid': 'float',
        'ytd_principal_paid': 'float'
    }

    attribute_map = {
        'account_id': 'account_id',
        'account_number': 'account_number',
        'current_late_fee': 'current_late_fee',
        'escrow_balance': 'escrow_balance',
        'has_pmi': 'has_pmi',
        'has_prepayment_penalty': 'has_prepayment_penalty',
        'interest_rate': 'interest_rate',
        'last_payment_amount': 'last_payment_amount',
        'last_payment_date': 'last_payment_date',
        'loan_type_description': 'loan_type_description',
        'loan_term': 'loan_term',
        'maturity_date': 'maturity_date',
        'next_monthly_payment_amount': 'next_monthly_payment_amount',
        'next_payment_due_date': 'next_payment_due_date',
        'origination_date': 'origination_date',
        'origination_principal_amount': 'origination_principal_amount',
        'past_due_amount': 'past_due_amount',
        'property_address': 'property_address',
        'ytd_interest_paid': 'ytd_interest_paid',
        'ytd_principal_paid': 'ytd_principal_paid'
    }

    def __init__(self, account_id=None, account_number=None, current_late_fee=None, escrow_balance=None, has_pmi=None, has_prepayment_penalty=None, interest_rate=None, last_payment_amount=None, last_payment_date=None, loan_type_description=None, loan_term=None, maturity_date=None, next_monthly_payment_amount=None, next_payment_due_date=None, origination_date=None, origination_principal_amount=None, past_due_amount=None, property_address=None, ytd_interest_paid=None, ytd_principal_paid=None, local_vars_configuration=None):  # noqa: E501
        """MortgageLiability - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._account_number = None
        self._current_late_fee = None
        self._escrow_balance = None
        self._has_pmi = None
        self._has_prepayment_penalty = None
        self._interest_rate = None
        self._last_payment_amount = None
        self._last_payment_date = None
        self._loan_type_description = None
        self._loan_term = None
        self._maturity_date = None
        self._next_monthly_payment_amount = None
        self._next_payment_due_date = None
        self._origination_date = None
        self._origination_principal_amount = None
        self._past_due_amount = None
        self._property_address = None
        self._ytd_interest_paid = None
        self._ytd_principal_paid = None
        self.discriminator = None

        self.account_id = account_id
        if account_number is not None:
            self.account_number = account_number
        self.current_late_fee = current_late_fee
        self.escrow_balance = escrow_balance
        self.has_pmi = has_pmi
        self.has_prepayment_penalty = has_prepayment_penalty
        if interest_rate is not None:
            self.interest_rate = interest_rate
        self.last_payment_amount = last_payment_amount
        self.last_payment_date = last_payment_date
        self.loan_type_description = loan_type_description
        self.loan_term = loan_term
        self.maturity_date = maturity_date
        self.next_monthly_payment_amount = next_monthly_payment_amount
        self.next_payment_due_date = next_payment_due_date
        self.origination_date = origination_date
        self.origination_principal_amount = origination_principal_amount
        self.past_due_amount = past_due_amount
        if property_address is not None:
            self.property_address = property_address
        self.ytd_interest_paid = ytd_interest_paid
        self.ytd_principal_paid = ytd_principal_paid

    @property
    def account_id(self):
        """Gets the account_id of this MortgageLiability.  # noqa: E501

        The ID of the account that this liability belongs to.  # noqa: E501

        :return: The account_id of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this MortgageLiability.

        The ID of the account that this liability belongs to.  # noqa: E501

        :param account_id: The account_id of this MortgageLiability.  # noqa: E501
        :type account_id: str
        """

        self._account_id = account_id

    @property
    def account_number(self):
        """Gets the account_number of this MortgageLiability.  # noqa: E501

        The account number of the loan.  # noqa: E501

        :return: The account_number of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this MortgageLiability.

        The account number of the loan.  # noqa: E501

        :param account_number: The account_number of this MortgageLiability.  # noqa: E501
        :type account_number: str
        """

        self._account_number = account_number

    @property
    def current_late_fee(self):
        """Gets the current_late_fee of this MortgageLiability.  # noqa: E501

        The current outstanding amount charged for late payment.  # noqa: E501

        :return: The current_late_fee of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._current_late_fee

    @current_late_fee.setter
    def current_late_fee(self, current_late_fee):
        """Sets the current_late_fee of this MortgageLiability.

        The current outstanding amount charged for late payment.  # noqa: E501

        :param current_late_fee: The current_late_fee of this MortgageLiability.  # noqa: E501
        :type current_late_fee: float
        """

        self._current_late_fee = current_late_fee

    @property
    def escrow_balance(self):
        """Gets the escrow_balance of this MortgageLiability.  # noqa: E501

        Total amount held in escrow to pay taxes and insurance on behalf of the borrower.  # noqa: E501

        :return: The escrow_balance of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._escrow_balance

    @escrow_balance.setter
    def escrow_balance(self, escrow_balance):
        """Sets the escrow_balance of this MortgageLiability.

        Total amount held in escrow to pay taxes and insurance on behalf of the borrower.  # noqa: E501

        :param escrow_balance: The escrow_balance of this MortgageLiability.  # noqa: E501
        :type escrow_balance: float
        """

        self._escrow_balance = escrow_balance

    @property
    def has_pmi(self):
        """Gets the has_pmi of this MortgageLiability.  # noqa: E501

        Indicates whether the borrower has private mortgage insurance in effect.  # noqa: E501

        :return: The has_pmi of this MortgageLiability.  # noqa: E501
        :rtype: bool
        """
        return self._has_pmi

    @has_pmi.setter
    def has_pmi(self, has_pmi):
        """Sets the has_pmi of this MortgageLiability.

        Indicates whether the borrower has private mortgage insurance in effect.  # noqa: E501

        :param has_pmi: The has_pmi of this MortgageLiability.  # noqa: E501
        :type has_pmi: bool
        """

        self._has_pmi = has_pmi

    @property
    def has_prepayment_penalty(self):
        """Gets the has_prepayment_penalty of this MortgageLiability.  # noqa: E501

        Indicates whether the borrower will pay a penalty for early payoff of mortgage.  # noqa: E501

        :return: The has_prepayment_penalty of this MortgageLiability.  # noqa: E501
        :rtype: bool
        """
        return self._has_prepayment_penalty

    @has_prepayment_penalty.setter
    def has_prepayment_penalty(self, has_prepayment_penalty):
        """Sets the has_prepayment_penalty of this MortgageLiability.

        Indicates whether the borrower will pay a penalty for early payoff of mortgage.  # noqa: E501

        :param has_prepayment_penalty: The has_prepayment_penalty of this MortgageLiability.  # noqa: E501
        :type has_prepayment_penalty: bool
        """

        self._has_prepayment_penalty = has_prepayment_penalty

    @property
    def interest_rate(self):
        """Gets the interest_rate of this MortgageLiability.  # noqa: E501


        :return: The interest_rate of this MortgageLiability.  # noqa: E501
        :rtype: MortgageInterestRate
        """
        return self._interest_rate

    @interest_rate.setter
    def interest_rate(self, interest_rate):
        """Sets the interest_rate of this MortgageLiability.


        :param interest_rate: The interest_rate of this MortgageLiability.  # noqa: E501
        :type interest_rate: MortgageInterestRate
        """

        self._interest_rate = interest_rate

    @property
    def last_payment_amount(self):
        """Gets the last_payment_amount of this MortgageLiability.  # noqa: E501

        The amount of the last payment.  # noqa: E501

        :return: The last_payment_amount of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._last_payment_amount

    @last_payment_amount.setter
    def last_payment_amount(self, last_payment_amount):
        """Sets the last_payment_amount of this MortgageLiability.

        The amount of the last payment.  # noqa: E501

        :param last_payment_amount: The last_payment_amount of this MortgageLiability.  # noqa: E501
        :type last_payment_amount: float
        """

        self._last_payment_amount = last_payment_amount

    @property
    def last_payment_date(self):
        """Gets the last_payment_date of this MortgageLiability.  # noqa: E501

        The date of the last payment. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :return: The last_payment_date of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._last_payment_date

    @last_payment_date.setter
    def last_payment_date(self, last_payment_date):
        """Sets the last_payment_date of this MortgageLiability.

        The date of the last payment. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :param last_payment_date: The last_payment_date of this MortgageLiability.  # noqa: E501
        :type last_payment_date: str
        """

        self._last_payment_date = last_payment_date

    @property
    def loan_type_description(self):
        """Gets the loan_type_description of this MortgageLiability.  # noqa: E501

        Type of mortgage (i.e. `conventional`, `fixed`, `variable`).  # noqa: E501

        :return: The loan_type_description of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._loan_type_description

    @loan_type_description.setter
    def loan_type_description(self, loan_type_description):
        """Sets the loan_type_description of this MortgageLiability.

        Type of mortgage (i.e. `conventional`, `fixed`, `variable`).  # noqa: E501

        :param loan_type_description: The loan_type_description of this MortgageLiability.  # noqa: E501
        :type loan_type_description: str
        """

        self._loan_type_description = loan_type_description

    @property
    def loan_term(self):
        """Gets the loan_term of this MortgageLiability.  # noqa: E501

        Full duration of mortgage as at origination. (`10yr`, `15yr`, `30yr`)  # noqa: E501

        :return: The loan_term of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._loan_term

    @loan_term.setter
    def loan_term(self, loan_term):
        """Sets the loan_term of this MortgageLiability.

        Full duration of mortgage as at origination. (`10yr`, `15yr`, `30yr`)  # noqa: E501

        :param loan_term: The loan_term of this MortgageLiability.  # noqa: E501
        :type loan_term: str
        """

        self._loan_term = loan_term

    @property
    def maturity_date(self):
        """Gets the maturity_date of this MortgageLiability.  # noqa: E501

        Original date on which mortgage is due in full. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :return: The maturity_date of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._maturity_date

    @maturity_date.setter
    def maturity_date(self, maturity_date):
        """Sets the maturity_date of this MortgageLiability.

        Original date on which mortgage is due in full. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :param maturity_date: The maturity_date of this MortgageLiability.  # noqa: E501
        :type maturity_date: str
        """

        self._maturity_date = maturity_date

    @property
    def next_monthly_payment_amount(self):
        """Gets the next_monthly_payment_amount of this MortgageLiability.  # noqa: E501

        The amount of the next payment.  # noqa: E501

        :return: The next_monthly_payment_amount of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._next_monthly_payment_amount

    @next_monthly_payment_amount.setter
    def next_monthly_payment_amount(self, next_monthly_payment_amount):
        """Sets the next_monthly_payment_amount of this MortgageLiability.

        The amount of the next payment.  # noqa: E501

        :param next_monthly_payment_amount: The next_monthly_payment_amount of this MortgageLiability.  # noqa: E501
        :type next_monthly_payment_amount: float
        """

        self._next_monthly_payment_amount = next_monthly_payment_amount

    @property
    def next_payment_due_date(self):
        """Gets the next_payment_due_date of this MortgageLiability.  # noqa: E501

        The due date for the next payment. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :return: The next_payment_due_date of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._next_payment_due_date

    @next_payment_due_date.setter
    def next_payment_due_date(self, next_payment_due_date):
        """Sets the next_payment_due_date of this MortgageLiability.

        The due date for the next payment. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :param next_payment_due_date: The next_payment_due_date of this MortgageLiability.  # noqa: E501
        :type next_payment_due_date: str
        """

        self._next_payment_due_date = next_payment_due_date

    @property
    def origination_date(self):
        """Gets the origination_date of this MortgageLiability.  # noqa: E501

        The date on which the loan was initially lent. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :return: The origination_date of this MortgageLiability.  # noqa: E501
        :rtype: str
        """
        return self._origination_date

    @origination_date.setter
    def origination_date(self, origination_date):
        """Sets the origination_date of this MortgageLiability.

        The date on which the loan was initially lent. Dates are returned in an ISO 8601 format (YYYY-MM-DD).  # noqa: E501

        :param origination_date: The origination_date of this MortgageLiability.  # noqa: E501
        :type origination_date: str
        """

        self._origination_date = origination_date

    @property
    def origination_principal_amount(self):
        """Gets the origination_principal_amount of this MortgageLiability.  # noqa: E501

        The original principal balance of the mortgage.  # noqa: E501

        :return: The origination_principal_amount of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._origination_principal_amount

    @origination_principal_amount.setter
    def origination_principal_amount(self, origination_principal_amount):
        """Sets the origination_principal_amount of this MortgageLiability.

        The original principal balance of the mortgage.  # noqa: E501

        :param origination_principal_amount: The origination_principal_amount of this MortgageLiability.  # noqa: E501
        :type origination_principal_amount: float
        """

        self._origination_principal_amount = origination_principal_amount

    @property
    def past_due_amount(self):
        """Gets the past_due_amount of this MortgageLiability.  # noqa: E501

        Amount of loan (principal + interest) past due for payment.  # noqa: E501

        :return: The past_due_amount of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._past_due_amount

    @past_due_amount.setter
    def past_due_amount(self, past_due_amount):
        """Sets the past_due_amount of this MortgageLiability.

        Amount of loan (principal + interest) past due for payment.  # noqa: E501

        :param past_due_amount: The past_due_amount of this MortgageLiability.  # noqa: E501
        :type past_due_amount: float
        """

        self._past_due_amount = past_due_amount

    @property
    def property_address(self):
        """Gets the property_address of this MortgageLiability.  # noqa: E501


        :return: The property_address of this MortgageLiability.  # noqa: E501
        :rtype: MortgagePropertyAddress
        """
        return self._property_address

    @property_address.setter
    def property_address(self, property_address):
        """Sets the property_address of this MortgageLiability.


        :param property_address: The property_address of this MortgageLiability.  # noqa: E501
        :type property_address: MortgagePropertyAddress
        """

        self._property_address = property_address

    @property
    def ytd_interest_paid(self):
        """Gets the ytd_interest_paid of this MortgageLiability.  # noqa: E501

        The year to date (YTD) interest paid.  # noqa: E501

        :return: The ytd_interest_paid of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._ytd_interest_paid

    @ytd_interest_paid.setter
    def ytd_interest_paid(self, ytd_interest_paid):
        """Sets the ytd_interest_paid of this MortgageLiability.

        The year to date (YTD) interest paid.  # noqa: E501

        :param ytd_interest_paid: The ytd_interest_paid of this MortgageLiability.  # noqa: E501
        :type ytd_interest_paid: float
        """

        self._ytd_interest_paid = ytd_interest_paid

    @property
    def ytd_principal_paid(self):
        """Gets the ytd_principal_paid of this MortgageLiability.  # noqa: E501

        The YTD principal paid.  # noqa: E501

        :return: The ytd_principal_paid of this MortgageLiability.  # noqa: E501
        :rtype: float
        """
        return self._ytd_principal_paid

    @ytd_principal_paid.setter
    def ytd_principal_paid(self, ytd_principal_paid):
        """Sets the ytd_principal_paid of this MortgageLiability.

        The YTD principal paid.  # noqa: E501

        :param ytd_principal_paid: The ytd_principal_paid of this MortgageLiability.  # noqa: E501
        :type ytd_principal_paid: float
        """

        self._ytd_principal_paid = ytd_principal_paid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MortgageLiability):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MortgageLiability):
            return True

        return self.to_dict() != other.to_dict()
