# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class AssetReport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'asset_report_id': 'str',
        'client_report_id': 'str',
        'date_generated': 'str',
        'days_requested': 'float',
        'user': 'AssetReportUser',
        'items': 'list[AssetReportItem]'
    }

    attribute_map = {
        'asset_report_id': 'asset_report_id',
        'client_report_id': 'client_report_id',
        'date_generated': 'date_generated',
        'days_requested': 'days_requested',
        'user': 'user',
        'items': 'items'
    }

    def __init__(self, asset_report_id=None, client_report_id=None, date_generated=None, days_requested=None, user=None, items=None, local_vars_configuration=None):  # noqa: E501
        """AssetReport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._asset_report_id = None
        self._client_report_id = None
        self._date_generated = None
        self._days_requested = None
        self._user = None
        self._items = None
        self.discriminator = None

        if asset_report_id is not None:
            self.asset_report_id = asset_report_id
        if client_report_id is not None:
            self.client_report_id = client_report_id
        if date_generated is not None:
            self.date_generated = date_generated
        if days_requested is not None:
            self.days_requested = days_requested
        if user is not None:
            self.user = user
        if items is not None:
            self.items = items

    @property
    def asset_report_id(self):
        """Gets the asset_report_id of this AssetReport.  # noqa: E501

        A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.  # noqa: E501

        :return: The asset_report_id of this AssetReport.  # noqa: E501
        :rtype: str
        """
        return self._asset_report_id

    @asset_report_id.setter
    def asset_report_id(self, asset_report_id):
        """Sets the asset_report_id of this AssetReport.

        A unique ID identifying an Asset Report. Like all Plaid identifiers, this ID is case sensitive.  # noqa: E501

        :param asset_report_id: The asset_report_id of this AssetReport.  # noqa: E501
        :type asset_report_id: str
        """

        self._asset_report_id = asset_report_id

    @property
    def client_report_id(self):
        """Gets the client_report_id of this AssetReport.  # noqa: E501

        An identifier you determine and submit for the Asset Report.  # noqa: E501

        :return: The client_report_id of this AssetReport.  # noqa: E501
        :rtype: str
        """
        return self._client_report_id

    @client_report_id.setter
    def client_report_id(self, client_report_id):
        """Sets the client_report_id of this AssetReport.

        An identifier you determine and submit for the Asset Report.  # noqa: E501

        :param client_report_id: The client_report_id of this AssetReport.  # noqa: E501
        :type client_report_id: str
        """

        self._client_report_id = client_report_id

    @property
    def date_generated(self):
        """Gets the date_generated of this AssetReport.  # noqa: E501

        The date and time when the Asset Report was created, in ISO 8601 format (e.g. \"2018-04-12T03:32:11Z\").  # noqa: E501

        :return: The date_generated of this AssetReport.  # noqa: E501
        :rtype: str
        """
        return self._date_generated

    @date_generated.setter
    def date_generated(self, date_generated):
        """Sets the date_generated of this AssetReport.

        The date and time when the Asset Report was created, in ISO 8601 format (e.g. \"2018-04-12T03:32:11Z\").  # noqa: E501

        :param date_generated: The date_generated of this AssetReport.  # noqa: E501
        :type date_generated: str
        """

        self._date_generated = date_generated

    @property
    def days_requested(self):
        """Gets the days_requested of this AssetReport.  # noqa: E501

        The duration of transaction history you requested  # noqa: E501

        :return: The days_requested of this AssetReport.  # noqa: E501
        :rtype: float
        """
        return self._days_requested

    @days_requested.setter
    def days_requested(self, days_requested):
        """Sets the days_requested of this AssetReport.

        The duration of transaction history you requested  # noqa: E501

        :param days_requested: The days_requested of this AssetReport.  # noqa: E501
        :type days_requested: float
        """

        self._days_requested = days_requested

    @property
    def user(self):
        """Gets the user of this AssetReport.  # noqa: E501


        :return: The user of this AssetReport.  # noqa: E501
        :rtype: AssetReportUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this AssetReport.


        :param user: The user of this AssetReport.  # noqa: E501
        :type user: AssetReportUser
        """

        self._user = user

    @property
    def items(self):
        """Gets the items of this AssetReport.  # noqa: E501

        Data returned by Plaid about each of the Items included in the Asset Report.  # noqa: E501

        :return: The items of this AssetReport.  # noqa: E501
        :rtype: list[AssetReportItem]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this AssetReport.

        Data returned by Plaid about each of the Items included in the Asset Report.  # noqa: E501

        :param items: The items of this AssetReport.  # noqa: E501
        :type items: list[AssetReportItem]
        """

        self._items = items

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetReport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetReport):
            return True

        return self.to_dict() != other.to_dict()
