# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class AssetReportCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'client_id': 'str',
        'secret': 'str',
        'access_tokens': 'list[str]',
        'days_requested': 'int',
        'options': 'AssetReportCreateRequestOptions'
    }

    attribute_map = {
        'client_id': 'client_id',
        'secret': 'secret',
        'access_tokens': 'access_tokens',
        'days_requested': 'days_requested',
        'options': 'options'
    }

    def __init__(self, client_id=None, secret=None, access_tokens=None, days_requested=None, options=None, local_vars_configuration=None):  # noqa: E501
        """AssetReportCreateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._client_id = None
        self._secret = None
        self._access_tokens = None
        self._days_requested = None
        self._options = None
        self.discriminator = None

        self.client_id = client_id
        self.secret = secret
        self.access_tokens = access_tokens
        self.days_requested = days_requested
        if options is not None:
            self.options = options

    @property
    def client_id(self):
        """Gets the client_id of this AssetReportCreateRequest.  # noqa: E501

        Your Plaid API `client_id`.  # noqa: E501

        :return: The client_id of this AssetReportCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this AssetReportCreateRequest.

        Your Plaid API `client_id`.  # noqa: E501

        :param client_id: The client_id of this AssetReportCreateRequest.  # noqa: E501
        :type client_id: str
        """
        if self.local_vars_configuration.client_side_validation and client_id is None:  # noqa: E501
            raise ValueError("Invalid value for `client_id`, must not be `None`")  # noqa: E501

        self._client_id = client_id

    @property
    def secret(self):
        """Gets the secret of this AssetReportCreateRequest.  # noqa: E501

        Your Plaid API `secret`.  # noqa: E501

        :return: The secret of this AssetReportCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._secret

    @secret.setter
    def secret(self, secret):
        """Sets the secret of this AssetReportCreateRequest.

        Your Plaid API `secret`.  # noqa: E501

        :param secret: The secret of this AssetReportCreateRequest.  # noqa: E501
        :type secret: str
        """
        if self.local_vars_configuration.client_side_validation and secret is None:  # noqa: E501
            raise ValueError("Invalid value for `secret`, must not be `None`")  # noqa: E501

        self._secret = secret

    @property
    def access_tokens(self):
        """Gets the access_tokens of this AssetReportCreateRequest.  # noqa: E501

        An array of access tokens corresponding to the Items that will be included in the report. The `assets` product must have been initialized for the Items during link; the Assets product cannot be added after initialization.  # noqa: E501

        :return: The access_tokens of this AssetReportCreateRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._access_tokens

    @access_tokens.setter
    def access_tokens(self, access_tokens):
        """Sets the access_tokens of this AssetReportCreateRequest.

        An array of access tokens corresponding to the Items that will be included in the report. The `assets` product must have been initialized for the Items during link; the Assets product cannot be added after initialization.  # noqa: E501

        :param access_tokens: The access_tokens of this AssetReportCreateRequest.  # noqa: E501
        :type access_tokens: list[str]
        """
        if self.local_vars_configuration.client_side_validation and access_tokens is None:  # noqa: E501
            raise ValueError("Invalid value for `access_tokens`, must not be `None`")  # noqa: E501

        self._access_tokens = access_tokens

    @property
    def days_requested(self):
        """Gets the days_requested of this AssetReportCreateRequest.  # noqa: E501

        The maximum integer number of days of history to include in the Asset Report. If using Fannie Mae Day 1 Certainty, `days_requested` must be at least 61 for new originations or at least 31 for refinancings.  # noqa: E501

        :return: The days_requested of this AssetReportCreateRequest.  # noqa: E501
        :rtype: int
        """
        return self._days_requested

    @days_requested.setter
    def days_requested(self, days_requested):
        """Sets the days_requested of this AssetReportCreateRequest.

        The maximum integer number of days of history to include in the Asset Report. If using Fannie Mae Day 1 Certainty, `days_requested` must be at least 61 for new originations or at least 31 for refinancings.  # noqa: E501

        :param days_requested: The days_requested of this AssetReportCreateRequest.  # noqa: E501
        :type days_requested: int
        """
        if self.local_vars_configuration.client_side_validation and days_requested is None:  # noqa: E501
            raise ValueError("Invalid value for `days_requested`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                days_requested is not None and days_requested > 730):  # noqa: E501
            raise ValueError("Invalid value for `days_requested`, must be a value less than or equal to `730`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                days_requested is not None and days_requested < 0):  # noqa: E501
            raise ValueError("Invalid value for `days_requested`, must be a value greater than or equal to `0`")  # noqa: E501

        self._days_requested = days_requested

    @property
    def options(self):
        """Gets the options of this AssetReportCreateRequest.  # noqa: E501


        :return: The options of this AssetReportCreateRequest.  # noqa: E501
        :rtype: AssetReportCreateRequestOptions
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this AssetReportCreateRequest.


        :param options: The options of this AssetReportCreateRequest.  # noqa: E501
        :type options: AssetReportCreateRequestOptions
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetReportCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetReportCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
