# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class InflowModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'income_amount': 'float',
        'payment_day_of_month': 'float',
        'transaction_name': 'str',
        'statement_day_of_month': 'str'
    }

    attribute_map = {
        'type': 'type',
        'income_amount': 'income_amount',
        'payment_day_of_month': 'payment_day_of_month',
        'transaction_name': 'transaction_name',
        'statement_day_of_month': 'statement_day_of_month'
    }

    def __init__(self, type=None, income_amount=None, payment_day_of_month=None, transaction_name=None, statement_day_of_month=None, local_vars_configuration=None):  # noqa: E501
        """InflowModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._income_amount = None
        self._payment_day_of_month = None
        self._transaction_name = None
        self._statement_day_of_month = None
        self.discriminator = None

        self.type = type
        if income_amount is not None:
            self.income_amount = income_amount
        if payment_day_of_month is not None:
            self.payment_day_of_month = payment_day_of_month
        if transaction_name is not None:
            self.transaction_name = transaction_name
        if statement_day_of_month is not None:
            self.statement_day_of_month = statement_day_of_month

    @property
    def type(self):
        """Gets the type of this InflowModel.  # noqa: E501

        Inflow model. One of the following:  `none`: No income `monthly-income`: Income occurs once per month `monthly-balance-payment`: Pays off the balance on a liability account at the given statement day of month `monthly-interest-only-payment`: Makes an interest-only payment on a liability account at the given statement day of month. Note that account types supported by Liabilities will accrue interest in the Sandbox. The types are account type `credit` with subtype `credit` or `paypal`, and account type `loan` with subtype `student` or `mortgage`.  # noqa: E501

        :return: The type of this InflowModel.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this InflowModel.

        Inflow model. One of the following:  `none`: No income `monthly-income`: Income occurs once per month `monthly-balance-payment`: Pays off the balance on a liability account at the given statement day of month `monthly-interest-only-payment`: Makes an interest-only payment on a liability account at the given statement day of month. Note that account types supported by Liabilities will accrue interest in the Sandbox. The types are account type `credit` with subtype `credit` or `paypal`, and account type `loan` with subtype `student` or `mortgage`.  # noqa: E501

        :param type: The type of this InflowModel.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def income_amount(self):
        """Gets the income_amount of this InflowModel.  # noqa: E501

        Amount of income per month. This value is required if `type` is `monthly-income`.  # noqa: E501

        :return: The income_amount of this InflowModel.  # noqa: E501
        :rtype: float
        """
        return self._income_amount

    @income_amount.setter
    def income_amount(self, income_amount):
        """Sets the income_amount of this InflowModel.

        Amount of income per month. This value is required if `type` is `monthly-income`.  # noqa: E501

        :param income_amount: The income_amount of this InflowModel.  # noqa: E501
        :type income_amount: float
        """

        self._income_amount = income_amount

    @property
    def payment_day_of_month(self):
        """Gets the payment_day_of_month of this InflowModel.  # noqa: E501

        Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the income transaction will appear. The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :return: The payment_day_of_month of this InflowModel.  # noqa: E501
        :rtype: float
        """
        return self._payment_day_of_month

    @payment_day_of_month.setter
    def payment_day_of_month(self, payment_day_of_month):
        """Sets the payment_day_of_month of this InflowModel.

        Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the income transaction will appear. The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :param payment_day_of_month: The payment_day_of_month of this InflowModel.  # noqa: E501
        :type payment_day_of_month: float
        """

        self._payment_day_of_month = payment_day_of_month

    @property
    def transaction_name(self):
        """Gets the transaction_name of this InflowModel.  # noqa: E501

        The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :return: The transaction_name of this InflowModel.  # noqa: E501
        :rtype: str
        """
        return self._transaction_name

    @transaction_name.setter
    def transaction_name(self, transaction_name):
        """Sets the transaction_name of this InflowModel.

        The name of the income transaction. This field is required if `type` is `monthly-income`, `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :param transaction_name: The transaction_name of this InflowModel.  # noqa: E501
        :type transaction_name: str
        """

        self._transaction_name = transaction_name

    @property
    def statement_day_of_month(self):
        """Gets the statement_day_of_month of this InflowModel.  # noqa: E501

        Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the balance is calculated for the next payment. The name of the income transaction. This field is required if `type` is `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :return: The statement_day_of_month of this InflowModel.  # noqa: E501
        :rtype: str
        """
        return self._statement_day_of_month

    @statement_day_of_month.setter
    def statement_day_of_month(self, statement_day_of_month):
        """Sets the statement_day_of_month of this InflowModel.

        Number between 1 and 28, or `last` meaning the last day of the month. The day of the month on which the balance is calculated for the next payment. The name of the income transaction. This field is required if `type` is `monthly-balance-payment` or `monthly-interest-only-payment`.  # noqa: E501

        :param statement_day_of_month: The statement_day_of_month of this InflowModel.  # noqa: E501
        :type statement_day_of_month: str
        """

        self._statement_day_of_month = statement_day_of_month

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InflowModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InflowModel):
            return True

        return self.to_dict() != other.to_dict()
