# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class JWKPublicKey(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'alg': 'str',
        'crv': 'str',
        'kid': 'str',
        'kty': 'str',
        'use': 'str',
        'x': 'str',
        'y': 'str'
    }

    attribute_map = {
        'alg': 'alg',
        'crv': 'crv',
        'kid': 'kid',
        'kty': 'kty',
        'use': 'use',
        'x': 'x',
        'y': 'y'
    }

    def __init__(self, alg=None, crv=None, kid=None, kty=None, use=None, x=None, y=None, local_vars_configuration=None):  # noqa: E501
        """JWKPublicKey - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._alg = None
        self._crv = None
        self._kid = None
        self._kty = None
        self._use = None
        self._x = None
        self._y = None
        self.discriminator = None

        if alg is not None:
            self.alg = alg
        if crv is not None:
            self.crv = crv
        if kid is not None:
            self.kid = kid
        if kty is not None:
            self.kty = kty
        if use is not None:
            self.use = use
        if x is not None:
            self.x = x
        if y is not None:
            self.y = y

    @property
    def alg(self):
        """Gets the alg of this JWKPublicKey.  # noqa: E501

        The alg member identifies the cryptographic algorithm family used with the key.  # noqa: E501

        :return: The alg of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._alg

    @alg.setter
    def alg(self, alg):
        """Sets the alg of this JWKPublicKey.

        The alg member identifies the cryptographic algorithm family used with the key.  # noqa: E501

        :param alg: The alg of this JWKPublicKey.  # noqa: E501
        :type alg: str
        """

        self._alg = alg

    @property
    def crv(self):
        """Gets the crv of this JWKPublicKey.  # noqa: E501

        The crv member identifies the cryptographic curve used with the key.  # noqa: E501

        :return: The crv of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._crv

    @crv.setter
    def crv(self, crv):
        """Sets the crv of this JWKPublicKey.

        The crv member identifies the cryptographic curve used with the key.  # noqa: E501

        :param crv: The crv of this JWKPublicKey.  # noqa: E501
        :type crv: str
        """

        self._crv = crv

    @property
    def kid(self):
        """Gets the kid of this JWKPublicKey.  # noqa: E501

        The kid (Key ID) member can be used to match a specific key. This can be used, for instance, to choose among a set of keys within the JWK during key rollover.  # noqa: E501

        :return: The kid of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._kid

    @kid.setter
    def kid(self, kid):
        """Sets the kid of this JWKPublicKey.

        The kid (Key ID) member can be used to match a specific key. This can be used, for instance, to choose among a set of keys within the JWK during key rollover.  # noqa: E501

        :param kid: The kid of this JWKPublicKey.  # noqa: E501
        :type kid: str
        """

        self._kid = kid

    @property
    def kty(self):
        """Gets the kty of this JWKPublicKey.  # noqa: E501

        The kty (key type) parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC.  # noqa: E501

        :return: The kty of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._kty

    @kty.setter
    def kty(self, kty):
        """Sets the kty of this JWKPublicKey.

        The kty (key type) parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC.  # noqa: E501

        :param kty: The kty of this JWKPublicKey.  # noqa: E501
        :type kty: str
        """

        self._kty = kty

    @property
    def use(self):
        """Gets the use of this JWKPublicKey.  # noqa: E501

        The use (public key use) parameter identifies the intended use of the public key.  # noqa: E501

        :return: The use of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._use

    @use.setter
    def use(self, use):
        """Sets the use of this JWKPublicKey.

        The use (public key use) parameter identifies the intended use of the public key.  # noqa: E501

        :param use: The use of this JWKPublicKey.  # noqa: E501
        :type use: str
        """

        self._use = use

    @property
    def x(self):
        """Gets the x of this JWKPublicKey.  # noqa: E501

        The x member contains the x coordinate for the elliptic curve point.  # noqa: E501

        :return: The x of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._x

    @x.setter
    def x(self, x):
        """Sets the x of this JWKPublicKey.

        The x member contains the x coordinate for the elliptic curve point.  # noqa: E501

        :param x: The x of this JWKPublicKey.  # noqa: E501
        :type x: str
        """

        self._x = x

    @property
    def y(self):
        """Gets the y of this JWKPublicKey.  # noqa: E501

        The y member contains the y coordinate for the elliptic curve point.  # noqa: E501

        :return: The y of this JWKPublicKey.  # noqa: E501
        :rtype: str
        """
        return self._y

    @y.setter
    def y(self, y):
        """Sets the y of this JWKPublicKey.

        The y member contains the y coordinate for the elliptic curve point.  # noqa: E501

        :param y: The y of this JWKPublicKey.  # noqa: E501
        :type y: str
        """

        self._y = y

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JWKPublicKey):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JWKPublicKey):
            return True

        return self.to_dict() != other.to_dict()
