# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class LiabilityOverride(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'str',
        'purchase_apr': 'float',
        'cash_apr': 'float',
        'balance_transfer_apr': 'float',
        'special_apr': 'float',
        'last_payment_amount': 'float',
        'last_statement_balance': 'float',
        'minimum_payment_amount': 'float',
        'is_overdue': 'bool',
        'origination_date': 'str',
        'principal': 'float',
        'nominal_apr': 'float',
        'interest_capitalization_grace_period_months': 'float',
        'repayment_model': 'StudentLoanRepaymentModel',
        'expected_payoff_date': 'str',
        'guarantor': 'str',
        'is_federal': 'bool',
        'loan_name': 'str',
        'loan_status': 'str',
        'payment_reference_number': 'str',
        'pslf_status': 'str',
        'repayment_plan_description': 'str',
        'repayment_plan_type': 'str',
        'sequence_number': 'str',
        'servicer_address': 'Address'
    }

    attribute_map = {
        'type': 'type',
        'purchase_apr': 'purchase_apr',
        'cash_apr': 'cash_apr',
        'balance_transfer_apr': 'balance_transfer_apr',
        'special_apr': 'special_apr',
        'last_payment_amount': 'last_payment_amount',
        'last_statement_balance': 'last_statement_balance',
        'minimum_payment_amount': 'minimum_payment_amount',
        'is_overdue': 'is_overdue',
        'origination_date': 'origination_date',
        'principal': 'principal',
        'nominal_apr': 'nominal_apr',
        'interest_capitalization_grace_period_months': 'interest_capitalization_grace_period_months',
        'repayment_model': 'repayment_model',
        'expected_payoff_date': 'expected_payoff_date',
        'guarantor': 'guarantor',
        'is_federal': 'is_federal',
        'loan_name': 'loan_name',
        'loan_status': 'loan_status',
        'payment_reference_number': 'payment_reference_number',
        'pslf_status': 'pslf_status',
        'repayment_plan_description': 'repayment_plan_description',
        'repayment_plan_type': 'repayment_plan_type',
        'sequence_number': 'sequence_number',
        'servicer_address': 'servicer_address'
    }

    def __init__(self, type=None, purchase_apr=None, cash_apr=None, balance_transfer_apr=None, special_apr=None, last_payment_amount=None, last_statement_balance=None, minimum_payment_amount=None, is_overdue=None, origination_date=None, principal=None, nominal_apr=None, interest_capitalization_grace_period_months=None, repayment_model=None, expected_payoff_date=None, guarantor=None, is_federal=None, loan_name=None, loan_status=None, payment_reference_number=None, pslf_status=None, repayment_plan_description=None, repayment_plan_type=None, sequence_number=None, servicer_address=None, local_vars_configuration=None):  # noqa: E501
        """LiabilityOverride - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._purchase_apr = None
        self._cash_apr = None
        self._balance_transfer_apr = None
        self._special_apr = None
        self._last_payment_amount = None
        self._last_statement_balance = None
        self._minimum_payment_amount = None
        self._is_overdue = None
        self._origination_date = None
        self._principal = None
        self._nominal_apr = None
        self._interest_capitalization_grace_period_months = None
        self._repayment_model = None
        self._expected_payoff_date = None
        self._guarantor = None
        self._is_federal = None
        self._loan_name = None
        self._loan_status = None
        self._payment_reference_number = None
        self._pslf_status = None
        self._repayment_plan_description = None
        self._repayment_plan_type = None
        self._sequence_number = None
        self._servicer_address = None
        self.discriminator = None

        self.type = type
        if purchase_apr is not None:
            self.purchase_apr = purchase_apr
        if cash_apr is not None:
            self.cash_apr = cash_apr
        if balance_transfer_apr is not None:
            self.balance_transfer_apr = balance_transfer_apr
        if special_apr is not None:
            self.special_apr = special_apr
        if last_payment_amount is not None:
            self.last_payment_amount = last_payment_amount
        if last_statement_balance is not None:
            self.last_statement_balance = last_statement_balance
        if minimum_payment_amount is not None:
            self.minimum_payment_amount = minimum_payment_amount
        if is_overdue is not None:
            self.is_overdue = is_overdue
        if origination_date is not None:
            self.origination_date = origination_date
        if principal is not None:
            self.principal = principal
        if nominal_apr is not None:
            self.nominal_apr = nominal_apr
        if interest_capitalization_grace_period_months is not None:
            self.interest_capitalization_grace_period_months = interest_capitalization_grace_period_months
        if repayment_model is not None:
            self.repayment_model = repayment_model
        if expected_payoff_date is not None:
            self.expected_payoff_date = expected_payoff_date
        if guarantor is not None:
            self.guarantor = guarantor
        if is_federal is not None:
            self.is_federal = is_federal
        if loan_name is not None:
            self.loan_name = loan_name
        if loan_status is not None:
            self.loan_status = loan_status
        if payment_reference_number is not None:
            self.payment_reference_number = payment_reference_number
        if pslf_status is not None:
            self.pslf_status = pslf_status
        if repayment_plan_description is not None:
            self.repayment_plan_description = repayment_plan_description
        if repayment_plan_type is not None:
            self.repayment_plan_type = repayment_plan_type
        if sequence_number is not None:
            self.sequence_number = sequence_number
        if servicer_address is not None:
            self.servicer_address = servicer_address

    @property
    def type(self):
        """Gets the type of this LiabilityOverride.  # noqa: E501

        The type of the liability object, either `credit` or `student`.  # noqa: E501

        :return: The type of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this LiabilityOverride.

        The type of the liability object, either `credit` or `student`.  # noqa: E501

        :param type: The type of this LiabilityOverride.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def purchase_apr(self):
        """Gets the purchase_apr of this LiabilityOverride.  # noqa: E501

        The purchase APR percentage value. For simplicity, this is the only interest rate used to calculate interest charges. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The purchase_apr of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._purchase_apr

    @purchase_apr.setter
    def purchase_apr(self, purchase_apr):
        """Sets the purchase_apr of this LiabilityOverride.

        The purchase APR percentage value. For simplicity, this is the only interest rate used to calculate interest charges. Can only be set if `type` is `credit`.  # noqa: E501

        :param purchase_apr: The purchase_apr of this LiabilityOverride.  # noqa: E501
        :type purchase_apr: float
        """

        self._purchase_apr = purchase_apr

    @property
    def cash_apr(self):
        """Gets the cash_apr of this LiabilityOverride.  # noqa: E501

        The cash APR percentage value. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The cash_apr of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._cash_apr

    @cash_apr.setter
    def cash_apr(self, cash_apr):
        """Sets the cash_apr of this LiabilityOverride.

        The cash APR percentage value. Can only be set if `type` is `credit`.  # noqa: E501

        :param cash_apr: The cash_apr of this LiabilityOverride.  # noqa: E501
        :type cash_apr: float
        """

        self._cash_apr = cash_apr

    @property
    def balance_transfer_apr(self):
        """Gets the balance_transfer_apr of this LiabilityOverride.  # noqa: E501

        The balance transfer APR percentage value. Can only be set if `type` is `credit`. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The balance_transfer_apr of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._balance_transfer_apr

    @balance_transfer_apr.setter
    def balance_transfer_apr(self, balance_transfer_apr):
        """Sets the balance_transfer_apr of this LiabilityOverride.

        The balance transfer APR percentage value. Can only be set if `type` is `credit`. Can only be set if `type` is `credit`.  # noqa: E501

        :param balance_transfer_apr: The balance_transfer_apr of this LiabilityOverride.  # noqa: E501
        :type balance_transfer_apr: float
        """

        self._balance_transfer_apr = balance_transfer_apr

    @property
    def special_apr(self):
        """Gets the special_apr of this LiabilityOverride.  # noqa: E501

        The special APR percentage value. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The special_apr of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._special_apr

    @special_apr.setter
    def special_apr(self, special_apr):
        """Sets the special_apr of this LiabilityOverride.

        The special APR percentage value. Can only be set if `type` is `credit`.  # noqa: E501

        :param special_apr: The special_apr of this LiabilityOverride.  # noqa: E501
        :type special_apr: float
        """

        self._special_apr = special_apr

    @property
    def last_payment_amount(self):
        """Gets the last_payment_amount of this LiabilityOverride.  # noqa: E501

        Override the `last_payment_amount` field. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The last_payment_amount of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._last_payment_amount

    @last_payment_amount.setter
    def last_payment_amount(self, last_payment_amount):
        """Sets the last_payment_amount of this LiabilityOverride.

        Override the `last_payment_amount` field. Can only be set if `type` is `credit`.  # noqa: E501

        :param last_payment_amount: The last_payment_amount of this LiabilityOverride.  # noqa: E501
        :type last_payment_amount: float
        """

        self._last_payment_amount = last_payment_amount

    @property
    def last_statement_balance(self):
        """Gets the last_statement_balance of this LiabilityOverride.  # noqa: E501

        Override the `last_statement_balance` field. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The last_statement_balance of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._last_statement_balance

    @last_statement_balance.setter
    def last_statement_balance(self, last_statement_balance):
        """Sets the last_statement_balance of this LiabilityOverride.

        Override the `last_statement_balance` field. Can only be set if `type` is `credit`.  # noqa: E501

        :param last_statement_balance: The last_statement_balance of this LiabilityOverride.  # noqa: E501
        :type last_statement_balance: float
        """

        self._last_statement_balance = last_statement_balance

    @property
    def minimum_payment_amount(self):
        """Gets the minimum_payment_amount of this LiabilityOverride.  # noqa: E501

        Override the `minimum_payment_amount` field. Can only be set if `type` is `credit`.  # noqa: E501

        :return: The minimum_payment_amount of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._minimum_payment_amount

    @minimum_payment_amount.setter
    def minimum_payment_amount(self, minimum_payment_amount):
        """Sets the minimum_payment_amount of this LiabilityOverride.

        Override the `minimum_payment_amount` field. Can only be set if `type` is `credit`.  # noqa: E501

        :param minimum_payment_amount: The minimum_payment_amount of this LiabilityOverride.  # noqa: E501
        :type minimum_payment_amount: float
        """

        self._minimum_payment_amount = minimum_payment_amount

    @property
    def is_overdue(self):
        """Gets the is_overdue of this LiabilityOverride.  # noqa: E501

        Override the `is_overdue` field  # noqa: E501

        :return: The is_overdue of this LiabilityOverride.  # noqa: E501
        :rtype: bool
        """
        return self._is_overdue

    @is_overdue.setter
    def is_overdue(self, is_overdue):
        """Sets the is_overdue of this LiabilityOverride.

        Override the `is_overdue` field  # noqa: E501

        :param is_overdue: The is_overdue of this LiabilityOverride.  # noqa: E501
        :type is_overdue: bool
        """

        self._is_overdue = is_overdue

    @property
    def origination_date(self):
        """Gets the origination_date of this LiabilityOverride.  # noqa: E501

        The date on which the loan was initially lent, in ISO 8601 (YYYY-MM-DD) format. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The origination_date of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._origination_date

    @origination_date.setter
    def origination_date(self, origination_date):
        """Sets the origination_date of this LiabilityOverride.

        The date on which the loan was initially lent, in ISO 8601 (YYYY-MM-DD) format. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param origination_date: The origination_date of this LiabilityOverride.  # noqa: E501
        :type origination_date: str
        """

        self._origination_date = origination_date

    @property
    def principal(self):
        """Gets the principal of this LiabilityOverride.  # noqa: E501

        The original loan principal. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The principal of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._principal

    @principal.setter
    def principal(self, principal):
        """Sets the principal of this LiabilityOverride.

        The original loan principal. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param principal: The principal of this LiabilityOverride.  # noqa: E501
        :type principal: float
        """

        self._principal = principal

    @property
    def nominal_apr(self):
        """Gets the nominal_apr of this LiabilityOverride.  # noqa: E501

        The interest rate on the loan as a percentage. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The nominal_apr of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._nominal_apr

    @nominal_apr.setter
    def nominal_apr(self, nominal_apr):
        """Sets the nominal_apr of this LiabilityOverride.

        The interest rate on the loan as a percentage. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param nominal_apr: The nominal_apr of this LiabilityOverride.  # noqa: E501
        :type nominal_apr: float
        """

        self._nominal_apr = nominal_apr

    @property
    def interest_capitalization_grace_period_months(self):
        """Gets the interest_capitalization_grace_period_months of this LiabilityOverride.  # noqa: E501

        If set, interest capitalization begins at the given number of months after loan origination. By default interest is never capitalized. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The interest_capitalization_grace_period_months of this LiabilityOverride.  # noqa: E501
        :rtype: float
        """
        return self._interest_capitalization_grace_period_months

    @interest_capitalization_grace_period_months.setter
    def interest_capitalization_grace_period_months(self, interest_capitalization_grace_period_months):
        """Sets the interest_capitalization_grace_period_months of this LiabilityOverride.

        If set, interest capitalization begins at the given number of months after loan origination. By default interest is never capitalized. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param interest_capitalization_grace_period_months: The interest_capitalization_grace_period_months of this LiabilityOverride.  # noqa: E501
        :type interest_capitalization_grace_period_months: float
        """

        self._interest_capitalization_grace_period_months = interest_capitalization_grace_period_months

    @property
    def repayment_model(self):
        """Gets the repayment_model of this LiabilityOverride.  # noqa: E501


        :return: The repayment_model of this LiabilityOverride.  # noqa: E501
        :rtype: StudentLoanRepaymentModel
        """
        return self._repayment_model

    @repayment_model.setter
    def repayment_model(self, repayment_model):
        """Sets the repayment_model of this LiabilityOverride.


        :param repayment_model: The repayment_model of this LiabilityOverride.  # noqa: E501
        :type repayment_model: StudentLoanRepaymentModel
        """

        self._repayment_model = repayment_model

    @property
    def expected_payoff_date(self):
        """Gets the expected_payoff_date of this LiabilityOverride.  # noqa: E501

        Override the `expected_payoff_date` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The expected_payoff_date of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._expected_payoff_date

    @expected_payoff_date.setter
    def expected_payoff_date(self, expected_payoff_date):
        """Sets the expected_payoff_date of this LiabilityOverride.

        Override the `expected_payoff_date` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param expected_payoff_date: The expected_payoff_date of this LiabilityOverride.  # noqa: E501
        :type expected_payoff_date: str
        """

        self._expected_payoff_date = expected_payoff_date

    @property
    def guarantor(self):
        """Gets the guarantor of this LiabilityOverride.  # noqa: E501

        Override the `guarantor` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The guarantor of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._guarantor

    @guarantor.setter
    def guarantor(self, guarantor):
        """Sets the guarantor of this LiabilityOverride.

        Override the `guarantor` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param guarantor: The guarantor of this LiabilityOverride.  # noqa: E501
        :type guarantor: str
        """

        self._guarantor = guarantor

    @property
    def is_federal(self):
        """Gets the is_federal of this LiabilityOverride.  # noqa: E501

        Override the `is_federal` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The is_federal of this LiabilityOverride.  # noqa: E501
        :rtype: bool
        """
        return self._is_federal

    @is_federal.setter
    def is_federal(self, is_federal):
        """Sets the is_federal of this LiabilityOverride.

        Override the `is_federal` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param is_federal: The is_federal of this LiabilityOverride.  # noqa: E501
        :type is_federal: bool
        """

        self._is_federal = is_federal

    @property
    def loan_name(self):
        """Gets the loan_name of this LiabilityOverride.  # noqa: E501

        Override the `loan_name` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The loan_name of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._loan_name

    @loan_name.setter
    def loan_name(self, loan_name):
        """Sets the loan_name of this LiabilityOverride.

        Override the `loan_name` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param loan_name: The loan_name of this LiabilityOverride.  # noqa: E501
        :type loan_name: str
        """

        self._loan_name = loan_name

    @property
    def loan_status(self):
        """Gets the loan_status of this LiabilityOverride.  # noqa: E501

        Override the `loan_status` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The loan_status of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._loan_status

    @loan_status.setter
    def loan_status(self, loan_status):
        """Sets the loan_status of this LiabilityOverride.

        Override the `loan_status` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param loan_status: The loan_status of this LiabilityOverride.  # noqa: E501
        :type loan_status: str
        """

        self._loan_status = loan_status

    @property
    def payment_reference_number(self):
        """Gets the payment_reference_number of this LiabilityOverride.  # noqa: E501

        Override the `payment_reference_number` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The payment_reference_number of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._payment_reference_number

    @payment_reference_number.setter
    def payment_reference_number(self, payment_reference_number):
        """Sets the payment_reference_number of this LiabilityOverride.

        Override the `payment_reference_number` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param payment_reference_number: The payment_reference_number of this LiabilityOverride.  # noqa: E501
        :type payment_reference_number: str
        """

        self._payment_reference_number = payment_reference_number

    @property
    def pslf_status(self):
        """Gets the pslf_status of this LiabilityOverride.  # noqa: E501

        Override the `pslf_status` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The pslf_status of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._pslf_status

    @pslf_status.setter
    def pslf_status(self, pslf_status):
        """Sets the pslf_status of this LiabilityOverride.

        Override the `pslf_status` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param pslf_status: The pslf_status of this LiabilityOverride.  # noqa: E501
        :type pslf_status: str
        """

        self._pslf_status = pslf_status

    @property
    def repayment_plan_description(self):
        """Gets the repayment_plan_description of this LiabilityOverride.  # noqa: E501

        Override the `repayment_plan.description` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The repayment_plan_description of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._repayment_plan_description

    @repayment_plan_description.setter
    def repayment_plan_description(self, repayment_plan_description):
        """Sets the repayment_plan_description of this LiabilityOverride.

        Override the `repayment_plan.description` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param repayment_plan_description: The repayment_plan_description of this LiabilityOverride.  # noqa: E501
        :type repayment_plan_description: str
        """

        self._repayment_plan_description = repayment_plan_description

    @property
    def repayment_plan_type(self):
        """Gets the repayment_plan_type of this LiabilityOverride.  # noqa: E501

        Override the `repayment_plan.type` field. Can only be set if `type` is `student_loan`. Possible values are: `\"extended graduated\"`, `\"extended standard\"`, `\"graduated\"`, `\"income-contingent repayment\"`, `\"income-based repayment\"`, `\"interest only\"`, `\"other\"`, `\"pay as you earn\"`, `\"revised pay as you earn\"`, or `\"standard\"`.  # noqa: E501

        :return: The repayment_plan_type of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._repayment_plan_type

    @repayment_plan_type.setter
    def repayment_plan_type(self, repayment_plan_type):
        """Sets the repayment_plan_type of this LiabilityOverride.

        Override the `repayment_plan.type` field. Can only be set if `type` is `student_loan`. Possible values are: `\"extended graduated\"`, `\"extended standard\"`, `\"graduated\"`, `\"income-contingent repayment\"`, `\"income-based repayment\"`, `\"interest only\"`, `\"other\"`, `\"pay as you earn\"`, `\"revised pay as you earn\"`, or `\"standard\"`.  # noqa: E501

        :param repayment_plan_type: The repayment_plan_type of this LiabilityOverride.  # noqa: E501
        :type repayment_plan_type: str
        """

        self._repayment_plan_type = repayment_plan_type

    @property
    def sequence_number(self):
        """Gets the sequence_number of this LiabilityOverride.  # noqa: E501

        Override the `sequence_number` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :return: The sequence_number of this LiabilityOverride.  # noqa: E501
        :rtype: str
        """
        return self._sequence_number

    @sequence_number.setter
    def sequence_number(self, sequence_number):
        """Sets the sequence_number of this LiabilityOverride.

        Override the `sequence_number` field. Can only be set if `type` is `student_loan`.  # noqa: E501

        :param sequence_number: The sequence_number of this LiabilityOverride.  # noqa: E501
        :type sequence_number: str
        """

        self._sequence_number = sequence_number

    @property
    def servicer_address(self):
        """Gets the servicer_address of this LiabilityOverride.  # noqa: E501


        :return: The servicer_address of this LiabilityOverride.  # noqa: E501
        :rtype: Address
        """
        return self._servicer_address

    @servicer_address.setter
    def servicer_address(self, servicer_address):
        """Sets the servicer_address of this LiabilityOverride.


        :param servicer_address: The servicer_address of this LiabilityOverride.  # noqa: E501
        :type servicer_address: Address
        """

        self._servicer_address = servicer_address

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LiabilityOverride):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LiabilityOverride):
            return True

        return self.to_dict() != other.to_dict()
