# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class PaymentInitiationPaymentTokenCreateResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'payment_token': 'str',
        'payment_token_expiration_time': 'str',
        'request_id': 'str'
    }

    attribute_map = {
        'payment_token': 'payment_token',
        'payment_token_expiration_time': 'payment_token_expiration_time',
        'request_id': 'request_id'
    }

    def __init__(self, payment_token=None, payment_token_expiration_time=None, request_id=None, local_vars_configuration=None):  # noqa: E501
        """PaymentInitiationPaymentTokenCreateResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._payment_token = None
        self._payment_token_expiration_time = None
        self._request_id = None
        self.discriminator = None

        if payment_token is not None:
            self.payment_token = payment_token
        if payment_token_expiration_time is not None:
            self.payment_token_expiration_time = payment_token_expiration_time
        if request_id is not None:
            self.request_id = request_id

    @property
    def payment_token(self):
        """Gets the payment_token of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501

        A `payment_token` that can be provided to Link initialization to enter the payment initiation flow  # noqa: E501

        :return: The payment_token of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_token

    @payment_token.setter
    def payment_token(self, payment_token):
        """Sets the payment_token of this PaymentInitiationPaymentTokenCreateResponse.

        A `payment_token` that can be provided to Link initialization to enter the payment initiation flow  # noqa: E501

        :param payment_token: The payment_token of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :type payment_token: str
        """

        self._payment_token = payment_token

    @property
    def payment_token_expiration_time(self):
        """Gets the payment_token_expiration_time of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501

        The date and time at which the token will expire, in ISO 8601 format. A `payment_token` expires after 15 minutes.  # noqa: E501

        :return: The payment_token_expiration_time of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_token_expiration_time

    @payment_token_expiration_time.setter
    def payment_token_expiration_time(self, payment_token_expiration_time):
        """Sets the payment_token_expiration_time of this PaymentInitiationPaymentTokenCreateResponse.

        The date and time at which the token will expire, in ISO 8601 format. A `payment_token` expires after 15 minutes.  # noqa: E501

        :param payment_token_expiration_time: The payment_token_expiration_time of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :type payment_token_expiration_time: str
        """

        self._payment_token_expiration_time = payment_token_expiration_time

    @property
    def request_id(self):
        """Gets the request_id of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501

        A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.  # noqa: E501

        :return: The request_id of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this PaymentInitiationPaymentTokenCreateResponse.

        A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.  # noqa: E501

        :param request_id: The request_id of this PaymentInitiationPaymentTokenCreateResponse.  # noqa: E501
        :type request_id: str
        """

        self._request_id = request_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentInitiationPaymentTokenCreateResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PaymentInitiationPaymentTokenCreateResponse):
            return True

        return self.to_dict() != other.to_dict()
