# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class RecaptchaRequiredError(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'error_type': 'str',
        'error_code': 'str',
        'display_message': 'str',
        'http_code': 'str',
        'link_user_experience': 'str',
        'common_causes': 'str',
        'troubleshooting_steps': 'str'
    }

    attribute_map = {
        'error_type': 'error_type',
        'error_code': 'error_code',
        'display_message': 'display_message',
        'http_code': 'http_code',
        'link_user_experience': 'link_user_experience',
        'common_causes': 'common_causes',
        'troubleshooting_steps': 'troubleshooting_steps'
    }

    def __init__(self, error_type=None, error_code=None, display_message=None, http_code=None, link_user_experience=None, common_causes=None, troubleshooting_steps=None, local_vars_configuration=None):  # noqa: E501
        """RecaptchaRequiredError - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._error_type = None
        self._error_code = None
        self._display_message = None
        self._http_code = None
        self._link_user_experience = None
        self._common_causes = None
        self._troubleshooting_steps = None
        self.discriminator = None

        if error_type is not None:
            self.error_type = error_type
        if error_code is not None:
            self.error_code = error_code
        if display_message is not None:
            self.display_message = display_message
        if http_code is not None:
            self.http_code = http_code
        if link_user_experience is not None:
            self.link_user_experience = link_user_experience
        if common_causes is not None:
            self.common_causes = common_causes
        if troubleshooting_steps is not None:
            self.troubleshooting_steps = troubleshooting_steps

    @property
    def error_type(self):
        """Gets the error_type of this RecaptchaRequiredError.  # noqa: E501

        RECAPTCHA_ERROR  # noqa: E501

        :return: The error_type of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._error_type

    @error_type.setter
    def error_type(self, error_type):
        """Sets the error_type of this RecaptchaRequiredError.

        RECAPTCHA_ERROR  # noqa: E501

        :param error_type: The error_type of this RecaptchaRequiredError.  # noqa: E501
        :type error_type: str
        """

        self._error_type = error_type

    @property
    def error_code(self):
        """Gets the error_code of this RecaptchaRequiredError.  # noqa: E501

        RECAPTCHA_REQUIRED  # noqa: E501

        :return: The error_code of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this RecaptchaRequiredError.

        RECAPTCHA_REQUIRED  # noqa: E501

        :param error_code: The error_code of this RecaptchaRequiredError.  # noqa: E501
        :type error_code: str
        """

        self._error_code = error_code

    @property
    def display_message(self):
        """Gets the display_message of this RecaptchaRequiredError.  # noqa: E501


        :return: The display_message of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._display_message

    @display_message.setter
    def display_message(self, display_message):
        """Sets the display_message of this RecaptchaRequiredError.


        :param display_message: The display_message of this RecaptchaRequiredError.  # noqa: E501
        :type display_message: str
        """

        self._display_message = display_message

    @property
    def http_code(self):
        """Gets the http_code of this RecaptchaRequiredError.  # noqa: E501

        400  # noqa: E501

        :return: The http_code of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._http_code

    @http_code.setter
    def http_code(self, http_code):
        """Sets the http_code of this RecaptchaRequiredError.

        400  # noqa: E501

        :param http_code: The http_code of this RecaptchaRequiredError.  # noqa: E501
        :type http_code: str
        """

        self._http_code = http_code

    @property
    def link_user_experience(self):
        """Gets the link_user_experience of this RecaptchaRequiredError.  # noqa: E501

        Your user will be prompted to solve a Google reCAPTCHA challenge in the Link Recaptcha pane. If they solve the challenge successfully, the user's request is resubmitted and they are directed to the next Item creation step.  # noqa: E501

        :return: The link_user_experience of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._link_user_experience

    @link_user_experience.setter
    def link_user_experience(self, link_user_experience):
        """Sets the link_user_experience of this RecaptchaRequiredError.

        Your user will be prompted to solve a Google reCAPTCHA challenge in the Link Recaptcha pane. If they solve the challenge successfully, the user's request is resubmitted and they are directed to the next Item creation step.  # noqa: E501

        :param link_user_experience: The link_user_experience of this RecaptchaRequiredError.  # noqa: E501
        :type link_user_experience: str
        """

        self._link_user_experience = link_user_experience

    @property
    def common_causes(self):
        """Gets the common_causes of this RecaptchaRequiredError.  # noqa: E501

        Plaid's fraud system detects abusive traffic and considers a variety of parameters throughout Item creation requests. When a request is considered risky or possibly fraudulent, Link presents a reCAPTCHA for the user to solve.  # noqa: E501

        :return: The common_causes of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._common_causes

    @common_causes.setter
    def common_causes(self, common_causes):
        """Sets the common_causes of this RecaptchaRequiredError.

        Plaid's fraud system detects abusive traffic and considers a variety of parameters throughout Item creation requests. When a request is considered risky or possibly fraudulent, Link presents a reCAPTCHA for the user to solve.  # noqa: E501

        :param common_causes: The common_causes of this RecaptchaRequiredError.  # noqa: E501
        :type common_causes: str
        """

        self._common_causes = common_causes

    @property
    def troubleshooting_steps(self):
        """Gets the troubleshooting_steps of this RecaptchaRequiredError.  # noqa: E501

        Link will automatically guide your user through reCAPTCHA verification. As a general rule, we recommend instrumenting basic fraud monitoring to detect and protect your website from spam and abuse.  If your user cannot verify their session, please submit a Support ticket with the following identifiers: `link_session_id` or `request_id`  # noqa: E501

        :return: The troubleshooting_steps of this RecaptchaRequiredError.  # noqa: E501
        :rtype: str
        """
        return self._troubleshooting_steps

    @troubleshooting_steps.setter
    def troubleshooting_steps(self, troubleshooting_steps):
        """Sets the troubleshooting_steps of this RecaptchaRequiredError.

        Link will automatically guide your user through reCAPTCHA verification. As a general rule, we recommend instrumenting basic fraud monitoring to detect and protect your website from spam and abuse.  If your user cannot verify their session, please submit a Support ticket with the following identifiers: `link_session_id` or `request_id`  # noqa: E501

        :param troubleshooting_steps: The troubleshooting_steps of this RecaptchaRequiredError.  # noqa: E501
        :type troubleshooting_steps: str
        """

        self._troubleshooting_steps = troubleshooting_steps

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecaptchaRequiredError):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RecaptchaRequiredError):
            return True

        return self.to_dict() != other.to_dict()
