# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['planetmint_driver']

package_data = \
{'': ['*']}

install_requires = \
['planetmint-ipld>=0.0.3,<0.0.4',
 'planetmint-transactions>=0.6.0,<0.7.0',
 'pysha3>=1.0.2,<2.0.0',
 'python-rapidjson-schema>=0.1.1,<0.2.0',
 'python-rapidjson>=1.9,<2.0',
 'requests>=2.28.2,<3.0.0',
 'sphinx-press-theme==0.8.0',
 'wheel>=0.38.1,<0.39.0']

setup_kwargs = {
    'name': 'planetmint-driver-python',
    'version': '0.17.0',
    'description': 'Python driver for Planetmint',
    'long_description': "\n.. Copyright Planetmint GmbH and Planetmint contributors\n   SPDX-License-Identifier: (Apache-2.0 AND CC-BY-4.0)\n   Code is Apache-2.0 and docs are CC-BY-4.0\n\n.. image:: https://badges.gitter.im/planetmint/planetmint-driver.svg\n   :alt: Join the chat at https://gitter.im/planetmint/planetmint-driver\n   :target: https://gitter.im/planetmint/planetmint-driver?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge\n\n\n.. image:: https://badge.fury.io/py/planetmint-driver.svg\n    :target: https://badge.fury.io/py/planetmint-driver\n\n.. image:: https://app.travis-ci.com/planetmint/planetmint-driver.svg?branch=main\n    :target: https://app.travis-ci.com/planetmint/planetmint-driver\n\n.. image:: https://img.shields.io/codecov/c/github/planetmint/planetmint-driver/master.svg\n    :target: https://codecov.io/github/planetmint/planetmint-driver?branch=master\n\n\nPlanetmint Python Driver\n==========================\n\n* Free software: Apache Software License 2.0\n* Check our `Documentation`_\n\n.. contents:: Table of Contents\n\n\nFeatures\n--------\n\n* Support for preparing, fulfilling, and sending transactions to a Planetmint\n  node.\n* Retrieval of transactions by id.\n\nInstall\n----------\n\nThe instructions below were tested on Ubuntu 16.04 LTS. They should also work on other Linux distributions and on macOS. The driver might work on Windows as well, but we do not guarantee it. We recommend to set up (e.g. via Docker on Windows) an Ubuntu VM there.\n\nWe recommend you use a virtual environment to install and update to the latest stable version using `pip` (or `pip3`):\n\n.. code-block:: text\n\n    pip install -U planetmint-driver\n\nThat will install the latest *stable* Planetmint Python Driver. If you want to install an Alpha, Beta or RC version of the Python Driver, use something like:\n\n.. code-block:: text\n\n    pip install -U planetmint_driver==0.11.1\n\nThe above command will install version 0.11.1. You can find a list of all versions in `the release history page on PyPI <https://pypi.org/project/planetmint-driver/#history>`_.\n\nMore information on how to install the driver can be found in the `Quickstart`_\n\nPlanetmint Documentation\n------------------------------------\n* `Planetmint Server Quickstart`_\n* `The Hitchhiker's Guide to Planetmint`_\n* `HTTP API Reference`_\n* `All Planetmint Documentation`_\n\nUsage\n----------\nExample: Create a divisible asset for Alice who issues 10 token to Bob so that he can use her Game Boy.\nAfterwards Bob spends 3 of these tokens.\n\nIf you want to send a transaction you need to `Determine the Planetmint Root URL`_.\n\n.. code-block:: python\n\n    # import Planetmint and create an object\n    from planetmint_driver import Planetmint\n    bdb_root_url = 'https://example.com:9984'\n    bdb = Planetmint(bdb_root_url)\n\n    # generate a keypair\n    from planetmint_driver.crypto import generate_keypair\n    alice, bob = generate_keypair(), generate_keypair()\n\n    # create a digital asset for Alice\n    game_boy_token = {\n        'data': {\n            'token_for': {\n                'game_boy': {\n                    'serial_number': 'LR35902'\n                }\n            },\n            'description': 'Time share token. Each token equals one hour of usage.',\n        },\n    }\n\n    # prepare the transaction with the digital asset and issue 10 tokens for Bob\n    prepared_token_tx = bdb.transactions.prepare(\n        operation='CREATE',\n        signers=alice.public_key,\n        recipients=[([bob.public_key], 10)],\n        asset=game_boy_token)\n\n    # fulfill and send the transaction\n    fulfilled_token_tx = bdb.transactions.fulfill(\n        prepared_token_tx,\n        private_keys=alice.private_key)\n    bdb.transactions.send_commit(fulfilled_token_tx)\n\n    # Use the tokens\n    # create the output and inout for the transaction\n    transfer_asset = {'id': fulfilled_token_tx['id']}\n    output_index = 0\n    output = fulfilled_token_tx['outputs'][output_index]\n    transfer_input = {'fulfillment': output['condition']['details'],\n                      'fulfills': {'output_index': output_index,\n                                   'transaction_id': transfer_asset['id']},\n                      'owners_before': output['public_keys']}\n\n    # prepare the transaction and use 3 tokens\n    prepared_transfer_tx = bdb.transactions.prepare(\n        operation='TRANSFER',\n        asset=transfer_asset,\n        inputs=transfer_input,\n        recipients=[([alice.public_key], 3), ([bob.public_key], 7)])\n\n    # fulfill and send the transaction\n    fulfilled_transfer_tx = bdb.transactions.fulfill(\n        prepared_transfer_tx,\n        private_keys=bob.private_key)\n    sent_transfer_tx = bdb.transactions.send_commit(fulfilled_transfer_tx)\n\nCompatibility Matrix\n--------------------\n\n+-----------------------+---------------------------+\n| **Planetmint Server** | **Planetmint Driver**     |\n+=======================+===========================+\n| ``>= 2.0.0b7``        | ``0.6.2``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b7``        | ``0.6.1``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b7``        | ``0.6.0``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b5``        | ``0.5.3``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b5``        | ``0.5.2``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b5``        | ``0.5.1``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0b1``        | ``0.5.0``                 |\n+-----------------------+---------------------------+\n| ``>= 2.0.0a3``        | ``0.5.0a4``               |\n+-----------------------+---------------------------+\n| ``>= 2.0.0a2``        | ``0.5.0a2``               |\n+-----------------------+---------------------------+\n| ``>= 2.0.0a1``        | ``0.5.0a1``               |\n+-----------------------+---------------------------+\n| ``>= 1.0.0``          | ``0.4.x``                 |\n+-----------------------+---------------------------+\n| ``== 1.0.0rc1``       | ``0.3.x``                 |\n+-----------------------+---------------------------+\n| ``>= 0.9.1``          | ``0.2.x``                 |\n+-----------------------+---------------------------+\n| ``>= 0.8.2``          | ``>= 0.1.3``              |\n+-----------------------+---------------------------+\n\n`Although we do our best to keep the master branches in sync, there may be\noccasional delays.`\n\nLicense\n--------\n* `licenses`_ - open source & open content\n\nCredits\n-------\n\nThis package was initially created using Cookiecutter_ and the `audreyr/cookiecutter-pypackage`_ project template. Many Planetmint developers have contributed since then.\n\n.. _Documentation: https://docs.planetmint.com/projects/py-driver/\n.. _pypi history: https://pypi.org/project/planetmint-driver/#history\n.. _Quickstart: https://docs.planetmint.com/projects/py-driver/en/latest/quickstart.html\n.. _Planetmint Server Quickstart: https://docs.planetmint.com/projects/server/en/latest/quickstart.html\n.. _The Hitchhiker's Guide to Planetmint: https://www.planetmint.com/developers/guide/\n.. _HTTP API Reference: https://docs.planetmint.com/projects/server/en/latest/http-client-server-api.html\n.. _All Planetmint Documentation: https://docs.planetmint.com/\n.. _Determine the Planetmint Root URL: https://docs.planetmint.com/projects/py-driver/en/latest/connect.html\n.. _licenses: https://github.com/planetmint/planetmint-driver/blob/master/LICENSES.md\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _`audreyr/cookiecutter-pypackage`: https://github.com/audreyr/cookiecutter-pypackage\n",
    'author': 'Your Name',
    'author_email': 'you@example.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
