/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.io.wkt;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.aggregate.MultiCurve;
import org.opengis.geometry.aggregate.MultiPoint;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.complex.CompositePoint;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.OrientableSurface;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;

public class GeometryToWKTString {
    private boolean lineBreak = false;

    public GeometryToWKTString(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public String getString(Geometry geom) {
        String rString = "";
        if (this.lineBreak) {
            rString = rString + "\n";
        }
        rString = geom instanceof Curve ? rString + this.curveToString((Curve)geom) : (geom instanceof Point ? rString + this.pointToString((Point)geom) : (geom instanceof Ring ? rString + this.ringToString((Ring)geom) : (geom instanceof SurfaceBoundary ? rString + this.surfaceBoundaryToString((SurfaceBoundary)geom) : (geom instanceof Surface ? rString + this.surfaceToString((Surface)geom) : (geom instanceof MultiPrimitive ? rString + this.multiPrimitiveToString((MultiPrimitive)geom) : (geom instanceof CompositePoint ? rString + this.compositePointToString((CompositePoint)geom) : (geom instanceof CompositeCurve ? rString + this.compositeCurveToString((CompositeCurve)geom) : "")))))));
        return rString;
    }

    private String pointToString(Point c) {
        return "Point(" + this.pointCoordToString(c) + ")";
    }

    private String curveToString(Curve c) {
        return "Curve(" + this.curveCoordToString(c) + ")";
    }

    private String ringToString(Ring r) {
        return "Ring(" + this.ringCoordToString(r) + ")";
    }

    private String surfaceBoundaryToString(SurfaceBoundary sb) {
        return "SurfaceBoundary(" + this.surfaceBoundaryCoordToString(sb) + ")";
    }

    private String surfaceToString(Surface s) {
        return "Surface(" + this.surfaceBoundaryCoordToString(s.getBoundary()) + ")";
    }

    private String multiPrimitiveToString(MultiPrimitive mp) {
        if (mp instanceof MultiPoint) {
            return this.multiPointToString((MultiPoint)mp);
        }
        if (mp instanceof MultiCurve) {
            return this.multiCurveToString((MultiCurve)mp);
        }
        if (mp instanceof MultiSurface) {
            return this.multiSurfaceToString((MultiSurface)mp);
        }
        return "MultiPrimitive(" + this.multiPrimitiveCoordToString(mp) + ")";
    }

    private String multiPointToString(MultiPoint mp) {
        return "MultiPoint(" + this.multiPointCoordToString(mp) + ")";
    }

    private String multiCurveToString(MultiCurve mc) {
        return "MultiCurve(" + this.multiCurveCoordToString(mc) + ")";
    }

    private String multiSurfaceToString(MultiSurface ms) {
        return "MultiSurface(" + this.multiSurfaceCoordToString(ms) + ")";
    }

    private String compositePointToString(CompositePoint cp) {
        Point p = (Point)cp.getElements().iterator().next();
        return "CompositePoint(" + this.pointCoordToString(p) + ")";
    }

    private String compositeCurveToString(CompositeCurve cc) {
        return "CompositeCurve(" + this.compositeCurveCoordToString(cc) + ")";
    }

    private String directPositionToString(DirectPosition dp) {
        double[] coord = dp.getCoordinate();
        String str = Double.toString(coord[0]);
        for (int i = 1; i < coord.length; ++i) {
            str = str + " " + Double.toString(coord[i]);
        }
        return str;
    }

    private String lineStringCoordToStringWithoutFirstCoord(CurveSegment ls) {
        return this.pointArrayCoordToStringWithoutFirstCoord(ls.getSamplePoints());
    }

    private String pointArrayCoordToStringWithoutFirstCoord(PointArray pa) {
        String rString = "";
        if (pa.size() == 0) {
            return "";
        }
        for (int i = 1; i < pa.size(); ++i) {
            if (i > 1) {
                rString = rString + ", ";
            }
            rString = rString + this.directPositionToString(((Position)pa.get(i)).getDirectPosition());
        }
        return rString;
    }

    private String curveCoordToString(Curve c) {
        String rString = "";
        List<? extends CurveSegment> segments = c.getSegments();
        rString = rString + this.directPositionToString(c.getStartPoint());
        for (int i = 0; i < segments.size(); ++i) {
            rString = rString + ", ";
            rString = rString + this.lineStringCoordToStringWithoutFirstCoord(segments.get(i));
        }
        return rString;
    }

    private String curveCoordToStringWithoutFirstCoord(Curve c) {
        String rString = "";
        for (CurveSegment curveSegment : c.getSegments()) {
            rString = rString + ", ";
            rString = rString + this.lineStringCoordToStringWithoutFirstCoord(curveSegment);
        }
        return rString;
    }

    private String ringCoordToString(Ring r) {
        Collection orientableCurves = r.getGenerators();
        String rString = this.directPositionToString(((Curve)orientableCurves.iterator().next()).getStartPoint());
        for (Primitive p : orientableCurves) {
            rString = rString + this.curveCoordToStringWithoutFirstCoord((Curve)p);
        }
        return rString;
    }

    private String compositeCurveCoordToString(CompositeCurve cc) {
        Collection orientableCurves = cc.getGenerators();
        String rString = this.directPositionToString(((Curve)orientableCurves.iterator().next()).getStartPoint());
        for (Primitive p : orientableCurves) {
            rString = rString + this.curveCoordToStringWithoutFirstCoord((Curve)p);
        }
        return rString;
    }

    private String surfaceBoundaryCoordToString(SurfaceBoundary sb) {
        String rString = "(";
        rString = rString + this.ringCoordToString(sb.getExterior());
        rString = rString + ")";
        List<Ring> interior = sb.getInteriors();
        if (interior.size() > 0) {
            for (int i = 0; i < interior.size(); ++i) {
                rString = rString + ", (";
                rString = rString + this.ringCoordToString(interior.get(i));
                rString = rString + ")";
            }
        }
        return rString;
    }

    private String multiPointCoordToString(MultiPoint mp) {
        Iterator<Point> mpIter = mp.getElements().iterator();
        String rString = this.pointCoordToString(mpIter.next());
        while (mpIter.hasNext()) {
            rString = rString + ", (";
            rString = rString + this.pointCoordToString(mpIter.next());
            rString = rString + ")";
        }
        return rString;
    }

    private String multiCurveCoordToString(MultiCurve mc) {
        Iterator<OrientableCurve> mpIter = mc.getElements().iterator();
        String rString = "(" + this.curveCoordToString((Curve)mpIter.next()) + ")";
        while (mpIter.hasNext()) {
            if (this.lineBreak) {
                rString = rString + "\n\t";
            }
            rString = rString + ", (";
            rString = rString + this.curveCoordToString((Curve)mpIter.next());
            rString = rString + ")";
        }
        return rString;
    }

    private String multiSurfaceCoordToString(MultiSurface mc) {
        Iterator<OrientableSurface> mpIter = mc.getElements().iterator();
        String rString = "(" + this.surfaceBoundaryCoordToString(((Surface)mpIter.next()).getBoundary()) + ")";
        while (mpIter.hasNext()) {
            if (this.lineBreak) {
                rString = rString + "\n\t";
            }
            rString = rString + ", ";
            rString = rString + "(" + this.surfaceBoundaryCoordToString(((Surface)mpIter.next()).getBoundary()) + ")";
        }
        return rString;
    }

    private String pointCoordToString(Point p) {
        return this.directPositionToString(p.getDirectPosition());
    }

    private String multiPrimitiveCoordToString(MultiPrimitive mp) {
        Iterator<? extends Primitive> primitives = mp.getElements().iterator();
        String rString = "";
        while (primitives.hasNext()) {
            Primitive p = primitives.next();
            if (p instanceof Point) {
                rString = rString + "\n\t" + this.pointToString((Point)p);
                continue;
            }
            if (p instanceof Curve) {
                rString = rString + "\n\t" + this.curveToString((Curve)p);
                continue;
            }
            if (p instanceof Surface) {
                rString = rString + "\n\t" + this.surfaceToString((Surface)p);
                continue;
            }
            rString = rString + "\n[INVALID TYPE in MULTIPRIMITIVE]";
        }
        return rString;
    }
}

