/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import org.ojalgo.matrix.AbstractMatrix;
import org.ojalgo.matrix.MatrixFactory;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.task.DeterminantTask;
import org.ojalgo.matrix.task.InverterTask;
import org.ojalgo.matrix.task.SolverTask;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public final class ComplexMatrix
extends AbstractMatrix<ComplexNumber, ComplexMatrix> {
    public static final MatrixFactory<ComplexNumber, ComplexMatrix> FACTORY = new MatrixFactory<ComplexNumber, ComplexMatrix>(ComplexMatrix.class, GenericDenseStore.COMPLEX);

    ComplexMatrix(MatrixStore<ComplexNumber> aStore) {
        super(aStore);
    }

    public PrimitiveMatrix getArgument() {
        return PrimitiveMatrix.FACTORY.instantiate(MatrixUtils.getComplexArgument(this.getStore()));
    }

    public PrimitiveMatrix getImaginary() {
        return PrimitiveMatrix.FACTORY.instantiate(MatrixUtils.getComplexImaginary(this.getStore()));
    }

    public PrimitiveMatrix getModulus() {
        return PrimitiveMatrix.FACTORY.instantiate(MatrixUtils.getComplexModulus(this.getStore()));
    }

    public PrimitiveMatrix getReal() {
        return PrimitiveMatrix.FACTORY.instantiate(MatrixUtils.getComplexReal(this.getStore()));
    }

    @Override
    ElementsSupplier<ComplexNumber> cast(Access1D<?> matrix) {
        if (matrix instanceof ComplexMatrix) {
            return ((ComplexMatrix)matrix).getStore();
        }
        if (matrix instanceof ElementsSupplier && matrix.count() > 0L && matrix.get(0L) instanceof ComplexNumber) {
            return (ElementsSupplier)((Object)matrix);
        }
        if (matrix instanceof Access2D) {
            Access2D tmpAccess2D = (Access2D)matrix;
            return this.getStore().physical().builder().makeWrapper(tmpAccess2D);
        }
        return (ElementsSupplier)this.getStore().physical().columns(matrix);
    }

    @Override
    Eigenvalue<ComplexNumber> getDecompositionEigenvalue(Structure2D typical) {
        return Eigenvalue.COMPLEX.make(typical, this.isHermitian());
    }

    @Override
    LU<ComplexNumber> getDecompositionLU(Structure2D typical) {
        return (LU)LU.COMPLEX.make(typical);
    }

    @Override
    QR<ComplexNumber> getDecompositionQR(Structure2D typical) {
        return QR.COMPLEX.make(typical);
    }

    @Override
    SingularValue<ComplexNumber> getDecompositionSingularValue(Structure2D typical) {
        return SingularValue.COMPLEX.make(typical);
    }

    @Override
    MatrixFactory<ComplexNumber, ComplexMatrix> getFactory() {
        return FACTORY;
    }

    @Override
    DeterminantTask<ComplexNumber> getTaskDeterminant(MatrixStore<ComplexNumber> template) {
        return DeterminantTask.COMPLEX.make(template, this.isHermitian(), false);
    }

    @Override
    InverterTask<ComplexNumber> getTaskInverter(MatrixStore<ComplexNumber> base) {
        return InverterTask.COMPLEX.make(base, this.isHermitian(), false);
    }

    @Override
    SolverTask<ComplexNumber> getTaskSolver(MatrixStore<ComplexNumber> templateBody, Access2D<?> templateRHS) {
        return SolverTask.COMPLEX.make(templateBody, templateRHS, this.isHermitian(), false);
    }
}

