/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.array.SparseArray;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Mutate1D;

public final class RowsSupplier<N extends Number>
implements Access2D<N>,
ElementsSupplier<N> {
    private final int myColumnsCount;
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final List<SparseArray<N>> myRows = new ArrayList<SparseArray<N>>();

    RowsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfColumns) {
        this.myColumnsCount = numberOfColumns;
        this.myFactory = factory;
    }

    public SparseArray<N> addRow() {
        return this.addRow((SparseArray<N>)SparseArray.factory(this.myFactory.array(), this.myColumnsCount).make());
    }

    public void addRows(int numberToAdd) {
        SparseArray.SparseFactory<N> factory = SparseArray.factory(this.myFactory.array(), this.myColumnsCount);
        for (int i = 0; i < numberToAdd; ++i) {
            this.myRows.add((SparseArray<N>)factory.make());
        }
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRows.size();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myRows.get((int)row).doubleValue(col);
    }

    @Override
    public N get(long row, long col) {
        return this.myRows.get((int)row).get(col);
    }

    public SparseArray<N> getRow(int index) {
        return this.myRows.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    public SparseArray<N> removeRow(int index) {
        return this.myRows.remove(index);
    }

    public RowsSupplier<N> selectRows(int[] indices) {
        RowsSupplier<N> retVal = new RowsSupplier<N>(this.myFactory, this.myColumnsCount);
        for (int i = 0; i < indices.length; ++i) {
            retVal.addRow(this.getRow(indices[i]));
        }
        return retVal;
    }

    @Override
    public void supplyTo(final ElementsConsumer<N> receiver) {
        receiver.reset();
        int limit = this.myRows.size();
        for (int i = 0; i < limit; ++i) {
            final long row = i;
            this.myRows.get(i).supplyNonZerosTo(new Mutate1D(){

                @Override
                public void add(long index, double addend) {
                    receiver.add(row, index, addend);
                }

                @Override
                public void add(long index, Number addend) {
                    receiver.add(row, index, addend);
                }

                @Override
                public long count() {
                    return receiver.countColumns();
                }

                @Override
                public void set(long index, double value) {
                    receiver.set(row, index, value);
                }

                @Override
                public void set(long index, Number value) {
                    receiver.set(row, index, value);
                }
            });
        }
    }

    SparseArray<N> addRow(SparseArray<N> rowToAdd) {
        if (this.myRows.add(rowToAdd)) {
            return rowToAdd;
        }
        return null;
    }
}

