/*
 * Decompiled with CFR 0.152.
 */
package org.planit.algorithms.nodemodel;

import java.util.ArrayList;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.planit.algorithms.nodemodel.NodeModel;
import org.planit.algorithms.nodemodel.TampereNodeModelInput;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.function.NullaryDoubleSupplier;
import org.planit.utils.math.Precision;
import org.planit.utils.misc.Pair;

public class TampereNodeModel
extends NodeModel {
    protected final TampereNodeModelInput inputs;
    int numberOfInLinksProcessed;
    protected Array1D<Double> remainingReceivingFlows;
    protected Array2D<Double> scaledRemainingTurnSendingFlows;
    protected boolean[] processedInLinkSegments;
    protected Array1D<Double> incomingLinkSegmentFlowAcceptanceFactors;

    protected void initialiseRun() throws PlanItException {
        PlanItException.throwIf(this.inputs.outgoingLinkSegmentReceivingFlows == null, "remaining receiving flows not initialised");
        this.numberOfInLinksProcessed = 0;
        this.scaledRemainingTurnSendingFlows = Array2D.PRIMITIVE64.copy(this.inputs.turnSendingFlows);
        this.scaledRemainingTurnSendingFlows.modifyMatchingInColumns(this.inputs.capacityScalingFactors, PrimitiveFunction.MULTIPLY);
        this.remainingReceivingFlows = this.inputs.outgoingLinkSegmentReceivingFlows.copy();
        this.processedInLinkSegments = new boolean[this.inputs.fixedInput.getNumberOfIncomingLinkSegments()];
        this.incomingLinkSegmentFlowAcceptanceFactors = Array1D.PRIMITIVE64.makeFilled((long)this.inputs.fixedInput.getNumberOfIncomingLinkSegments(), (NullaryFunction)NullaryDoubleSupplier.ONE);
    }

    protected Pair<Double, Integer> findMostRestrictingOutLinkSegmentIndex() {
        double foundRestrictionFactor = Double.POSITIVE_INFINITY;
        int foundOutLinkSegmentIndex = -1;
        int numberOfOutLinkSegments = this.inputs.fixedInput.getNumberOfOutgoingLinkSegments();
        for (int outLinkSegmentIndex = 0; outLinkSegmentIndex < numberOfOutLinkSegments; ++outLinkSegmentIndex) {
            double currentOutgoingRestrictionFactor;
            double remainingReceivingFlow = (Double)this.remainingReceivingFlows.get(outLinkSegmentIndex);
            double sumScaledTurnSendingFlows = (Double)this.scaledRemainingTurnSendingFlows.aggregateColumn(outLinkSegmentIndex, Aggregator.SUM);
            if (!Precision.isGreaterEqual(sumScaledTurnSendingFlows, 1.0E-6) || !((currentOutgoingRestrictionFactor = remainingReceivingFlow / sumScaledTurnSendingFlows) < foundRestrictionFactor)) continue;
            foundRestrictionFactor = currentOutgoingRestrictionFactor;
            foundOutLinkSegmentIndex = outLinkSegmentIndex;
        }
        return new Pair<Double, Integer>(foundRestrictionFactor, foundOutLinkSegmentIndex);
    }

    protected void updateSets(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        boolean demandConstrainedInLinkFound = this.updateDemandConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        if (!demandConstrainedInLinkFound) {
            this.updateCapacityConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        }
    }

    protected boolean updateDemandConstrainedInLinkSegments(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        int mostRestrictedOutLinkIndex = mostRestrictingOutLinkSegmentData.getSecond();
        double outLinkSegmentScalingFactorBeta = mostRestrictingOutLinkSegmentData.getFirst();
        ArrayList<Long> demandConstrainedInLinksY = new ArrayList<Long>();
        this.scaledRemainingTurnSendingFlows.loopColumn(mostRestrictedOutLinkIndex, (inLinkSegmentIndex, outLinkSegmentIndex) -> {
            double requiredScalingFactor;
            double turnSendingFlow = this.scaledRemainingTurnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex);
            if (Precision.isGreater(turnSendingFlow, 1.0E-6) && !this.isInLinkSegmentProcessed((int)inLinkSegmentIndex) && Precision.isGreaterEqual(requiredScalingFactor = this.inputs.capacityScalingFactors.get(inLinkSegmentIndex) * outLinkSegmentScalingFactorBeta, 1.0)) {
                demandConstrainedInLinksY.add(inLinkSegmentIndex);
            }
        });
        demandConstrainedInLinksY.forEach(inLinkSegmentIndex -> {
            this.setInLinkSegmentProcessed(inLinkSegmentIndex.intValue());
            ++this.numberOfInLinksProcessed;
            this.updateRemainingReceivingAndSendingFlows((long)inLinkSegmentIndex);
        });
        return !demandConstrainedInLinksY.isEmpty();
    }

    protected void updateCapacityConstrainedInLinkSegments(Pair<Double, Integer> mostRestrictingOutLinkSegmentData) {
        int mostRestrictedOutLinkIndex = mostRestrictingOutLinkSegmentData.getSecond();
        double outLinkSegmentScalingFactorBeta = mostRestrictingOutLinkSegmentData.getFirst();
        this.scaledRemainingTurnSendingFlows.loopColumn(mostRestrictedOutLinkIndex, (inLinkSegmentIndex, outLinkSegmentIndex) -> {
            double turnSendingFlow = this.scaledRemainingTurnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex);
            if (Precision.isGreater(turnSendingFlow, 1.0E-6) && !this.isInLinkSegmentProcessed((int)inLinkSegmentIndex)) {
                double flowAcceptanceFactor = this.inputs.capacityScalingFactors.get(inLinkSegmentIndex) * outLinkSegmentScalingFactorBeta;
                this.updateRemainingReceivingAndSendingFlows(inLinkSegmentIndex, flowAcceptanceFactor);
                this.incomingLinkSegmentFlowAcceptanceFactors.set(inLinkSegmentIndex, flowAcceptanceFactor);
                this.setInLinkSegmentProcessed((int)inLinkSegmentIndex);
                ++this.numberOfInLinksProcessed;
            }
        });
    }

    protected void updateRemainingReceivingAndSendingFlows(long inLinkSegmentIndex) {
        this.updateRemainingReceivingAndSendingFlows(inLinkSegmentIndex, 1.0);
    }

    protected void updateRemainingReceivingAndSendingFlows(long inLinkSegmentIndex, double flowAcceptanceFactor) {
        this.inputs.turnSendingFlows.loopRow(inLinkSegmentIndex, (i, outLinkSegmentIndex2) -> {
            double acceptedTurnSendingflowTo = this.inputs.turnSendingFlows.get(inLinkSegmentIndex, outLinkSegmentIndex2);
            this.remainingReceivingFlows.modifyOne(outLinkSegmentIndex2, PrimitiveFunction.SUBTRACT.by(acceptedTurnSendingflowTo * flowAcceptanceFactor));
        });
        this.scaledRemainingTurnSendingFlows.fillRow(inLinkSegmentIndex, 0.0);
    }

    protected boolean isInLinkSegmentProcessed(int inLinkSegmentIndex) {
        return this.processedInLinkSegments[inLinkSegmentIndex];
    }

    protected void setInLinkSegmentProcessed(int inLinkSegmentIndex) {
        this.processedInLinkSegments[inLinkSegmentIndex] = true;
    }

    public TampereNodeModel(TampereNodeModelInput tampereNodeModelInput) throws PlanItException {
        PlanItException.throwIf(tampereNodeModelInput == null, "Tampere node model input is null");
        this.inputs = tampereNodeModelInput;
    }

    public Array1D<Double> run() throws PlanItException {
        this.initialiseRun();
        while (this.numberOfInLinksProcessed < this.inputs.fixedInput.getNumberOfIncomingLinkSegments()) {
            Pair<Double, Integer> mostRestrictingOutLinkSegmentData = this.findMostRestrictingOutLinkSegmentIndex();
            boolean demandConstrainedInLinkFound = this.updateDemandConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
            if (demandConstrainedInLinkFound) continue;
            this.updateCapacityConstrainedInLinkSegments(mostRestrictingOutLinkSegmentData);
        }
        return this.incomingLinkSegmentFlowAcceptanceFactors;
    }
}

