/*
 * Decompiled with CFR 0.152.
 */
package org.planit.configurator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.utils.exceptions.PlanItException;

public abstract class Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(Configurator.class.getCanonicalName());
    protected final Map<String, Object[]> delayedMethodCalls = new HashMap<String, Object[]>();

    protected Class<?>[] collectParameterTypes(Object ... parameters) throws PlanItException {
        PlanItException.throwIf(parameters == null, "The parameters to collect signature for are null");
        Class[] parameterTypes = new Class[parameters.length];
        for (int index = 0; index < parameters.length; ++index) {
            parameterTypes[index] = parameters.getClass();
        }
        return parameterTypes;
    }

    protected void callVoidMethod(T instance, String methodName, Object ... parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, PlanItException, NoSuchMethodException, SecurityException {
        PlanItException.throwIf(instance == null, "The instance to configure by calling " + methodName + " is not available");
        Class<?>[] parameterTypes = this.collectParameterTypes(parameters);
        Method method = instance.getClass().getDeclaredMethod(methodName, parameterTypes);
        method.invoke(instance, parameters);
    }

    protected void registerDelayedSetter(String methodName, Object ... parameters) {
        this.delayedMethodCalls.put(methodName, parameters);
    }

    protected Configurator() {
    }

    public void configure(T toConfigureInstance) throws PlanItException {
        for (Map.Entry<String, Object[]> methodCall : this.delayedMethodCalls.entrySet()) {
            try {
                this.callVoidMethod(toConfigureInstance, methodCall.getKey(), methodCall.getValue());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.severe(e.getMessage());
                throw new PlanItException("could not call configurator delayed method call to " + methodCall.getKey() + " on class " + toConfigureInstance.getClass().getCanonicalName());
            }
        }
    }
}

