/*
 * Decompiled with CFR 0.152.
 */
package org.planit.graph;

import java.util.HashMap;
import java.util.Map;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.graph.Edge;
import org.planit.utils.graph.EdgeSegment;
import org.planit.utils.graph.Vertex;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;

public class EdgeImpl
implements Edge {
    private static final long serialVersionUID = -3061186642253968991L;
    protected final long id;
    protected Map<String, Object> inputProperties = null;
    protected String name = null;
    protected Vertex vertexA = null;
    protected Vertex vertexB = null;
    protected double length;
    protected EdgeSegment edgeSegmentAB = null;
    protected EdgeSegment edgeSegmentBA = null;

    protected static long generateEdgeId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, Edge.class);
    }

    protected EdgeImpl(IdGroupingToken groupId, Vertex vertexA, Vertex vertexB, double length) throws PlanItException {
        this.id = EdgeImpl.generateEdgeId(groupId);
        this.vertexA = vertexA;
        this.vertexB = vertexB;
        this.length = length;
    }

    protected EdgeSegment registerEdgeSegment(EdgeSegment edgeSegment, boolean directionAB) throws PlanItException {
        EdgeSegment currentEdgeSegment;
        PlanItException.throwIf(edgeSegment.getParentEdge().getId() != this.getId(), "Inconsistency between link segment parent link and link it is being registered on");
        EdgeSegment edgeSegment2 = currentEdgeSegment = directionAB ? this.edgeSegmentAB : this.edgeSegmentBA;
        if (directionAB) {
            this.edgeSegmentAB = edgeSegment;
        } else {
            this.edgeSegmentBA = edgeSegment;
        }
        return currentEdgeSegment;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    @Override
    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public double getLength() {
        return this.length;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Vertex getVertexA() {
        return this.vertexA;
    }

    @Override
    public Vertex getVertexB() {
        return this.vertexB;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public EdgeSegment getEdgeSegmentAB() {
        return this.edgeSegmentAB;
    }

    @Override
    public EdgeSegment getEdgeSegmentBA() {
        return this.edgeSegmentBA;
    }

    @Override
    public int compareTo(Edge o) {
        return Long.valueOf(this.id).compareTo(o.getId());
    }
}

