/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.project;

import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.planit.demands.Demands;
import org.planit.io.input.PlanItInputBuilder;
import org.planit.io.output.formatter.PlanItOutputFormatter;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.project.CustomPlanItProject;
import org.planit.trafficassignment.builder.TrafficAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.LoggingUtils;

public class PlanItSimpleProject
extends CustomPlanItProject {
    private static final Logger LOGGER = Logger.getLogger(PlanItSimpleProject.class.getCanonicalName());
    private PlanItOutputFormatter defaultOutputFormatter = null;
    private MacroscopicNetwork network = null;
    private Zoning zoning = null;
    private Demands demands = null;

    private void initialiseSimpleProject() {
        try {
            this.defaultOutputFormatter = (PlanItOutputFormatter)this.createAndRegisterOutputFormatter("org.planit.io.output.formatter.PlanItOutputFormatter");
            this.network = (MacroscopicNetwork)this.createAndRegisterPhysicalNetwork(MacroscopicNetwork.class.getCanonicalName());
            this.zoning = this.createAndRegisterZoning(this.network);
            this.demands = this.createAndRegisterDemands(this.zoning, this.network);
        }
        catch (PlanItException e) {
            LOGGER.log(Level.SEVERE, "could not instantiate default settings for project", e);
        }
    }

    public PlanItSimpleProject() throws PlanItException {
        super(new PlanItInputBuilder(System.getProperty("user.dir")));
        this.initialiseSimpleProject();
    }

    public PlanItSimpleProject(String projectPath) throws PlanItException {
        super(new PlanItInputBuilder(projectPath));
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + String.format("searching for input files in: %s", Paths.get(projectPath, new String[0]).toAbsolutePath().toString()));
        this.initialiseSimpleProject();
    }

    public PlanItSimpleProject(PlanItInputBuilder planItInputBuilder) {
        super(planItInputBuilder);
        this.initialiseSimpleProject();
    }

    public TrafficAssignmentBuilder createAndRegisterTrafficAssignment(String trafficAssignmentType) throws PlanItException {
        PlanItException.throwIf(this.trafficAssignments.hasRegisteredAssignments(), "this type of PLANit project only allows a single assignment per project");
        return super.createAndRegisterTrafficAssignment(trafficAssignmentType, this.demands, this.zoning, this.network);
    }

    @Override
    public TrafficAssignmentBuilder createAndRegisterTrafficAssignment(String trafficAssignmentType, Demands theDemands, Zoning theZoning, PhysicalNetwork thePhysicalNetwork) throws PlanItException {
        throw new PlanItException("a simple project only allows to create and register a traffic assignment by type only, other inputs are automatically collected");
    }

    @Override
    public void executeAllTrafficAssignments() throws PlanItException {
        if (this.trafficAssignments.hasRegisteredAssignments()) {
            super.executeAllTrafficAssignments();
        } else {
            LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + "no traffic assignment has been registered yet, ignoring execution");
        }
    }

    public PlanItOutputFormatter getDefaultOutputFormatter() {
        return this.defaultOutputFormatter;
    }

    public MacroscopicNetwork getNetwork() {
        return this.network;
    }

    public Zoning getZoning() {
        return this.zoning;
    }

    public Demands getDemands() {
        return this.demands;
    }

    public List<Object> getTimePeriodExternalIds() {
        return this.inputBuilderListener.getTimePeriodExternalIds();
    }
}

