/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.demands;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.time.TimePeriod;
import org.planit.userclass.TravelerType;
import org.planit.userclass.UserClass;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Mode;
import org.planit.xml.generated.Durationunit;
import org.planit.xml.generated.XMLElementDemandConfiguration;
import org.planit.xml.generated.XMLElementTimePeriods;
import org.planit.xml.generated.XMLElementTravellerTypes;
import org.planit.xml.generated.XMLElementUserClasses;

public class ProcessConfiguration {
    private static final Logger LOGGER = Logger.getLogger(ProcessConfiguration.class.getCanonicalName());

    private static void generateAndStoreTravelerTypes(Demands demands, XMLElementDemandConfiguration demandconfiguration, InputBuilderListener inputBuilderListener) throws PlanItException {
        XMLElementTravellerTypes travellertypes;
        XMLElementTravellerTypes xMLElementTravellerTypes = travellertypes = demandconfiguration.getTravellertypes() == null ? new XMLElementTravellerTypes() : demandconfiguration.getTravellertypes();
        if (travellertypes.getTravellertype().isEmpty()) {
            travellertypes.getTravellertype().add(ProcessConfiguration.generateDefaultXMLTravellerType());
        }
        for (XMLElementTravellerTypes.Travellertype travellertype : travellertypes.getTravellertype()) {
            TravelerType travelerType = demands.travelerTypes.createAndRegisterNewTravelerType(travellertype.getId().longValue(), travellertype.getName());
            boolean duplicateTravelerTypeExternalId = inputBuilderListener.addTravelerTypeToExternalIdMap(travelerType.getExternalId(), travelerType);
            PlanItException.throwIf(duplicateTravelerTypeExternalId && inputBuilderListener.isErrorIfDuplicateExternalId(), "Duplicate traveler type external id " + travelerType.getExternalId() + " found in network file");
        }
    }

    private static int generateAndStoreUserClasses(Demands demands, XMLElementDemandConfiguration demandconfiguration, PhysicalNetwork physicalNetwork, InputBuilderListener inputBuilderListener) throws PlanItException {
        XMLElementUserClasses userclasses;
        XMLElementUserClasses xMLElementUserClasses = userclasses = demandconfiguration.getUserclasses() == null ? new XMLElementUserClasses() : demandconfiguration.getUserclasses();
        if (userclasses.getUserclass().isEmpty()) {
            PlanItException.throwIf(demands.travelerTypes.getNumberOfTravelerTypes() > 1, "No user classes defined but more than 1 traveller type defined");
            XMLElementUserClasses.Userclass userClass = ProcessConfiguration.generateDefaultUserClass();
            userClass.setTravellertyperef(BigInteger.valueOf((Long)demands.travelerTypes.getFirst().getExternalId()));
            userclasses.getUserclass().add(userClass);
        }
        for (XMLElementUserClasses.Userclass userclass : userclasses.getUserclass()) {
            Long externalModeId;
            Mode userClassMode;
            if (userclass.getTravellertyperef() == null) {
                PlanItException.throwIf(demands.travelerTypes.getNumberOfTravelerTypes() > 1, "User class " + userclass.getId() + " has no traveller type specified, but more than one traveller type possible");
            } else {
                PlanItException.throwIf(demands.travelerTypes.getTravelerTypeByExternalId(userclass.getTravellertyperef().longValue()) == null, "travellertyperef value of " + userclass.getTravellertyperef().longValueExact() + " referenced by user class " + userclass.getName() + " but not defined");
            }
            PlanItException.throwIf(userclass.getModeref() == null, "User class " + userclass.getId() + " has no mode specified, but more than one mode possible");
            if (userclass.getModeref() == null) {
                PlanItException.throwIf(physicalNetwork.modes.getNumberOfModes() > 1, "User class " + userclass.getId() + " has no mode specified, but more than one mode possible");
                for (Mode mode : physicalNetwork.modes) {
                    long modeExternalId = (Long)mode.getExternalId();
                    userclass.setModeref(BigInteger.valueOf(modeExternalId));
                }
            }
            PlanItException.throwIf((userClassMode = inputBuilderListener.getModeByExternalId(externalModeId = Long.valueOf(userclass.getModeref().longValue()))) == null, "User class " + userclass.getId() + " refers to mode " + externalModeId + " which has not been defined");
            long travellerTypeId = userclass.getTravellertyperef() == null ? 1L : userclass.getTravellertyperef().longValue();
            userclass.setTravellertyperef(BigInteger.valueOf(travellerTypeId));
            TravelerType travellerType = inputBuilderListener.getTravelerTypeByExternalId(travellerTypeId);
            UserClass userClass = demands.userClasses.createAndRegisterNewUserClass(userclass.getId().longValue(), userclass.getName(), userClassMode, travellerType);
            boolean duplicateUserClassExternalId = inputBuilderListener.addUserClassToExternalIdMap(userClass.getExternalId(), userClass);
            PlanItException.throwIf(duplicateUserClassExternalId && inputBuilderListener.isErrorIfDuplicateExternalId(), "Duplicate user class external id " + userClass.getExternalId() + " found in network file");
        }
        return userclasses.getUserclass().size();
    }

    private static XMLElementTravellerTypes.Travellertype generateDefaultXMLTravellerType() {
        XMLElementTravellerTypes.Travellertype travellerType = new XMLElementTravellerTypes.Travellertype();
        travellerType.setId(BigInteger.valueOf(1L));
        travellerType.setName("Default");
        return travellerType;
    }

    private static XMLElementUserClasses.Userclass generateDefaultUserClass() {
        XMLElementUserClasses.Userclass userclass = new XMLElementUserClasses.Userclass();
        userclass.setName("Default");
        userclass.setId(BigInteger.valueOf(1L));
        userclass.setModeref(BigInteger.valueOf(1L));
        userclass.setTravellertyperef(BigInteger.valueOf(1L));
        return userclass;
    }

    private static void generateTimePeriodMap(Demands demands, XMLElementDemandConfiguration demandconfiguration, InputBuilderListener inputBuilderListener) throws PlanItException {
        XMLGregorianCalendar defaultStartTime;
        XMLElementTimePeriods timeperiods = demandconfiguration.getTimeperiods();
        try {
            LocalDateTime localDateTime = LocalDate.now().atStartOfDay();
            defaultStartTime = DatatypeFactory.newInstance().newXMLGregorianCalendar(localDateTime.format(DateTimeFormatter.ISO_DATE_TIME));
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when generating time period map when processing demand configuration", e);
        }
        for (XMLElementTimePeriods.Timeperiod timePeriodGenerated : timeperiods.getTimeperiod()) {
            long timePeriodExternalId = timePeriodGenerated.getId().longValue();
            XMLGregorianCalendar time = timePeriodGenerated.getStarttime() == null ? defaultStartTime : timePeriodGenerated.getStarttime();
            int startTimeSeconds = 3600 * time.getHour() + 60 * time.getMinute() + time.getSecond();
            int duration = timePeriodGenerated.getDuration().getValue().intValue();
            Durationunit durationUnit = timePeriodGenerated.getDuration().getUnit();
            if (timePeriodGenerated.getName() == null) {
                timePeriodGenerated.setName("");
            }
            switch (durationUnit) {
                case H: {
                    duration *= 3600;
                    break;
                }
                case M: {
                    duration *= 60;
                    break;
                }
            }
            TimePeriod timePeriod = demands.timePeriods.createAndRegisterNewTimePeriod(timePeriodExternalId, timePeriodGenerated.getName(), startTimeSeconds, duration);
            boolean duplicateTimePeriodExternalId = inputBuilderListener.addTimePeriodToExternalIdMap(timePeriod.getExternalId(), timePeriod);
            PlanItException.throwIf(duplicateTimePeriodExternalId && inputBuilderListener.isErrorIfDuplicateExternalId(), "Duplicate time period external id " + timePeriod.getExternalId() + " found in network file.");
        }
    }

    public static void generateAndStoreConfigurationData(Demands demands, XMLElementDemandConfiguration demandconfiguration, PhysicalNetwork physicalNetwork, InputBuilderListener inputBuilderListener) throws PlanItException {
        ProcessConfiguration.generateAndStoreTravelerTypes(demands, demandconfiguration, inputBuilderListener);
        ProcessConfiguration.generateAndStoreUserClasses(demands, demandconfiguration, physicalNetwork, inputBuilderListener);
        ProcessConfiguration.generateTimePeriodMap(demands, demandconfiguration, inputBuilderListener);
    }
}

