/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.zoning;

import com.vividsolutions.jts.geom.Coordinate;
import java.math.BigInteger;
import java.util.List;
import net.opengis.gml.PointType;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.coordinate.Position;
import org.planit.geo.PlanitGeoUtils;
import org.planit.input.InputBuilderListener;
import org.planit.io.xml.util.XmlUtils;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.Node;
import org.planit.utils.network.virtual.Centroid;
import org.planit.xml.generated.XMLElementCentroid;
import org.planit.xml.generated.XMLElementConnectoid;
import org.planit.xml.generated.XMLElementZones;

public class UpdateZoning {
    private static PlanitGeoUtils planitGeoUtils = new PlanitGeoUtils();

    public static DirectPosition getCentrePointGeometry(XMLElementZones.Zone zone) throws PlanItException {
        List<Double> value = zone.getCentroid().getPoint().getPos().getValue();
        Coordinate coordinate = new Coordinate(value.get(0), value.get(1));
        Coordinate[] coordinates = new Coordinate[]{coordinate};
        List<Position> positions = planitGeoUtils.convertToDirectPositions(coordinates);
        return (DirectPosition)positions.get(0);
    }

    public static void registerNewConnectoid(Zoning zoning, PhysicalNetwork.Nodes nodes, XMLElementZones.Zone zone, Centroid centroid, InputBuilderListener inputBuilderListener) throws PlanItException {
        double connectoidLength;
        XMLElementConnectoid connectoid = zone.getConnectoids().getConnectoid().get(0);
        long nodeExternalId = connectoid.getNoderef().longValue();
        Node node = inputBuilderListener.getNodeByExternalId(nodeExternalId);
        DirectPosition nodePosition = node.getCentrePointGeometry();
        BigInteger externalId = connectoid.getId();
        if (connectoid.getLength() != null) {
            connectoidLength = connectoid.getLength().floatValue();
        } else if (nodePosition != null) {
            XMLElementCentroid generatedCentroid = zone.getCentroid();
            PointType pointType = generatedCentroid.getPoint();
            DirectPosition centroidPosition = XmlUtils.getDirectPositionFromPointType(planitGeoUtils, pointType);
            connectoidLength = planitGeoUtils.getDistanceInKilometres(centroidPosition, nodePosition);
        } else {
            connectoidLength = 0.0;
        }
        if (externalId != null) {
            zoning.getVirtualNetwork().connectoids.registerNewConnectoid(centroid, node, connectoidLength, externalId.longValue());
        } else {
            zoning.getVirtualNetwork().connectoids.registerNewConnectoid(centroid, node, connectoidLength);
        }
    }
}

