/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical.macroscopic;

import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetworkBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.Pair;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegment;
import org.planit.utils.network.physical.macroscopic.MacroscopicLinkSegmentType;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicNetwork
extends PhysicalNetwork {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicNetwork.class.getCanonicalName());
    private static final long serialVersionUID = -6844990013871601434L;
    protected Map<Long, MacroscopicLinkSegmentType> macroscopicLinkSegmentTypeByIdMap = new TreeMap<Long, MacroscopicLinkSegmentType>();
    protected Map<MacroscopicLinkSegment, Map<Mode, Pair<Double, Double>>> bprParametersForLinkSegmentAndMode;

    public MacroscopicNetwork(IdGroupingToken groupId) {
        super(groupId, new MacroscopicNetworkBuilder());
    }

    public MacroscopicLinkSegmentType createAndRegisterNewMacroscopicLinkSegmentType(String name, double capacity, double maximumDensity, Object linkSegmentExternalId, Map<Mode, MacroscopicModeProperties> modeProperties) throws PlanItException {
        PlanItException.throwIf(!(this.networkBuilder instanceof MacroscopicNetworkBuilder), "Macroscopic network perspective only allows macroscopic link segment types to be registered");
        MacroscopicLinkSegmentType linkSegmentType = ((MacroscopicNetworkBuilder)this.networkBuilder).createLinkSegmentType(name, capacity, maximumDensity, linkSegmentExternalId, modeProperties);
        this.registerLinkSegmentType(linkSegmentType);
        return linkSegmentType;
    }

    public MacroscopicLinkSegmentType registerLinkSegmentType(MacroscopicLinkSegmentType linkSegmentType) {
        return this.macroscopicLinkSegmentTypeByIdMap.put(linkSegmentType.getId(), linkSegmentType);
    }

    public MacroscopicLinkSegmentType findMacroscopicLinkSegmentTypeById(long id) {
        return this.macroscopicLinkSegmentTypeByIdMap.get(id);
    }

    public MacroscopicLinkSegmentType getMacroscopicLinkSegmentTypeByExternalId(Object externalId, boolean convertToLong) {
        try {
            if (convertToLong) {
                long value = Long.valueOf(externalId.toString());
                return this.getMacroscopicLinkSegmentTypeByExternalId(value);
            }
            return this.getMacroscopicLinkSegmentTypeByExternalId(externalId);
        }
        catch (NumberFormatException numberFormatException) {
            return this.getMacroscopicLinkSegmentTypeByExternalId(externalId);
        }
    }

    public MacroscopicLinkSegmentType getMacroscopicLinkSegmentTypeByExternalId(Object externalId) {
        for (MacroscopicLinkSegmentType macroscopicLinkSegmentType : this.macroscopicLinkSegmentTypeByIdMap.values()) {
            if (!macroscopicLinkSegmentType.getExternalId().equals(externalId)) continue;
            return macroscopicLinkSegmentType;
        }
        return null;
    }
}

