/*
 * Decompiled with CFR 0.152.
 */
package org.planit.od;

import org.planit.network.virtual.Zoning;
import org.planit.od.ODDataIterator;
import org.planit.utils.network.virtual.Zone;

public abstract class ODDataIteratorImpl<T>
implements ODDataIterator<T> {
    protected int originId;
    protected int destinationId;
    protected int currentLocation;
    protected Zoning.Zones zones;

    protected void updateCurrentLocation() {
        this.originId = this.currentLocation / this.zones.getNumberOfZones();
        this.destinationId = this.currentLocation % this.zones.getNumberOfZones();
        ++this.currentLocation;
    }

    public ODDataIteratorImpl(Zoning.Zones zones) {
        this.zones = zones;
        this.currentLocation = 0;
    }

    @Override
    public boolean hasNext() {
        return this.currentLocation < this.zones.getNumberOfZones() * this.zones.getNumberOfZones();
    }

    @Override
    public Zone getCurrentOrigin() {
        return this.zones.getZoneById(this.originId);
    }

    @Override
    public Zone getCurrentDestination() {
        return this.zones.getZoneById(this.destinationId);
    }
}

