/*
 * Decompiled with CFR 0.152.
 */
package org.planit.od.odroute;

import org.planit.network.virtual.Zoning;
import org.planit.od.ODDataImpl;
import org.planit.od.odroute.ODRouteIterator;
import org.planit.route.Route;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.virtual.Zone;

public class ODRouteMatrix
extends ODDataImpl<Route> {
    private final Route[][] matrixContents;
    protected final long id;

    public ODRouteMatrix(IdGroupingToken groupId, Zoning.Zones zones) {
        super(zones);
        this.id = IdGenerator.generateId(groupId, ODRouteMatrix.class);
        int numberOfTravelAnalysisZones = zones.getNumberOfZones();
        this.matrixContents = new Route[numberOfTravelAnalysisZones][numberOfTravelAnalysisZones];
    }

    @Override
    public Route getValue(Zone origin, Zone destination) {
        int originId = (int)origin.getId();
        int destinationId = (int)destination.getId();
        return this.matrixContents[originId][destinationId];
    }

    @Override
    public void setValue(Zone origin, Zone destination, Route path) {
        int originId = (int)origin.getId();
        int destinationId = (int)destination.getId();
        this.matrixContents[originId][destinationId] = path;
    }

    public ODRouteIterator iterator() {
        return new ODRouteIterator(this.matrixContents, this.zones);
    }

    public long getId() {
        return this.id;
    }
}

