/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.adapter;

import org.planit.data.TraditionalStaticAssignmentSimulationData;
import org.planit.output.adapter.LinkOutputTypeAdapterImpl;
import org.planit.output.enums.OutputType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;

public class TraditionalStaticAssignmentLinkOutputTypeAdapter
extends LinkOutputTypeAdapterImpl {
    private double getCalculatedSpeed(LinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        TraditionalStaticAssignmentSimulationData simulationData = (TraditionalStaticAssignmentSimulationData)this.trafficAssignment.getSimulationData();
        double[] modalNetworkSegmentCosts = simulationData.getModalLinkSegmentCosts(mode);
        double travelTime = modalNetworkSegmentCosts[id];
        double length = linkSegment.getParentLink().getLength();
        return length / travelTime;
    }

    private double getFlow(LinkSegment linkSegment, Mode mode) throws PlanItException {
        int id = (int)linkSegment.getId();
        TraditionalStaticAssignmentSimulationData simulationData = (TraditionalStaticAssignmentSimulationData)this.trafficAssignment.getSimulationData();
        double[] modalNetworkSegmentFlows = simulationData.getModalNetworkSegmentFlows(mode);
        return modalNetworkSegmentFlows[id];
    }

    private double getLinkCost(LinkSegment linkSegment, Mode mode, double timeUnitMultiplier) throws PlanItException {
        int id = (int)linkSegment.getId();
        TraditionalStaticAssignmentSimulationData simulationData = (TraditionalStaticAssignmentSimulationData)this.trafficAssignment.getSimulationData();
        double[] modalNetworkSegmentCosts = simulationData.getModalLinkSegmentCosts(mode);
        return modalNetworkSegmentCosts[id] * timeUnitMultiplier;
    }

    private double getCostTimesFlow(LinkSegment linkSegment, Mode mode, double timeUnitMultiplier) throws PlanItException {
        return this.getLinkCost(linkSegment, mode, timeUnitMultiplier) * this.getFlow(linkSegment, mode);
    }

    private double getVCRatio(LinkSegment linkSegment) throws PlanItException {
        double totalFlow = 0.0;
        for (Mode mode : this.trafficAssignment.getTransportNetwork().getPhysicalNetwork().modes) {
            totalFlow += this.getFlow(linkSegment, mode);
        }
        double capacityPerLane = this.getCapacityPerLane(linkSegment);
        return totalFlow / ((double)linkSegment.getNumberOfLanes() * capacityPerLane);
    }

    public TraditionalStaticAssignmentLinkOutputTypeAdapter(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public boolean isFlowPositive(LinkSegment linkSegment, Mode mode) {
        TraditionalStaticAssignmentSimulationData simulationData = (TraditionalStaticAssignmentSimulationData)this.trafficAssignment.getSimulationData();
        return simulationData.getModalNetworkSegmentFlows(mode)[(int)linkSegment.getId()] > 0.0;
    }

    @Override
    public Object getLinkOutputPropertyValue(OutputProperty outputProperty, LinkSegment linkSegment, Mode mode, TimePeriod timePeriod, double timeUnitMultiplier) {
        try {
            Object obj = this.getCommonPropertyValue(outputProperty, mode, timePeriod);
            if (obj != null) {
                return obj;
            }
            obj = super.getLinkOutputPropertyValue(outputProperty, linkSegment, mode, timePeriod, timeUnitMultiplier);
            if (obj != null) {
                return obj;
            }
            switch (outputProperty) {
                case CALCULATED_SPEED: {
                    return this.getCalculatedSpeed(linkSegment, mode);
                }
                case FLOW: {
                    return this.getFlow(linkSegment, mode);
                }
                case LINK_COST: {
                    return this.getLinkCost(linkSegment, mode, timeUnitMultiplier);
                }
                case VC_RATIO: {
                    return this.getVCRatio(linkSegment);
                }
                case COST_TIMES_FLOW: {
                    return this.getCostTimesFlow(linkSegment, mode, timeUnitMultiplier);
                }
            }
            return new PlanItException("Tried to find link property of " + BaseOutputProperty.convertToBaseOutputProperty(outputProperty).getName() + " which is not applicable for links.");
        }
        catch (PlanItException e) {
            return e;
        }
    }
}

