/*
 * Decompiled with CFR 0.152.
 */
package org.planit.output.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.property.BaseOutputProperty;
import org.planit.output.property.OutputProperty;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.utils.exceptions.PlanItException;

public class LinkOutputTypeConfiguration
extends OutputTypeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(LinkOutputTypeConfiguration.class.getCanonicalName());
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_NODE_ID = 1;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_ID = 2;
    private static final int LINK_SEGMENT_IDENTIFICATION_BY_EXTERNAL_ID = 3;
    private static final int LINK_SEGMENT_NOT_IDENTIFIED = 4;

    private int findIdentificationMethod(OutputProperty[] outputKeyProperties) {
        List<OutputProperty> outputKeyPropertyList = Arrays.asList(outputKeyProperties);
        if (outputKeyPropertyList.contains((Object)OutputProperty.DOWNSTREAM_NODE_EXTERNAL_ID) && outputKeyPropertyList.contains((Object)OutputProperty.UPSTREAM_NODE_EXTERNAL_ID)) {
            return 1;
        }
        if (outputKeyPropertyList.contains((Object)OutputProperty.LINK_SEGMENT_ID)) {
            return 2;
        }
        if (outputKeyPropertyList.contains((Object)OutputProperty.LINK_SEGMENT_EXTERNAL_ID)) {
            return 3;
        }
        return 4;
    }

    public LinkOutputTypeConfiguration(TrafficAssignment trafficAssignment) throws PlanItException {
        super(trafficAssignment, OutputType.LINK);
        this.addProperty(OutputProperty.LINK_SEGMENT_ID);
        this.addProperty(OutputProperty.LINK_SEGMENT_EXTERNAL_ID);
        this.addProperty(OutputProperty.UPSTREAM_NODE_EXTERNAL_ID);
        this.addProperty(OutputProperty.UPSTREAM_NODE_ID);
        this.addProperty(OutputProperty.UPSTREAM_NODE_LOCATION);
        this.addProperty(OutputProperty.DOWNSTREAM_NODE_EXTERNAL_ID);
        this.addProperty(OutputProperty.DOWNSTREAM_NODE_ID);
        this.addProperty(OutputProperty.DOWNSTREAM_NODE_LOCATION);
        this.addProperty(OutputProperty.FLOW);
        this.addProperty(OutputProperty.CAPACITY_PER_LANE);
        this.addProperty(OutputProperty.NUMBER_OF_LANES);
        this.addProperty(OutputProperty.LENGTH);
        this.addProperty(OutputProperty.CALCULATED_SPEED);
        this.addProperty(OutputProperty.LINK_COST);
        this.addProperty(OutputProperty.MODE_ID);
        this.addProperty(OutputProperty.MODE_EXTERNAL_ID);
        this.addProperty(OutputProperty.MAXIMUM_SPEED);
        this.addProperty(OutputProperty.TIME_PERIOD_EXTERNAL_ID);
        this.addProperty(OutputProperty.TIME_PERIOD_ID);
    }

    @Override
    public OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] outputKeyProperties) {
        OutputProperty[] outputKeyPropertiesArray = null;
        boolean valid = false;
        switch (this.findIdentificationMethod(outputKeyProperties)) {
            case 1: {
                outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.DOWNSTREAM_NODE_EXTERNAL_ID, OutputProperty.UPSTREAM_NODE_EXTERNAL_ID};
                valid = true;
                break;
            }
            case 2: {
                outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.LINK_SEGMENT_ID};
                valid = true;
                break;
            }
            case 3: {
                outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.LINK_SEGMENT_EXTERNAL_ID};
                valid = true;
                break;
            }
            default: {
                LOGGER.warning("configured keys cannot identify link segments");
            }
        }
        if (valid) {
            return outputKeyPropertiesArray;
        }
        return null;
    }

    @Override
    public boolean isOutputPropertyValid(BaseOutputProperty baseOutputProperty) {
        switch (baseOutputProperty.getOutputProperty()) {
            case CALCULATED_SPEED: {
                return true;
            }
            case CAPACITY_PER_LANE: {
                return true;
            }
            case DENSITY: {
                return true;
            }
            case DOWNSTREAM_NODE_EXTERNAL_ID: {
                return true;
            }
            case DOWNSTREAM_NODE_ID: {
                return true;
            }
            case DOWNSTREAM_NODE_LOCATION: {
                return true;
            }
            case FLOW: {
                return true;
            }
            case ITERATION_INDEX: {
                return true;
            }
            case LENGTH: {
                return true;
            }
            case LINK_COST: {
                return true;
            }
            case LINK_SEGMENT_EXTERNAL_ID: {
                return true;
            }
            case LINK_SEGMENT_ID: {
                return true;
            }
            case MAXIMUM_DENSITY: {
                return true;
            }
            case MAXIMUM_SPEED: {
                return true;
            }
            case MODE_EXTERNAL_ID: {
                return true;
            }
            case MODE_ID: {
                return true;
            }
            case NUMBER_OF_LANES: {
                return true;
            }
            case RUN_ID: {
                return true;
            }
            case TIME_PERIOD_EXTERNAL_ID: {
                return true;
            }
            case TIME_PERIOD_ID: {
                return true;
            }
            case UPSTREAM_NODE_EXTERNAL_ID: {
                return true;
            }
            case UPSTREAM_NODE_ID: {
                return true;
            }
            case UPSTREAM_NODE_LOCATION: {
                return true;
            }
            case VC_RATIO: {
                return true;
            }
            case COST_TIMES_FLOW: {
                return true;
            }
            case LINK_TYPE: {
                return true;
            }
        }
        LOGGER.warning("tried to add " + baseOutputProperty.getName() + " as an ouput property, which is inappropriate for Link output.  This will be ignored");
        return false;
    }
}

