/*
 * Decompiled with CFR 0.152.
 */
package org.planit.project;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.demands.Demands;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.output.formatter.OutputFormatter;
import org.planit.output.formatter.OutputFormatterFactory;
import org.planit.project.PlanItProjectInput;
import org.planit.route.ODRouteSets;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.trafficassignment.TrafficAssignmentComponent;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.trafficassignment.builder.TrafficAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;

public class CustomPlanItProject {
    private static final Logger LOGGER = Logger.getLogger(CustomPlanItProject.class.getCanonicalName());
    protected final long id;
    protected IdGroupingToken projectToken;
    protected final PlanItProjectInput inputs;
    protected final InputBuilderListener inputBuilderListener;
    protected final TreeMap<Long, OutputFormatter> outputFormatters;
    protected TrafficAssignmentComponentFactory<NetworkLoading> assignmentFactory;
    public final PlanItProjectInput.ProjectNetworks physicalNetworks;
    public final PlanItProjectInput.ProjectDemands demands;
    public final PlanItProjectInput.ProjectZonings zonings;
    public final PlanItProjectInput.ProjectODRouteSets odRouteSets;
    public final ProjectAssignments trafficAssignments = new ProjectAssignments();

    protected void initialiseFactories() {
        this.assignmentFactory = new TrafficAssignmentComponentFactory<NetworkLoading>(NetworkLoading.class);
        this.assignmentFactory.addListener(this.inputBuilderListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
    }

    protected void executeTrafficAssignment(TrafficAssignment ta) {
        try {
            ta.execute();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public CustomPlanItProject(InputBuilderListener inputBuilderListener) {
        this.id = IdGenerator.generateId(IdGroupingToken.collectGlobalToken(), CustomPlanItProject.class);
        this.projectToken = IdGenerator.createIdGroupingToken(this, this.id);
        this.inputBuilderListener = inputBuilderListener;
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.activateItemByClassName(inputBuilderListener, true));
        this.inputs = new PlanItProjectInput(this.id, this.projectToken, inputBuilderListener);
        this.physicalNetworks = this.inputs.physicalNetworks;
        this.demands = this.inputs.demands;
        this.zonings = this.inputs.zonings;
        this.odRouteSets = this.inputs.odRouteSets;
        this.outputFormatters = new TreeMap();
        this.initialiseFactories();
    }

    public void registerEligibleTrafficComponentClass(Class<? extends TrafficAssignmentComponent<?>> theClazz) throws PlanItException {
        TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(theClazz);
    }

    public PhysicalNetwork createAndRegisterPhysicalNetwork(String physicalNetworkType) throws PlanItException {
        return this.inputs.createAndRegisterPhysicalNetwork(physicalNetworkType);
    }

    public Zoning createAndRegisterZoning(PhysicalNetwork physicalNetwork) throws PlanItException {
        return this.inputs.createAndRegisterZoning(physicalNetwork);
    }

    public Demands createAndRegisterDemands(Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        return this.inputs.createAndRegisterDemands(zoning, physicalNetwork);
    }

    public ODRouteSets createAndRegisterODRouteSets(PhysicalNetwork physicalNetwork, Zoning zoning, String odRouteSetInputPath) throws PlanItException {
        return this.inputs.createAndRegisterODRouteSets(physicalNetwork, zoning, odRouteSetInputPath);
    }

    public TrafficAssignmentBuilder createAndRegisterTrafficAssignment(String trafficAssignmentType, Demands theDemands, Zoning theZoning, PhysicalNetwork thePhysicalNetwork) throws PlanItException {
        NetworkLoading networkLoadingAndAssignment = this.assignmentFactory.create(trafficAssignmentType, new Object[]{this.projectToken});
        PlanItException.throwIf(!(networkLoadingAndAssignment instanceof TrafficAssignment), "not a valid traffic assignment type");
        TrafficAssignment trafficAssignment = (TrafficAssignment)networkLoadingAndAssignment;
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.activateItemByClassName(trafficAssignment, true));
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.createRunIdPrefix(trafficAssignment.getId()) + "assignment registered");
        TrafficAssignmentBuilder trafficAssignmentBuilder = trafficAssignment.collectBuilder(this.inputBuilderListener, theDemands, theZoning, thePhysicalNetwork);
        trafficAssignmentBuilder.initialiseDefaults();
        this.trafficAssignments.addTrafficAssignment(trafficAssignment);
        return trafficAssignmentBuilder;
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName);
    }

    public InitialLinkSegmentCostPeriod createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName, TimePeriod timePeriod) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName, timePeriod);
    }

    public List<InitialLinkSegmentCostPeriod> createAndRegisterInitialLinkSegmentCost(PhysicalNetwork network, String fileName, Demands demands) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName, demands);
    }

    public OutputFormatter createAndRegisterOutputFormatter(String outputFormatterType) throws PlanItException {
        OutputFormatter outputFormatter = OutputFormatterFactory.createOutputFormatter(outputFormatterType);
        PlanItException.throwIf(outputFormatter == null, "Output writer of type " + outputFormatterType + " could not be created");
        this.outputFormatters.put(outputFormatter.getId(), outputFormatter);
        return outputFormatter;
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(PhysicalNetwork network) {
        return this.inputs.getInitialLinkSegmentCost(network);
    }

    public OutputFormatter getOutputFormatter(long id) {
        return this.outputFormatters.get(id);
    }

    public void executeAllTrafficAssignments() throws PlanItException {
        for (TrafficAssignment ta : this.trafficAssignments) {
            try {
                ta.execute();
            }
            catch (PlanItException pe) {
                LOGGER.severe(pe.getMessage());
            }
        }
    }

    public class ProjectAssignments
    implements Iterable<TrafficAssignment> {
        protected final TreeMap<Long, TrafficAssignment> trafficAssignmentsMap = new TreeMap();

        protected void addTrafficAssignment(TrafficAssignment trafficAssignment) {
            this.trafficAssignmentsMap.put(trafficAssignment.getId(), trafficAssignment);
        }

        public TrafficAssignment getTrafficAssignment(long id) {
            return this.trafficAssignmentsMap.get(id);
        }

        public int getNumberOfTrafficAssignments() {
            return this.trafficAssignmentsMap.size();
        }

        public boolean hasRegisteredAssignments() {
            return !this.trafficAssignmentsMap.isEmpty();
        }

        public TrafficAssignment getFirstTrafficAssignment() {
            return this.hasRegisteredAssignments() ? this.trafficAssignmentsMap.firstEntry().getValue() : null;
        }

        @Override
        public Iterator<TrafficAssignment> iterator() {
            return this.trafficAssignmentsMap.values().iterator();
        }
    }
}

