/*
 * Decompiled with CFR 0.152.
 */
package org.planit.route;

import java.util.TreeMap;
import org.planit.network.virtual.Zoning;
import org.planit.od.odroute.ODRouteMatrix;
import org.planit.trafficassignment.TrafficAssignmentComponent;
import org.planit.utils.id.IdGroupingToken;

public class ODRouteSets
extends TrafficAssignmentComponent<ODRouteSets> {
    private static final long serialVersionUID = -8742549499023004121L;
    protected final TreeMap<Long, ODRouteMatrix> odRouteMatrices = new TreeMap();

    public ODRouteSets(IdGroupingToken groupId) {
        super(groupId, ODRouteSets.class);
    }

    public int getNumberOfOdRouteSets() {
        return this.odRouteMatrices.size();
    }

    public ODRouteMatrix createAndRegisterOdRouteMatrix(Zoning zoning) {
        ODRouteMatrix newOdRouteMatrix = new ODRouteMatrix(this.groupId, zoning.zones);
        this.odRouteMatrices.put(newOdRouteMatrix.getId(), newOdRouteMatrix);
        return newOdRouteMatrix;
    }

    public void registerOdRouteMatrix(ODRouteMatrix odRouteMatrix) {
        this.odRouteMatrices.put(odRouteMatrix.getId(), odRouteMatrix);
    }

    public Boolean hasRegisteredOdMatrices() {
        return !this.odRouteMatrices.isEmpty();
    }

    public ODRouteMatrix getFirstODRouteMatrix() {
        return this.hasRegisteredOdMatrices() != false ? this.odRouteMatrices.firstEntry().getValue() : null;
    }
}

