/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.djutils.event.Event;
import org.djutils.event.EventType;
import org.planit.cost.physical.PhysicalCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.virtual.VirtualCost;
import org.planit.data.SimulationData;
import org.planit.demands.Demands;
import org.planit.gap.GapFunction;
import org.planit.input.InputBuilderListener;
import org.planit.interactor.InteractorAccessor;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicLinkSegmentImpl;
import org.planit.network.transport.TransportNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.output.OutputManager;
import org.planit.output.adapter.OutputTypeAdapter;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.formatter.OutputFormatter;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TraditionalStaticAssignment;
import org.planit.trafficassignment.builder.TrafficAssignmentBuilder;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.misc.LoggingUtils;

public abstract class TrafficAssignment
extends NetworkLoading {
    private static final long serialVersionUID = 801775330292422910L;
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private Zoning zoning;
    private GapFunction gapFunction;
    protected TrafficAssignmentBuilder trafficAssignmentBuilder;
    protected PhysicalNetwork physicalNetwork;
    protected OutputManager outputManager = new OutputManager(this);
    protected TransportNetwork transportNetwork = null;
    protected VirtualCost virtualCost;
    protected int numberOfNetworkSegments;
    protected int numberOfNetworkVertices;
    protected Smoothing smoothing = null;
    protected Demands demands = null;
    protected InitialLinkSegmentCost initialLinkSegmentCost;
    protected PhysicalCost physicalCost;
    protected Map<TimePeriod, InitialLinkSegmentCost> initialLinkSegmentCostByTimePeriod = new HashMap<TimePeriod, InitialLinkSegmentCost>();
    public static String TRADITIONAL_STATIC_ASSIGNMENT = TraditionalStaticAssignment.class.getCanonicalName();

    protected abstract TrafficAssignmentBuilder createTrafficAssignmentBuilder(InputBuilderListener var1, Demands var2, Zoning var3, PhysicalNetwork var4) throws PlanItException;

    protected abstract void addRegisteredEventTypeListeners(EventType var1);

    protected String createLoggingPrefix(int iterationIndex) {
        return LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createIterationPrefix(iterationIndex);
    }

    protected void checkForEmptyComponents() throws PlanItException {
        PlanItException.throwIf(this.demands == null, "Demand is null");
        PlanItException.throwIf(this.physicalNetwork == null, "Network is null");
        PlanItException.throwIf(this.smoothing == null, "Smoothing is null");
        PlanItException.throwIf(this.zoning == null, "Zoning is null");
    }

    protected void verifyComponentCompatibility() throws PlanItException {
    }

    protected void createTransportNetwork() throws PlanItException {
        this.transportNetwork = new TransportNetwork(this.physicalNetwork, this.zoning);
        this.transportNetwork.integrateConnectoidsAndLinks();
        this.numberOfNetworkSegments = this.getTransportNetwork().getTotalNumberOfEdgeSegments();
        this.numberOfNetworkVertices = this.getTransportNetwork().getTotalNumberOfVertices();
    }

    protected void disbandTransportNetwork() throws PlanItException {
        this.transportNetwork.removeVirtualNetworkFromPhysicalNetwork();
    }

    protected void initialiseBeforeExecution() throws PlanItException {
        this.checkForEmptyComponents();
        this.verifyComponentCompatibility();
        this.createTransportNetwork();
        this.outputManager.initialiseBeforeSimulation(this.getId());
        this.physicalCost.initialiseBeforeSimulation(this.physicalNetwork);
        this.virtualCost.initialiseBeforeSimulation(this.zoning.getVirtualNetwork());
    }

    protected void finalizeAfterExecution() throws PlanItException {
        this.disbandTransportNetwork();
        this.outputManager.finaliseAfterSimulation();
    }

    public TrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    public TrafficAssignmentBuilder collectBuilder(InputBuilderListener trafficComponentCreateListener, Demands theDemands, Zoning theZoning, PhysicalNetwork thePhysicalNetwork) throws PlanItException {
        if (this.trafficAssignmentBuilder == null) {
            this.trafficAssignmentBuilder = this.createTrafficAssignmentBuilder(trafficComponentCreateListener, theDemands, theZoning, thePhysicalNetwork);
        }
        return this.trafficAssignmentBuilder;
    }

    public abstract void executeEquilibration() throws PlanItException;

    public abstract OutputTypeAdapter createOutputTypeAdapter(OutputType var1);

    public OutputTypeConfiguration activateOutput(OutputType outputType) throws PlanItException {
        OutputTypeConfiguration theOutputTypeConfiguration = null;
        if (!this.isOutputTypeActive(outputType)) {
            OutputTypeAdapter outputTypeAdapter = this.createOutputTypeAdapter(outputType);
            this.outputManager.registerOutputTypeAdapter(outputType, outputTypeAdapter);
            theOutputTypeConfiguration = this.outputManager.createAndRegisterOutputTypeConfiguration(outputType, this);
        } else {
            theOutputTypeConfiguration = this.outputManager.getOutputTypeConfiguration(outputType);
        }
        return theOutputTypeConfiguration;
    }

    public void deactivateOutput(OutputType outputType) {
        if (this.isOutputTypeActive(outputType)) {
            this.outputManager.deregisterOutputTypeConfiguration(outputType);
            this.outputManager.deregisterOutputTypeAdapter(outputType);
        }
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.outputManager.isOutputTypeActive(outputType);
    }

    public void execute() throws PlanItException {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s -----------------", this.getClass().getSimpleName()));
        this.initialiseBeforeExecution();
        this.executeEquilibration();
        this.finalizeAfterExecution();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("----------------- %s ----------------", this.getClass().getSimpleName()));
    }

    public TransportNetwork getTransportNetwork() {
        return this.transportNetwork;
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.outputManager.getOutputConfiguration();
    }

    public void setSmoothing(Smoothing smoothing) {
        this.smoothing = smoothing;
    }

    public Smoothing getSmoothing() {
        return this.smoothing;
    }

    public GapFunction getGapFunction() {
        return this.gapFunction;
    }

    public void setGapFunction(GapFunction gapfunction) {
        this.gapFunction = gapfunction;
    }

    public void setPhysicalNetwork(PhysicalNetwork physicalNetwork) {
        this.physicalNetwork = physicalNetwork;
    }

    public void setDemands(Demands demands) {
        this.demands = demands;
    }

    public void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    public void setInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCost = initialLinkSegmentCost;
    }

    public void setInitialLinkSegmentCost(TimePeriod timePeriod, InitialLinkSegmentCost initialLinkSegmentCost) {
        this.initialLinkSegmentCostByTimePeriod.put(timePeriod, initialLinkSegmentCost);
    }

    public PhysicalCost getPhysicalCost() {
        return this.physicalCost;
    }

    public void setPhysicalCost(PhysicalCost physicalCost) throws PlanItException {
        this.physicalCost = physicalCost;
        if (this.physicalCost instanceof InteractorAccessor) {
            EventType requestAccessee = ((InteractorAccessor)((Object)physicalCost)).getRequestedAccesseeEventType();
            this.addRegisteredEventTypeListeners(requestAccessee);
            this.fireEvent(new Event(requestAccessee, this, this.physicalCost));
            PlanItException.throwIf(!this.listeners.containsKey(requestAccessee), "Error during setPhysicalCost");
        }
    }

    public VirtualCost getVirtualCost() {
        return this.virtualCost;
    }

    public void setVirtualCost(VirtualCost virtualCost) throws PlanItException {
        this.virtualCost = virtualCost;
        if (this.virtualCost instanceof InteractorAccessor) {
            EventType requestAccesseeType = ((InteractorAccessor)((Object)virtualCost)).getRequestedAccesseeEventType();
            this.addRegisteredEventTypeListeners(requestAccesseeType);
            this.fireEvent(new Event(requestAccesseeType, this, this.virtualCost));
            if (!this.listeners.containsKey(requestAccesseeType)) {
                String errorMessage = "Error during setVirtualCost";
                throw new PlanItException(errorMessage);
            }
        }
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) {
        this.outputManager.registerOutputFormatter(outputFormatter);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) {
        this.outputManager.unregisterOutputFormatter(outputFormatter);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.outputManager.getOutputFormatters();
    }

    public abstract SimulationData getSimulationData();
}

