/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.djutils.event.Event;
import org.djutils.event.EventProducer;
import org.djutils.event.EventType;
import org.planit.cost.physical.BPRLinkTravelTimeCost;
import org.planit.cost.physical.PhysicalCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.physical.initial.InitialPhysicalCost;
import org.planit.cost.virtual.FixedConnectoidTravelTimeCost;
import org.planit.cost.virtual.SpeedConnectoidTravelTimeCost;
import org.planit.cost.virtual.VirtualCost;
import org.planit.demands.Demands;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.physical.macroscopic.MacroscopicNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.route.ODRouteSets;
import org.planit.route.choice.RouteChoice;
import org.planit.route.choice.logit.LogitChoiceModel;
import org.planit.route.choice.logit.MultinomialLogit;
import org.planit.sdinteraction.smoothing.MSASmoothing;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.supply.fundamentaldiagram.FundamentalDiagram;
import org.planit.supply.fundamentaldiagram.NewellFundamentalDiagram;
import org.planit.supply.network.nodemodel.NodeModel;
import org.planit.supply.network.nodemodel.TampereNodeModel;
import org.planit.supply.networkloading.NetworkLoading;
import org.planit.trafficassignment.TraditionalStaticAssignment;
import org.planit.trafficassignment.TrafficAssignmentComponent;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.reflection.ReflectionUtils;

public class TrafficAssignmentComponentFactory<T extends TrafficAssignmentComponent<T>>
extends EventProducer
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(TrafficAssignmentComponentFactory.class.getCanonicalName());
    private static final long serialVersionUID = -4507287133047792042L;
    public static final EventType TRAFFICCOMPONENT_CREATE = new EventType("TRAFFICCOMPONENT.CREATE");
    protected final Class<T> componentSuperType;
    protected static final HashMap<Class<? extends TrafficAssignmentComponent<?>>, TreeSet<String>> registeredTrafficAssignmentComponents = new HashMap();

    private static void registerDefaultImplementations() {
        try {
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(Zoning.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(TraditionalStaticAssignment.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MSASmoothing.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(Demands.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MacroscopicNetwork.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(BPRLinkTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(InitialLinkSegmentCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(InitialLinkSegmentCostPeriod.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(FixedConnectoidTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(SpeedConnectoidTravelTimeCost.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(NewellFundamentalDiagram.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(TampereNodeModel.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(MultinomialLogit.class);
            TrafficAssignmentComponentFactory.registerTrafficAssignmentComponentType(ODRouteSets.class);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    private T createTrafficComponent(String trafficAssignmentComponentClassName, Object[] constructorParameters) throws PlanItException {
        TreeSet<String> eligibleComponentTypes = registeredTrafficAssignmentComponents.get(this.componentSuperType);
        PlanItException.throwIf(!eligibleComponentTypes.contains(trafficAssignmentComponentClassName), "Provided Traffic Assignment Component class is not eligible for construction");
        return (T)((TrafficAssignmentComponent)ReflectionUtils.createInstance(trafficAssignmentComponentClassName, constructorParameters));
    }

    private void dispatchTrafficComponentEvent(T newTrafficComponent, Object[] parameters) throws PlanItException {
        this.fireEvent(new Event(TRAFFICCOMPONENT_CREATE, this, (Serializable)new Object[]{newTrafficComponent, parameters}));
        PlanItException.throwIf(!this.listeners.containsKey(TRAFFICCOMPONENT_CREATE), "Error during dispatchTrafficComponentEvent");
    }

    public TrafficAssignmentComponentFactory(Class<T> componentSuperType) {
        this.componentSuperType = componentSuperType;
    }

    public static void registerTrafficAssignmentComponentType(Class<? extends TrafficAssignmentComponent<?>> trafficAssignmentComponent) throws PlanItException {
        for (Class<TrafficAssignmentComponent<?>> currentClass = trafficAssignmentComponent; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Type currentSuperClass = currentClass.getGenericSuperclass();
            if (!(currentSuperClass instanceof ParameterizedType) || ((ParameterizedType)currentSuperClass).getRawType() != TrafficAssignmentComponent.class) continue;
            TreeSet<String> treeSet = registeredTrafficAssignmentComponents.get(currentClass);
            PlanItException.throwIf(treeSet == null, "Base class of traffic assignment component not registered as eligible on PLANit");
            treeSet.add(trafficAssignmentComponent.getCanonicalName());
            registeredTrafficAssignmentComponents.get(currentClass).add(trafficAssignmentComponent.getCanonicalName());
            return;
        }
        throw new PlanItException("trafficAssignmentComponent not eligible for registration");
    }

    public T create(String trafficAssignmentComponentClassName, Object[] constructorParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(trafficAssignmentComponentClassName, constructorParameters);
        this.dispatchTrafficComponentEvent(newTrafficComponent, constructorParameters);
        return newTrafficComponent;
    }

    public T create(String trafficAssignmentComponentClassName, Object[] constructorParameters, Object ... eventParameters) throws PlanItException {
        T newTrafficComponent = this.createTrafficComponent(trafficAssignmentComponentClassName, constructorParameters);
        this.dispatchTrafficComponentEvent(newTrafficComponent, eventParameters);
        return newTrafficComponent;
    }

    @Override
    public Serializable getSourceId() {
        return this;
    }

    static {
        registeredTrafficAssignmentComponents.put(Zoning.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(NetworkLoading.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(Smoothing.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(Demands.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(PhysicalNetwork.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(PhysicalCost.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(InitialPhysicalCost.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(VirtualCost.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(FundamentalDiagram.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(NodeModel.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(RouteChoice.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(LogitChoiceModel.class, new TreeSet());
        registeredTrafficAssignmentComponents.put(ODRouteSets.class, new TreeSet());
        TrafficAssignmentComponentFactory.registerDefaultImplementations();
    }
}

