/*
 * Decompiled with CFR 0.152.
 */
package org.planit.trafficassignment.builder;

import java.util.List;
import java.util.logging.Logger;
import org.planit.cost.physical.PhysicalCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCost;
import org.planit.cost.physical.initial.InitialLinkSegmentCostPeriod;
import org.planit.cost.virtual.VirtualCost;
import org.planit.demands.Demands;
import org.planit.gap.GapFunction;
import org.planit.gap.LinkBasedRelativeDualityGapFunction;
import org.planit.gap.StopCriterion;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.PhysicalNetwork;
import org.planit.network.virtual.Zoning;
import org.planit.output.configuration.OutputConfiguration;
import org.planit.output.configuration.OutputTypeConfiguration;
import org.planit.output.enums.OutputType;
import org.planit.output.formatter.OutputFormatter;
import org.planit.sdinteraction.smoothing.Smoothing;
import org.planit.time.TimePeriod;
import org.planit.trafficassignment.TrafficAssignment;
import org.planit.trafficassignment.TrafficAssignmentComponentFactory;
import org.planit.utils.exceptions.PlanItException;
import org.planit.utils.misc.LoggingUtils;
import org.planit.utils.network.physical.Mode;

public abstract class TrafficAssignmentBuilder {
    private static final Logger LOGGER = Logger.getLogger(TrafficAssignmentBuilder.class.getCanonicalName());
    protected final TrafficAssignmentComponentFactory<Smoothing> smoothingFactory;
    protected final TrafficAssignmentComponentFactory<PhysicalCost> physicalCostFactory;
    protected final TrafficAssignmentComponentFactory<VirtualCost> virtualCostFactory;
    protected final TrafficAssignment parentAssignment;

    private void logRegisteredComponent(Object item, boolean register) {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.parentAssignment.getId()) + LoggingUtils.activateItemByClassName(item, register));
    }

    private void registerDemandZoningAndNetwork(Demands demands, Zoning zoning, PhysicalNetwork network) throws PlanItException {
        if (zoning == null || demands == null || network == null) {
            PlanItException.throwIf(zoning == null, "zoning in registerDemandZoningAndNetwork is null");
            PlanItException.throwIf(demands == null, "demands in registerDemandZoningAndNetwork is null");
            PlanItException.throwIf(network == null, "network in registerDemandZoningAndNetwork is null");
        }
        PlanItException.throwIf(!zoning.isCompatibleWithDemands(demands, network.modes), "Zoning structure is incompatible with one or more of the demands, likely the number of zones does not match the number of origins and/or destinations");
        for (Mode mode : network.modes) {
            for (TimePeriod timePeriod : demands.timePeriods.asSortedSetByStartTime()) {
                if (demands.get(mode, timePeriod) != null) continue;
                LOGGER.warning(LoggingUtils.createRunIdPrefix(this.parentAssignment.getId()) + "no demand matrix defined for Mode " + mode.getExternalId() + " and Time Period " + timePeriod.getExternalId());
            }
        }
        this.parentAssignment.setPhysicalNetwork(network);
        this.logRegisteredComponent(network, true);
        this.parentAssignment.setZoning(zoning);
        this.logRegisteredComponent(zoning, true);
        this.parentAssignment.setDemands(demands);
        this.logRegisteredComponent(demands, true);
    }

    protected GapFunction createGapFunction() {
        return new LinkBasedRelativeDualityGapFunction(new StopCriterion());
    }

    TrafficAssignmentBuilder(TrafficAssignment parentAssignment, InputBuilderListener trafficComponentCreateListener, Demands demands, Zoning zoning, PhysicalNetwork physicalNetwork) throws PlanItException {
        this.parentAssignment = parentAssignment;
        this.registerDemandZoningAndNetwork(demands, zoning, physicalNetwork);
        this.smoothingFactory = new TrafficAssignmentComponentFactory<Smoothing>(Smoothing.class);
        this.physicalCostFactory = new TrafficAssignmentComponentFactory<PhysicalCost>(PhysicalCost.class);
        this.virtualCostFactory = new TrafficAssignmentComponentFactory<VirtualCost>(VirtualCost.class);
        this.smoothingFactory.addListener(trafficComponentCreateListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.physicalCostFactory.addListener(trafficComponentCreateListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
        this.virtualCostFactory.addListener(trafficComponentCreateListener, TrafficAssignmentComponentFactory.TRAFFICCOMPONENT_CREATE);
    }

    public void initialiseDefaults() throws PlanItException {
        GapFunction theGapFunction = this.createGapFunction();
        this.parentAssignment.setGapFunction(theGapFunction);
        this.logRegisteredComponent(theGapFunction, true);
        this.activateOutput(OutputType.LINK);
    }

    public Smoothing createAndRegisterSmoothing(String smoothingType) throws PlanItException {
        Smoothing smoothing = this.smoothingFactory.create(smoothingType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        this.parentAssignment.setSmoothing(smoothing);
        this.logRegisteredComponent(smoothing, true);
        return smoothing;
    }

    public PhysicalCost createAndRegisterPhysicalCost(String physicalTraveltimeCostFunctionType) throws PlanItException {
        PhysicalCost physicalCost = this.physicalCostFactory.create(physicalTraveltimeCostFunctionType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        this.parentAssignment.setPhysicalCost(physicalCost);
        this.logRegisteredComponent(physicalCost, true);
        return physicalCost;
    }

    public VirtualCost createAndRegisterVirtualCost(String virtualTraveltimeCostFunctionType) throws PlanItException {
        VirtualCost createdCost = this.virtualCostFactory.create(virtualTraveltimeCostFunctionType, new Object[]{this.parentAssignment.getIdGroupingtoken()});
        this.parentAssignment.setVirtualCost(createdCost);
        this.logRegisteredComponent(createdCost, true);
        return createdCost;
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.parentAssignment.registerOutputFormatter(outputFormatter);
        this.logRegisteredComponent(outputFormatter, true);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.parentAssignment.unregisterOutputFormatter(outputFormatter);
        this.logRegisteredComponent(outputFormatter, false);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.parentAssignment.getOutputFormatters();
    }

    public void registerInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost) {
        this.parentAssignment.setInitialLinkSegmentCost(initialLinkSegmentCost);
    }

    public void registerInitialLinkSegmentCost(InitialLinkSegmentCostPeriod initialLinkSegmentCost) throws PlanItException {
        this.registerInitialLinkSegmentCost(initialLinkSegmentCost.getTimePeriod(), initialLinkSegmentCost);
    }

    public void registerInitialLinkSegmentCost(TimePeriod timePeriod, InitialLinkSegmentCost initialLinkSegmentCost) throws PlanItException {
        PlanItException.throwIf(timePeriod == null, "time period null when registering initial link segment costs");
        this.parentAssignment.setInitialLinkSegmentCost(timePeriod, initialLinkSegmentCost);
    }

    public OutputTypeConfiguration activateOutput(OutputType outputType) throws PlanItException {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.parentAssignment.getId()) + "activated: OutputType." + outputType);
        return this.parentAssignment.activateOutput(outputType);
    }

    public void deactivateOutput(OutputType outputType) {
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.parentAssignment.getId()) + "deactivated: OutputType." + outputType);
        this.parentAssignment.deactivateOutput(outputType);
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.parentAssignment.isOutputTypeActive(outputType);
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.parentAssignment.getOutputConfiguration();
    }

    public GapFunction getGapFunction() {
        return this.parentAssignment.getGapFunction();
    }

    public PhysicalCost getPhysicalCost() {
        return this.parentAssignment.getPhysicalCost();
    }

    public VirtualCost getVirtualCost() {
        return this.parentAssignment.getVirtualCost();
    }

    public Smoothing getSmoothing() {
        return this.parentAssignment.getSmoothing();
    }
}

