/*
 * Decompiled with CFR 0.152.
 */
package org.planit.utils.cumulatives;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.planit.utils.cumulatives.CumulativePoint;
import org.planit.utils.exceptions.PlanItException;

public class PiecewiseLinearCumulativeCurve {
    private static final Logger LOGGER = Logger.getLogger(PiecewiseLinearCumulativeCurve.class.getCanonicalName());
    final LinkedList<CumulativePoint> cumulatives = new LinkedList();

    public void add(CumulativePoint cumulativePoint, double timeInSecondsEpsilon) throws PlanItException {
        CumulativePoint currentLast = this.cumulatives.getLast();
        if (!cumulativePoint.isLater(currentLast, timeInSecondsEpsilon)) {
            String errorMessage = "new cumulative point does not occur later than last available cumulative point in cumulative curve, this is not allowed";
            LOGGER.severe(errorMessage);
            throw new PlanItException(errorMessage);
        }
        this.cumulatives.add(cumulativePoint);
    }

    public double computeSurfaceUnderCurve() {
        double totalSurfaceUnderCurve = 0.0;
        CumulativePoint previousPoint = null;
        for (CumulativePoint currentPoint : this.cumulatives) {
            totalSurfaceUnderCurve += this.computeSurfaceUnderSegment(previousPoint, currentPoint);
            previousPoint = currentPoint;
        }
        return totalSurfaceUnderCurve;
    }

    private double computeSurfaceUnderSegment(CumulativePoint previousPoint, CumulativePoint currentPoint) {
        double surfaceUnderSegment = 0.0;
        if (previousPoint != null) {
            double width = previousPoint.getAbsTimeDifferenceWith(currentPoint);
            double rectangularSurface = previousPoint.getCumulativeCount() * width;
            double triangularSurface = previousPoint.getAbsCumulativeDifferenceWith(currentPoint) * width * 0.5;
            surfaceUnderSegment = rectangularSurface + triangularSurface;
        }
        return surfaceUnderSegment;
    }
}

