/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractCollection;
import org.djutils.immutablecollections.ImmutableAbstractSet;

public class ImmutableLinkedHashSet<E>
extends ImmutableAbstractSet<E> {
    private static final long serialVersionUID = 20160507L;

    public ImmutableLinkedHashSet(Collection<? extends E> collection) {
        super(new LinkedHashSet<E>(collection), Immutable.COPY);
    }

    public ImmutableLinkedHashSet(Set<E> collection, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new LinkedHashSet(collection) : collection, copyOrWrap);
    }

    public ImmutableLinkedHashSet(ImmutableAbstractCollection<? extends E> collection) {
        super(new LinkedHashSet<E>(collection.getUnderlyingCollection()), Immutable.COPY);
    }

    public ImmutableLinkedHashSet(ImmutableAbstractSet<E> set, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new LinkedHashSet(set.getUnderlyingCollection()) : set.getUnderlyingCollection(), copyOrWrap);
    }

    @Override
    protected Set<E> getUnderlyingCollection() {
        return super.getUnderlyingCollection();
    }

    @Override
    public final Set<E> toSet() {
        return new LinkedHashSet(this.getUnderlyingCollection());
    }

    @Override
    public final String toString() {
        Collection set = this.getUnderlyingCollection();
        if (null == set) {
            return "ImmutableLinkedHashSet []";
        }
        return "ImmutableLinkedHashSet [" + set.toString() + "]";
    }
}

