/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.operation.overlay;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.geotools.geometry.iso.coordinate.LineStringImpl;
import org.geotools.geometry.iso.coordinate.PointArrayImpl;
import org.geotools.geometry.iso.operation.overlay.OverlayOp;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.topograph2D.DirectedEdge;
import org.geotools.geometry.iso.topograph2D.DirectedEdgeStar;
import org.geotools.geometry.iso.topograph2D.Edge;
import org.geotools.geometry.iso.topograph2D.Label;
import org.geotools.geometry.iso.topograph2D.Node;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.util.Assert;
import org.geotools.geometry.iso.util.algorithm2D.PointLocator;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LineBuilder {
    private OverlayOp op;
    private CoordinateReferenceSystem crs;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List<OrientableCurve> resultLineList = new ArrayList<OrientableCurve>();

    public LineBuilder(OverlayOp op, CoordinateReferenceSystem crs, PointLocator ptLocator) {
        this.op = op;
        this.crs = crs;
        this.ptLocator = ptLocator;
    }

    public List<OrientableCurve> build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        for (Node node : this.op.getGraph().getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).findCoveredLineEdges();
        }
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            Edge e = de.getEdge();
            if (!de.isLineEdge() || e.isCoveredSet()) continue;
            boolean isCovered = this.op.isCoveredByA(de.getCoordinate());
            e.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            this.collectLineEdge(de, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de, opCode, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        Edge e = de.getEdge();
        if (de.isLineEdge() && !de.isVisited() && OverlayOp.isResultOfOp(label, opCode) && !e.isCovered()) {
            edges.add(e);
            de.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        if (de.isLineEdge()) {
            return;
        }
        if (de.isVisited()) {
            return;
        }
        if (de.isInteriorAreaEdge()) {
            return;
        }
        if (de.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!de.isInResult() && !de.getSym().isInResult() || !de.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label, opCode) && opCode == 1) {
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        for (Edge e : this.lineEdgesList) {
            Label label = e.getLabel();
            List<Position> positions = CoordinateArrays.toPositionList(this.crs, e.getCoordinates());
            LineStringImpl line = new LineStringImpl(new PointArrayImpl(positions), 0.0);
            LinkedList<LineStringImpl> tLineStrings = new LinkedList<LineStringImpl>();
            tLineStrings.add(line);
            CurveImpl curve = new CurveImpl(this.crs, tLineStrings);
            this.resultLineList.add(curve);
            e.setInResult(true);
        }
    }

    private void labelIsolatedLines(List edgesList) {
        for (Edge e : edgesList) {
            Label label = e.getLabel();
            if (!e.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedLine(e, 0);
                continue;
            }
            this.labelIsolatedLine(e, 1);
        }
    }

    private void labelIsolatedLine(Edge e, int targetIndex) {
        int loc = this.ptLocator.locate(e.getCoordinate(), this.op.getArgGeometry(targetIndex));
        e.getLabel().setLocation(targetIndex, loc);
    }
}

