/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

public class BasicMachine {
    private static final String BYTES = "bytes/";
    private static final String GIGA = "GB/";
    private static final String KILO = "kB/";
    private static final String MEGA = "MB/";
    private static final String THREAD = "thread";
    private static final String THREADS = "threads";
    public final long memory;
    public final int threads;

    public BasicMachine(long memory, int threads) {
        this.memory = memory;
        this.threads = threads;
    }

    private BasicMachine() {
        this(0L, 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicMachine)) {
            return false;
        }
        BasicMachine other = (BasicMachine)obj;
        if (this.memory != other.memory) {
            return false;
        }
        return this.threads == other.threads;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.memory ^ this.memory >>> 32);
        result = 31 * result + this.threads;
        return result;
    }

    public String toString() {
        int tmpPrefix = 1;
        int tmpMeasure = (int)(this.memory / 1024L);
        while (tmpMeasure / 1024 > 0) {
            ++tmpPrefix;
            tmpMeasure /= 1024;
        }
        switch (tmpPrefix) {
            case 1: {
                return tmpMeasure + KILO + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
            case 2: {
                return tmpMeasure + MEGA + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
            case 3: {
                return tmpMeasure + GIGA + this.threads + (this.threads == 1 ? THREAD : THREADS);
            }
        }
        return this.memory + BYTES + this.threads + (this.threads == 1 ? THREAD : THREADS);
    }
}

