/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import org.ojalgo.array.SparseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public final class SparseStore<N extends Number>
extends FactoryStore<N>
implements ElementsConsumer<N> {
    public static final Factory<ComplexNumber> COMPLEX = (rowsCount, columnsCount) -> SparseStore.makeComplex((int)rowsCount, (int)columnsCount);
    public static final Factory<Double> PRIMITIVE = (rowsCount, columnsCount) -> SparseStore.makePrimitive((int)rowsCount, (int)columnsCount);
    public static final Factory<RationalNumber> RATIONAL = (rowsCount, columnsCount) -> SparseStore.makeRational((int)rowsCount, (int)columnsCount);
    private final SparseArray<N> myElements;
    private final int[] myFirsts;
    private final int[] myLimits;
    private final ElementsConsumer.FillByMultiplying<N> myMultiplyer;

    public static SparseStore<ComplexNumber> makeComplex(int rowsCount, int columnsCount) {
        return new SparseStore<ComplexNumber>(GenericDenseStore.COMPLEX, rowsCount, columnsCount);
    }

    public static SparseStore<Double> makePrimitive(int rowsCount, int columnsCount) {
        return new SparseStore<Double>(PrimitiveDenseStore.FACTORY, rowsCount, columnsCount);
    }

    public static SparseStore<RationalNumber> makeRational(int rowsCount, int columnsCount) {
        return new SparseStore<RationalNumber>(GenericDenseStore.RATIONAL, rowsCount, columnsCount);
    }

    SparseStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myElements = ((SparseArray.SparseFactory)SparseArray.factory(factory.array(), this.count()).initial(Math.max(rowsCount, columnsCount))).make();
        this.myFirsts = new int[rowsCount];
        this.myLimits = new int[rowsCount];
        Arrays.fill(this.myFirsts, columnsCount);
        Class<?> tmpType = factory.scalar().zero().get().getClass();
        this.myMultiplyer = tmpType.equals(Double.class) ? MultiplyBoth.getPrimitive(rowsCount, columnsCount) : (tmpType.equals(ComplexNumber.class) ? MultiplyBoth.getGeneric(rowsCount, columnsCount) : null);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myElements.add(Structure2D.index((long)this.myFirsts.length, row, col), addend);
        this.updateNonZeros(row, col);
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myElements.add(Structure2D.index((long)this.myFirsts.length, row, col), addend);
        this.updateNonZeros(row, col);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myElements.doubleValue(Structure2D.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        this.myMultiplyer.invoke(this, left, (int)(left.count() / this.countRows()), right);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, (Number)values.get(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myElements.fillOne(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<N> supplier) {
        this.myElements.fillOne(Structure2D.index((long)this.myFirsts.length, row, col), supplier);
        this.updateNonZeros(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeFirst = tmpRowDim * col;
        int tmpRangeLimit = tmpRowDim * (col + 1);
        long tmpFirstInRange = this.myElements.firstInRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeFirst == tmpFirstInRange) {
            return 0;
        }
        return (int)(tmpFirstInRange % (long)tmpRowDim);
    }

    @Override
    public int firstInRow(int row) {
        return this.myFirsts[row];
    }

    @Override
    public N get(long row, long col) {
        return this.myElements.get(Structure2D.index((long)this.myFirsts.length, row, col));
    }

    @Override
    public int limitOfColumn(int col) {
        int tmpRowDim = this.myFirsts.length;
        int tmpRangeFirst = tmpRowDim * col;
        int tmpRangeLimit = tmpRangeFirst + tmpRowDim;
        long tmpLimitOfRange = this.myElements.limitOfRange(tmpRangeFirst, tmpRangeLimit);
        if ((long)tmpRangeLimit == tmpLimitOfRange) {
            return tmpRowDim;
        }
        return (int)tmpLimitOfRange % tmpRowDim;
    }

    @Override
    public int limitOfRow(int row) {
        return this.myLimits[row];
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        long tmpLimit = this.count();
        if (this.isPrimitive()) {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, modifier.invoke(this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLimit; ++i) {
                this.set(i, (Number)modifier.invoke(this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        boolean notModifiesZero;
        long limit = Math.min(left.count(), this.count());
        boolean bl = notModifiesZero = function.invoke(PrimitiveMath.E, PrimitiveMath.ZERO) == PrimitiveMath.ZERO;
        if (this.isPrimitive()) {
            if (notModifiesZero) {
                for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                    element.modify(left.doubleValue(element.index()), function);
                }
            } else {
                for (long i = 0L; i < limit; ++i) {
                    this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
                }
            }
        } else if (notModifiesZero) {
            for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                element.modify(left.get(element.index()), function);
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Number)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        boolean notModifiesZero;
        long limit = Math.min(this.count(), right.count());
        boolean bl = notModifiesZero = function.invoke(PrimitiveMath.ZERO, PrimitiveMath.E) == PrimitiveMath.ZERO;
        if (this.isPrimitive()) {
            if (notModifiesZero) {
                for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                    element.modify(function, right.doubleValue(element.index()));
                }
            } else {
                for (long i = 0L; i < limit; ++i) {
                    this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
                }
            }
        } else if (notModifiesZero) {
            for (SparseArray.NonzeroView element : this.myElements.nonzeros()) {
                element.modify(function, right.get(element.index()));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.set(i, (Number)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        if (this.isPrimitive()) {
            this.set(row, col, modifier.invoke(this.doubleValue(row, col)));
        } else {
            this.set(row, col, (Number)modifier.invoke(this.get(row, col)));
        }
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        if (this.isPrimitive()) {
            long structure = this.countColumns();
            long numberOfColumns = target.countColumns();
            target.reset();
            this.nonzeros().stream(true).forEach(element -> {
                long row = element.row();
                long col = element.column();
                double val = element.doubleValue();
                long first = MatrixUtils.firstInRow(right, col, 0L);
                long limit = MatrixUtils.limitOfRow(right, col, numberOfColumns);
                for (long j = first; j < limit; ++j) {
                    long index = Structure2D.index(structure, col, j);
                    double addition = val * right.doubleValue(index);
                    if (NumberContext.compare(addition, PrimitiveMath.ZERO) == 0) continue;
                    ElementsConsumer elementsConsumer = target;
                    synchronized (elementsConsumer) {
                        target.add(row, j, addition);
                        continue;
                    }
                }
            });
        } else {
            super.multiply(right, target);
        }
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        SparseStore retVal = new SparseStore(this.physical(), this.getRowDim(), this.getColDim());
        if (this.isPrimitive()) {
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), nonzero.doubleValue() * scalar);
            }
        } else {
            Scalar sclr = this.physical().scalar().convert(scalar);
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), (Number)((Scalar)sclr.multiply(nonzero.get())).get());
            }
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        if (right instanceof SparseStore) {
            SparseStore retVal = new SparseStore(this.physical(), this.getRowDim(), (int)right.countColumns());
            this.multiply(right, retVal);
            return retVal;
        }
        return super.multiply(right);
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        SparseStore retVal = new SparseStore(this.physical(), this.getRowDim(), this.getColDim());
        if (this.isPrimitive()) {
            double sclr = ((Number)scalar).doubleValue();
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), nonzero.doubleValue() * sclr);
            }
        } else {
            Scalar sclr = this.physical().scalar().convert((Number)scalar);
            for (ElementView2D nonzero : this.nonzeros()) {
                retVal.set(nonzero.index(), (Number)((Scalar)sclr.multiply(nonzero.get())).get());
            }
        }
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementView2D<N, ?> nonzeros() {
        return new Access2D.ElementView(this.myElements.nonzeros(), this.countRows());
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public ElementsConsumer<N> regionByColumns(int ... columns) {
        return new ElementsConsumer.ColumnsRegion<N>(this, this.myMultiplyer, columns);
    }

    @Override
    public ElementsConsumer<N> regionByLimits(int rowLimit, int columnLimit) {
        return new ElementsConsumer.LimitRegion<N>(this, this.myMultiplyer, rowLimit, columnLimit);
    }

    @Override
    public ElementsConsumer<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new ElementsConsumer.OffsetRegion<N>(this, this.myMultiplyer, rowOffset, columnOffset);
    }

    @Override
    public ElementsConsumer<N> regionByRows(int ... rows) {
        return new ElementsConsumer.RowsRegion<N>(this, this.myMultiplyer, rows);
    }

    @Override
    public ElementsConsumer<N> regionByTransposing() {
        return new ElementsConsumer.TransposedRegion<N>(this, this.myMultiplyer);
    }

    @Override
    public void reset() {
        this.myElements.reset();
        Arrays.fill(this.myFirsts, this.getColDim());
        Arrays.fill(this.myLimits, 0);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myElements.set(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myElements.set(Structure2D.index((long)this.myFirsts.length, row, col), value);
        this.updateNonZeros(row, col);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.reset();
        this.myElements.supplyNonZerosTo(receiver);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        long structure = this.countRows();
        long first = Structure2D.index(structure, row, col);
        long limit = Structure2D.index(structure, 0L, col + 1L);
        this.myElements.visitRange(first, limit, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        int counter = 0;
        if (this.isPrimitive()) {
            for (ElementView2D nzv : this.nonzeros()) {
                if (nzv.row() != row) continue;
                visitor.accept(nzv.doubleValue());
                ++counter;
            }
        } else {
            for (ElementView2D nzv : this.nonzeros()) {
                if (nzv.row() != row) continue;
                visitor.accept(nzv.get());
                ++counter;
            }
        }
        if (col + (long)counter < this.countColumns()) {
            visitor.accept(0.0);
        }
    }

    private void updateNonZeros(long row, long col) {
        this.updateNonZeros((int)row, (int)col);
    }

    void updateNonZeros(int row, int col) {
        this.myFirsts[row] = Math.min(col, this.myFirsts[row]);
        this.myLimits[row] = Math.max(col + 1, this.myLimits[row]);
    }

    public static interface Factory<N extends Number> {
        public SparseStore<N> make(long var1, long var3);
    }
}

