/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class SuperimposedStore<N extends Number>
extends ComposingStore<N> {
    private final int myColFirst;
    private final int myColLimit;
    private final MatrixStore<N> myDiff;
    private final int myRowFirst;
    private final int myRowLimit;

    SuperimposedStore(MatrixStore<N> base, int row, int column, MatrixStore<N> diff) {
        super(base, (int)base.countRows(), (int)base.countColumns());
        this.myRowFirst = row;
        this.myColFirst = column;
        int tmpDiffRowDim = (int)diff.countRows();
        int tmpDiffColDim = (int)diff.countColumns();
        this.myRowLimit = row + tmpDiffRowDim;
        this.myColLimit = column + tmpDiffColDim;
        this.myDiff = diff;
    }

    SuperimposedStore(MatrixStore<N> base, MatrixStore<N> diff) {
        this(base, 0, 0, diff);
    }

    @Override
    public double doubleValue(long row, long col) {
        double retVal = this.getBase().doubleValue(row, col);
        if (this.isCovered((int)row, (int)col)) {
            retVal += this.myDiff.doubleValue(row - (long)this.myRowFirst, col - (long)this.myColFirst);
        }
        return retVal;
    }

    @Override
    public N get(long row, long col) {
        Object retVal = this.getBase().get(row, col);
        if (this.isCovered((int)row, (int)col)) {
            retVal = ((Scalar)this.myDiff.toScalar((int)row - this.myRowFirst, (int)col - this.myColFirst).add(retVal)).get();
        }
        return retVal;
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        super.multiply(right, target);
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        return super.multiply(scalar);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return super.multiply(right);
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        return super.multiply((Number)scalar);
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.fillMatching(this.getBase());
        consumer.regionByLimits(this.myRowLimit, this.myColLimit).regionByOffsets(this.myRowFirst, this.myColFirst).modifyMatching(this.physical().function().add(), this.myDiff);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        Scalar retVal = this.getBase().toScalar(row, column);
        if (this.isCovered((int)row, (int)column)) {
            retVal = (Scalar)retVal.add(this.myDiff.get(row - (long)this.myRowFirst, column - (long)this.myColFirst));
        }
        return retVal;
    }

    private final boolean isCovered(int row, int column) {
        return this.myRowFirst <= row && this.myColFirst <= column && row < this.myRowLimit && column < this.myColLimit;
    }
}

