/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.Scalar;

public final class RotateRight
extends MatrixOperation {
    public static final RotateRight SETUP = new RotateRight();
    public static int THRESHOLD = 128;

    public static void invoke(double[] data, int structure, int colA, int colB, double cos, double sin) {
        int indexA = colA * structure;
        int indexB = colB * structure;
        for (int i = 0; i < structure; ++i) {
            double oldA = data[indexA];
            double oldB = data[indexB];
            data[indexA] = cos * oldA - sin * oldB;
            data[indexB] = cos * oldB + sin * oldA;
            ++indexA;
            ++indexB;
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int colA, int colB, N cos, N sin) {
        int indexA = colA * structure;
        int indexB = colB * structure;
        for (int i = 0; i < structure; ++i) {
            N oldA = data[indexA];
            N oldB = data[indexB];
            data[indexA] = ((Scalar)((ScalarOperation.Multiplication)((Object)cos)).multiply(oldA)).subtract((Scalar)((ScalarOperation.Multiplication)((Object)sin)).multiply(oldB)).get();
            data[indexB] = ((Scalar)((ScalarOperation.Multiplication)((Object)cos)).multiply(oldB)).add((Scalar)((ScalarOperation.Multiplication)((Object)sin)).multiply(oldA)).get();
            ++indexA;
            ++indexB;
        }
    }

    private RotateRight() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

