/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ojalgo.ProgrammingError;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public class RowView<N extends Number>
implements Access1D<N>,
Iterable<RowView<N>>,
Iterator<RowView<N>>,
Spliterator<RowView<N>>,
Comparable<RowView<N>> {
    static final int CHARACTERISTICS = 21845;
    private final Access2D<N> myDelegate2D;
    private final long myLastRow;
    private long myRow = -1L;

    private RowView(Access2D<N> access, long row, long lastRow) {
        this.myDelegate2D = access;
        this.myLastRow = access.countRows() - 1L;
        this.myRow = row;
    }

    protected RowView(Access2D<N> access) {
        this(access, -1L, access.countRows() - 1L);
    }

    @Override
    public int characteristics() {
        return 21845;
    }

    @Override
    public int compareTo(RowView<N> other) {
        return Long.compare(this.myRow, other.row());
    }

    @Override
    public long count() {
        return this.myDelegate2D.countColumns();
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate2D.doubleValue(this.myRow, index);
    }

    @Override
    public long estimateSize() {
        return this.myLastRow - this.myRow;
    }

    @Override
    public void forEachRemaining(Consumer<? super RowView<N>> action) {
        Iterator.super.forEachRemaining(action);
    }

    @Override
    public N get(long index) {
        return this.myDelegate2D.get(this.myRow, index);
    }

    @Override
    public boolean hasNext() {
        return this.myRow < this.myLastRow;
    }

    public boolean hasPrevious() {
        return this.myRow > 0L;
    }

    @Override
    public RowView<N> iterator() {
        return new RowView<N>(this.myDelegate2D);
    }

    @Override
    public RowView<N> next() {
        ++this.myRow;
        return this;
    }

    public RowView<N> previous() {
        --this.myRow;
        return this;
    }

    @Override
    public final void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    public long row() {
        return this.myRow;
    }

    public Stream<RowView<N>> stream(boolean parallel) {
        return StreamSupport.stream(this, parallel);
    }

    @Override
    public boolean tryAdvance(Consumer<? super RowView<N>> action) {
        if (this.hasNext()) {
            action.accept((RowView<N>)this.next());
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<RowView<N>> trySplit() {
        long remaining = this.myLastRow - this.myRow;
        if (remaining > 1L) {
            long split = this.myRow + remaining / 2L;
            RowView<N> retVal = new RowView<N>(this.myDelegate2D, this.myRow, split);
            this.myRow = split;
            return retVal;
        }
        return null;
    }

    protected void setRow(long row) {
        this.myRow = row;
    }
}

