/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class CalendarDateDuration
extends Number
implements TemporalAmount,
CalendarDate.Resolution,
Comparable<CalendarDateDuration> {
    public final double measure;
    public final CalendarDateUnit unit;

    public CalendarDateDuration(double aMeasure, CalendarDateUnit aUnit) {
        this.measure = aMeasure;
        this.unit = aUnit;
    }

    CalendarDateDuration() {
        this(PrimitiveMath.ZERO, CalendarDateUnit.MILLIS);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.toDurationInMillis(), CalendarDateUnit.MILLIS);
    }

    @Override
    public CalendarDate adjustInto(Calendar temporal) {
        return null;
    }

    @Override
    public CalendarDate adjustInto(Date temporal) {
        return null;
    }

    @Override
    public CalendarDate adjustInto(Temporal temporal) {
        return null;
    }

    @Override
    public int compareTo(CalendarDateDuration reference) {
        long tmpVal = this.toDurationInMillis();
        long refVal = reference.toDurationInMillis();
        return Long.signum(tmpVal - refVal);
    }

    public CalendarDateDuration convertTo(CalendarDateUnit newUnit) {
        double newMeasure = newUnit.convert(this.measure, this.unit);
        return new CalendarDateDuration(newMeasure, newUnit);
    }

    @Override
    public double doubleValue() {
        return this.measure;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalendarDateDuration)) {
            return false;
        }
        CalendarDateDuration other = (CalendarDateDuration)obj;
        if (Double.doubleToLongBits(this.measure) != Double.doubleToLongBits(other.measure)) {
            return false;
        }
        return this.unit == other.unit;
    }

    @Override
    public float floatValue() {
        return (float)this.measure;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == this.unit) {
            return (long)this.measure;
        }
        return 0L;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Collections.singletonList(this.unit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.measure);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.measure;
    }

    @Override
    public long longValue() {
        return (long)this.measure;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.toDurationInMillis(), CalendarDateUnit.MILLIS);
    }

    @Override
    public long toDurationInMillis() {
        return (long)(this.measure * (double)this.unit.size());
    }

    @Override
    public long toDurationInNanos() {
        return (long)(this.measure * (double)(1000000L * this.unit.size()));
    }

    public String toString() {
        return Double.toString(this.measure) + this.unit.getLabel();
    }
}

