/*
 * Decompiled with CFR 0.152.
 */
package org.planit.geo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.geometry.GeometryBuilder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.Position;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.planit.utils.exceptions.PlanItException;

public class PlanitGeoUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitGeoUtils.class.getCanonicalName());
    private static final DefaultGeographicCRS DEFAULT_GEOGRAPHIC_CRS = DefaultGeographicCRS.WGS84;
    private GeodeticCalculator geodeticDistanceCalculator;
    private GeometryBuilder geometryBuilder;
    private GeometryFactory geometryFactory;
    private PositionFactory positionFactory;

    public PlanitGeoUtils() {
        DefaultGeographicCRS coordinateReferenceSystem = new DefaultGeographicCRS(DEFAULT_GEOGRAPHIC_CRS);
        this.geometryBuilder = new GeometryBuilder(coordinateReferenceSystem);
        this.geodeticDistanceCalculator = new GeodeticCalculator(coordinateReferenceSystem);
        this.geometryFactory = this.geometryBuilder.getGeometryFactory();
        this.positionFactory = this.geometryBuilder.getPositionFactory();
    }

    public PlanitGeoUtils(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.geometryBuilder = new GeometryBuilder(coordinateReferenceSystem);
        this.geodeticDistanceCalculator = new GeodeticCalculator(coordinateReferenceSystem);
        this.geometryFactory = this.geometryBuilder.getGeometryFactory();
        this.positionFactory = this.geometryBuilder.getPositionFactory();
    }

    private double getDistanceInMetres(Position startPosition, Position endPosition) throws PlanItException {
        try {
            this.geodeticDistanceCalculator.setStartingPosition(startPosition);
            this.geodeticDistanceCalculator.setDestinationPosition(endPosition);
            return this.geodeticDistanceCalculator.getOrthodromicDistance();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when computing distance in meters between two Positions in GeoUtils", e);
        }
    }

    public double getDistanceInKilometres(Position startPosition, Position endPosition) throws PlanItException {
        return this.getDistanceInMetres(startPosition, endPosition) / 1000.0;
    }

    public DirectPosition getDirectPositionFromValues(double xCoordinate, double yCoordinate) throws PlanItException {
        Coordinate coordinate = new Coordinate(xCoordinate, yCoordinate);
        Coordinate[] coordinates = new Coordinate[]{coordinate};
        List<Position> positions = this.convertToDirectPositions(coordinates);
        return (DirectPosition)positions.get(0);
    }

    public org.opengis.geometry.coordinate.LineString convertToOpenGisLineString(LineString jtsLineString) throws PlanItException {
        Coordinate[] coordinates = jtsLineString.getCoordinates();
        List<Position> positionList = this.convertToDirectPositions(coordinates);
        return this.geometryFactory.createLineString(positionList);
    }

    public org.opengis.geometry.coordinate.LineString convertToOpenGisLineString(MultiLineString jtsMultiLineString) throws PlanItException {
        PlanItException.throwIf(jtsMultiLineString.getNumGeometries() > 1, "MultiLineString contains multiple LineStrings");
        return this.convertToOpenGisLineString((LineString)jtsMultiLineString.getGeometryN(0));
    }

    public List<Position> convertToDirectPositions(Coordinate[] coordinates) throws PlanItException {
        ArrayList<Position> positionList = new ArrayList<Position>(coordinates.length);
        for (Coordinate coordinate : coordinates) {
            DirectPosition newPosition = this.positionFactory.createDirectPosition(new double[]{coordinate.x, coordinate.y});
            positionList.add(newPosition);
        }
        return positionList;
    }
}

