/*
 * Decompiled with CFR 0.152.
 */
package org.planit.io.xml.network.physical.macroscopic;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.planit.input.InputBuilderListener;
import org.planit.network.physical.macroscopic.MacroscopicModePropertiesImpl;
import org.planit.utils.network.physical.Mode;
import org.planit.utils.network.physical.macroscopic.MacroscopicModeProperties;

public class MacroscopicLinkSegmentTypeXmlHelper {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentTypeXmlHelper.class.getCanonicalName());
    private Object externalId;
    private String name;
    private double capacityPerLane;
    private double maximumDensityPerLane;
    private Map<Mode, Double> speedMap;
    private Map<Mode, MacroscopicModeProperties> macroscopicLinkSegmentTypeModeProperties;
    private static Map<Object, MacroscopicLinkSegmentTypeXmlHelper> existingLinkTypeHelpers;

    private static void updateLinkSegmentTypeHelper(MacroscopicLinkSegmentTypeXmlHelper macroscopicLinkSegmentTypeXmlHelper, Mode mode, double maxSpeed, double critSpeed, Object linkTypeExternalId) {
        if (maxSpeed < 0.0) {
            LOGGER.warning("a negative maximum speed has been defined for Link Type " + macroscopicLinkSegmentTypeXmlHelper.getName() + " and Mode " + mode.getName() + ".  Setting the speed to zero instead (which means vehicles of this type are forbidden in links of this type.)");
            maxSpeed = 0.0;
        }
        macroscopicLinkSegmentTypeXmlHelper.getSpeedMap().put(mode, maxSpeed);
        MacroscopicModePropertiesImpl macroscopicModeProperties = new MacroscopicModePropertiesImpl(maxSpeed, critSpeed);
        macroscopicLinkSegmentTypeXmlHelper.addMacroscopicModeProperties(mode, macroscopicModeProperties);
        existingLinkTypeHelpers.put(linkTypeExternalId, macroscopicLinkSegmentTypeXmlHelper);
    }

    public static void reset() {
        existingLinkTypeHelpers = new HashMap<Object, MacroscopicLinkSegmentTypeXmlHelper>();
    }

    public static MacroscopicLinkSegmentTypeXmlHelper createOrUpdateLinkSegmentTypeHelper(String name, double capacityPerLane, double maximumDensityPerLane, double maxSpeed, double critSpeed, long modeExternalId, Object linkTypeExternalId, InputBuilderListener inputBuilderListener) {
        MacroscopicLinkSegmentTypeXmlHelper macroscopicLinkSegmentTypeXmlHelper;
        if (!existingLinkTypeHelpers.containsKey(linkTypeExternalId)) {
            if (capacityPerLane == 0.0) {
                LOGGER.warning("link Type " + name + " initially defined without a capacity, being given a capacity of zero.");
            }
            macroscopicLinkSegmentTypeXmlHelper = new MacroscopicLinkSegmentTypeXmlHelper(name, capacityPerLane, maximumDensityPerLane, linkTypeExternalId);
        } else {
            macroscopicLinkSegmentTypeXmlHelper = existingLinkTypeHelpers.get(linkTypeExternalId);
            if (capacityPerLane != macroscopicLinkSegmentTypeXmlHelper.getCapacityPerLane()) {
                LOGGER.warning("different capacity per lane values for Link Type " + macroscopicLinkSegmentTypeXmlHelper.getName() + ".  Will use the highest one.");
            }
            if (capacityPerLane > macroscopicLinkSegmentTypeXmlHelper.getCapacityPerLane()) {
                macroscopicLinkSegmentTypeXmlHelper.setCapacityPerLane(capacityPerLane);
            }
            if (maximumDensityPerLane != macroscopicLinkSegmentTypeXmlHelper.getMaximumDensityPerLane()) {
                LOGGER.warning("different maximum density per lane values for link type " + macroscopicLinkSegmentTypeXmlHelper.getName() + ".  Will use the highest one.");
            }
            if (maximumDensityPerLane > macroscopicLinkSegmentTypeXmlHelper.getMaximumDensityPerLane()) {
                macroscopicLinkSegmentTypeXmlHelper.setMaximumDensityPerLane(maximumDensityPerLane);
            }
        }
        if (modeExternalId == 0L) {
            inputBuilderListener.getAllModes().forEach(eachMode -> MacroscopicLinkSegmentTypeXmlHelper.updateLinkSegmentTypeHelper(macroscopicLinkSegmentTypeXmlHelper, eachMode, maxSpeed, critSpeed, linkTypeExternalId));
        } else {
            Mode mode = inputBuilderListener.getModeByExternalId(modeExternalId);
            MacroscopicLinkSegmentTypeXmlHelper.updateLinkSegmentTypeHelper(macroscopicLinkSegmentTypeXmlHelper, mode, maxSpeed, critSpeed, linkTypeExternalId);
        }
        return macroscopicLinkSegmentTypeXmlHelper;
    }

    public MacroscopicLinkSegmentTypeXmlHelper(String name, double capacityPerLane, double maximumDensityPerLane, Object externalId) {
        this.name = name;
        this.capacityPerLane = capacityPerLane;
        this.maximumDensityPerLane = maximumDensityPerLane;
        this.externalId = externalId;
        this.speedMap = new HashMap<Mode, Double>();
        this.macroscopicLinkSegmentTypeModeProperties = new HashMap<Mode, MacroscopicModeProperties>();
    }

    public String getName() {
        return this.name;
    }

    public double getCapacityPerLane() {
        return this.capacityPerLane;
    }

    public void setCapacityPerLane(double capacityPerLane) {
        this.capacityPerLane = capacityPerLane;
    }

    public double getMaximumDensityPerLane() {
        return this.maximumDensityPerLane;
    }

    public void setMaximumDensityPerLane(double maximumDensityPerLane) {
        this.maximumDensityPerLane = maximumDensityPerLane;
    }

    public Map<Mode, Double> getSpeedMap() {
        return this.speedMap;
    }

    public Object getExternalId() {
        return this.externalId;
    }

    public Map<Mode, MacroscopicModeProperties> getModePropertiesMap() {
        return this.macroscopicLinkSegmentTypeModeProperties;
    }

    public void addMacroscopicModeProperties(Mode mode, MacroscopicModeProperties macroscopicModeProperties) {
        this.macroscopicLinkSegmentTypeModeProperties.put(mode, macroscopicModeProperties);
    }
}

