/*
 * Decompiled with CFR 0.152.
 */
package org.planit.network.physical;

import java.util.HashMap;
import java.util.Map;
import org.planit.graph.EdgeSegmentImpl;
import org.planit.utils.id.IdGenerator;
import org.planit.utils.id.IdGroupingToken;
import org.planit.utils.network.physical.Link;
import org.planit.utils.network.physical.LinkSegment;
import org.planit.utils.network.physical.Mode;

public abstract class LinkSegmentImpl
extends EdgeSegmentImpl
implements LinkSegment {
    private static final long serialVersionUID = -4893553215218232006L;
    protected final long linkSegmentId;
    protected int numberOfLanes = 1;
    protected Map<Mode, Double> maximumSpeedMap = new HashMap<Mode, Double>();

    protected static int generateLinkSegmentId(IdGroupingToken groupId) {
        return IdGenerator.generateId(groupId, LinkSegment.class);
    }

    protected LinkSegmentImpl(IdGroupingToken groupId, Link parentLink, boolean directionAB) {
        super(groupId, parentLink, directionAB);
        this.linkSegmentId = LinkSegmentImpl.generateLinkSegmentId(groupId);
    }

    @Override
    public long getLinkSegmentId() {
        return this.linkSegmentId;
    }

    @Override
    public int getNumberOfLanes() {
        return this.numberOfLanes;
    }

    @Override
    public void setNumberOfLanes(int numberOfLanes) {
        this.numberOfLanes = numberOfLanes;
    }

    @Override
    public double getMaximumSpeed(Mode mode) {
        return this.maximumSpeedMap.get(mode);
    }

    @Override
    public void setMaximumSpeed(Mode mode, double maximumSpeed) {
        this.maximumSpeedMap.put(mode, maximumSpeed);
    }

    @Override
    public Link getParentLink() {
        return (Link)this.getParentEdge();
    }
}

